
/* Command line frontend to ccd client library

   night_power
   
       controls the connecting, switching on and off of the CCD camera

  $Id: night_power.c,v 1.7 2008-02-23 22:48:11 hroch Exp $

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "nightview.h"
#include "ccdtypes.h"
#include "ccd.h"
#include "ccdcommon.h"


int main(int argc, char *argv[])
{
  int on = 0;
  int off = 0;
  int info = 0;
  int login = 0;
  int i,j;
  CCD *ccd = NULL;
  char *host = NIGHT_LOCALHOST;
  void show_help(void);
  int nchips, nread;
  
  host = getenv(NIGHTVIEW_HOST);
  if( host == NULL )
    host = NIGHT_LOCALHOST;
  
  if( argc == 1 ) {
    show_help();
    return(0);
  }  

  for( i = 1; i < argc; i++) {

    if( strcmp(argv[i],"-h") == 0 || strcmp(argv[i],"--help") == 0 ) {
      show_help();
      return(0);
    }

    else if( (strcmp(argv[i],"--version") == 0) ) {
      printf("%s\n",COOLVER);
      return(0);
    }

    else if( strcmp(argv[i],"on") == 0 ) {
      on = 1;
    }

    else if( strcmp(argv[i],"off") == 0 ) {
      off = 1;
    }

    else if( strcmp(argv[i],"info") == 0 ) {
      info = 1;
    }

    else if( strcmp(argv[i],"login") == 0 ) {
      login = 1;
    }

    /* set server address */
    else if( strcmp(argv[i],"-host") == 0 && i++ <= argc ) {
      host = argv[i];
    }

    else
      fprintf(stderr,"Unrecognized option: %s\n",argv[i]);

  }

  /* connect to server */
  /*
  if( ! ccd_login(host) ) {
    fprintf(stderr,"Connection to %s failed.\n",host);
    return(1);
  }
  */

  if( (ccd = ccd_init(host)) == NULL ) {
    fprintf(stderr,"Camera init at %s failed.\n",host);
    return(1);
  }

  if( login ) {
    printf("Successfully connected to camera at %s.\n",host);
    ccd_free(ccd);
    return(0);
  }


  /* link to the camera, init */
  if( on ) {
    if( ! ccd_connect(ccd) ) {
      ccd_free(ccd);
      fprintf(stderr,"Switch on camera failed or camera not connected\n");
      return(1);
    }
  }

  if( info ) {

    if( ccd_connected(ccd) ) {

      nchips = ccd_nchiplist(ccd);
      for( i = 0; i < nchips; i++ ) {
      
	if( i == 0 )
	  printf("Imaging CCD chip: %s\n",ccd_get_cameraname(ccd,i));
	else
	  printf("Tracking CCD chip: %s\n",ccd_get_cameraname(ccd,i));

	printf("Readout modes:\n");
	printf(" mode  image size   pixel dimension   gain \n");
	printf("        [pixels]       [microns]      [ADU]\n");       
      
	nread = ccd_get_nreadout(ccd,i);
	for( j = 0; j < nread; j++ )
	  printf("  %d   %4d x%4d     %4.1f x %4.1f      %.2f\n",
		 ccd_get_readout_mode(ccd,i,j),
		 ccd_get_readout_width(ccd,i,j),
		 ccd_get_readout_height(ccd,i,j),
		 ccd_get_readout_pixsize(ccd,i,j),
		 ccd_get_readout_piysize(ccd,i,j),
		 ccd_get_readout_gain(ccd,i,j));
      }
    }
    else {
      ccd_free(ccd);
      fprintf(stderr,"No info available.\n");
      return(1);
    }
  }
	
  if( off ) {
    if( ! ccd_shutdown(ccd) ) {
      ccd_free(ccd);      
      fprintf(stderr,"Camera switch off failed.\n");
      return(1);
    }
  }

  ccd_free(ccd);
  return(0);
}

void show_help(void)
{
  printf("%s\n",COOLVER);
  printf("night_power - control the power of camera\n");
  printf("Usage: night_power {on|off|info} [-host address]\n");
  printf("options:\n");
  printf("\t on\t switch on camera, failed if cammera not connected\n");
  printf("\t off\t switch off camera\n");
  printf("\t info\t print short info about camera\n");
  printf("\t login\t login into server (test of connection)\n");
  printf("\t -host address:port internet address server, default: local connect\n");
  printf("Setting of environment variable %s is equivalent to -host option.\n",
	 NIGHTVIEW_HOST);
  printf("\n");
}
