
/*

  Xmove - preferences

  $Id: preferences.cpp,v 1.4 2008-02-17 16:18:44 hroch Exp $

*/


// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

// for all others, include the necessary headers (this file is usually all you
// need because it includes almost all "standard" wxWidgets headers)
#ifndef WX_PRECOMP
    #include "wx/wx.h"
#endif
#include <wx/spinctrl.h>
#include <wx/notebook.h>
#include "xmove.h"
#include "base64.h"

BEGIN_EVENT_TABLE(PrefFrame, wxPropertySheetDialog)
     EVT_RADIOBUTTON(ID61, PrefFrame::PreferRadio)
     EVT_RADIOBUTTON(ID62, PrefFrame::PreferRadio)
END_EVENT_TABLE()


PrefFrame::PrefFrame(wxWindow* parent, const wxChar* title, long style):
    wxPropertySheetDialog(parent,wxID_ANY,title,wxDefaultPosition,wxDefaultSize,style)
{
  const int okr = 10;

  CreateButtons(wxOK | wxCANCEL);

  wxPanel *update = new wxPanel(GetBookCtrl());
  GetBookCtrl()->AddPage(update, _("Update"));

  wxBoxSizer *usizer = new wxBoxSizer(wxVERTICAL);
  wxFlexGridSizer *us = new wxFlexGridSizer(2,2,5,5);
  wxStaticText *txt_udelay = new wxStaticText(update,wxID_ANY,_(" Self update time interval (sec): "));
  us->Add(txt_udelay,wxSizerFlags().Align(wxALIGN_CENTER_VERTICAL));
  udelay = new wxSpinCtrl(update,wxID_ANY,_("1"),wxDefaultPosition,wxDefaultSize,wxSP_ARROW_KEYS,1,3600);
  us->Add(udelay);
  wxStaticText *txt_sdelay = new wxStaticText(update,wxID_ANY,_(" Slew update time interval (sec): "));
  us->Add(txt_sdelay,wxSizerFlags().Align(wxALIGN_CENTER_VERTICAL));
  sdelay = new wxSpinCtrl(update,wxID_ANY,_("1"),wxDefaultPosition,wxDefaultSize,wxSP_ARROW_KEYS,1,3600);
  us->Add(sdelay);
  usizer->Add(us,wxSizerFlags().Border(wxALL,okr));
  update->SetSizerAndFit(usizer);

  wxPanel *net = new wxPanel(GetBookCtrl());
  GetBookCtrl()->AddPage(net, _("Connection"));

  wxBoxSizer *nsizer = new wxBoxSizer(wxVERTICAL);
  local = new wxRadioButton(net,ID61,_(" Local connection "),
				 wxDefaultPosition, wxDefaultSize,wxRB_GROUP);
  nsizer->Add(local,wxSizerFlags().Border(wxALL,okr));
  remote = new wxRadioButton(net,ID62,_(" Remote to host "),
				  wxDefaultPosition, wxDefaultSize);
  nsizer->Add(remote,wxSizerFlags().Border(wxLEFT,okr));

  wxBoxSizer *ns1 = new wxBoxSizer(wxHORIZONTAL);
  wxStaticText *txt_host = new wxStaticText(net,wxID_ANY,_("Host:"));
  ns1->Add(txt_host,wxSizerFlags(1).Align(wxALIGN_CENTER_VERTICAL).Border(wxRIGHT,3));
  host = new wxTextCtrl(net,wxID_ANY);
  ns1->Add(host,wxSizerFlags(4).Expand().Border(wxRIGHT,5));
  wxStaticText *txt_port = new wxStaticText(net,wxID_ANY,_("Port:"));
  ns1->Add(txt_port,wxSizerFlags(1).Align(wxALIGN_CENTER_VERTICAL).Border(wxRIGHT,3));
  port = new wxSpinCtrl(net,wxID_ANY,_("7666"),wxDefaultPosition,wxDefaultSize,wxSP_ARROW_KEYS,0,65535);
  ns1->Add(port,wxSizerFlags(2));
  nsizer->Add(ns1,wxSizerFlags().Border(wxLEFT,okr));
  
  wxBoxSizer *ns2 = new wxBoxSizer(wxHORIZONTAL);
  wxStaticText *txt_user = new wxStaticText(net,wxID_ANY,_("User:"));
  ns2->Add(txt_user,wxSizerFlags(1).Align(wxALIGN_CENTER_VERTICAL).Border(wxRIGHT,3));
  user = new wxTextCtrl(net,wxID_ANY);
  ns2->Add(user,wxSizerFlags(3).Expand().Border(wxRIGHT,5));
  wxStaticText *txt_pass = new wxStaticText(net,wxID_ANY,_("Password:"));
  ns2->Add(txt_pass,wxSizerFlags(2).Align(wxALIGN_CENTER_VERTICAL));
  pass = new wxTextCtrl(net,wxID_ANY,_(""),wxDefaultPosition,wxDefaultSize,wxTE_PASSWORD);
  ns2->Add(pass,wxSizerFlags(3).Expand().Border(wxRIGHT,5));
  nsizer->Add(ns2,wxSizerFlags().Border(wxALL,okr));
  net->SetSizerAndFit(nsizer);

  wxPanel *park = new wxPanel(GetBookCtrl());
  GetBookCtrl()->AddPage(park, _("Park position"));
  wxBoxSizer *psizer = new wxBoxSizer(wxVERTICAL);
  wxBoxSizer *ps = new wxBoxSizer(wxHORIZONTAL);
  wxStaticText *txt_ha = new wxStaticText(park,wxID_ANY,_("Hour angle: "));
  ps->Add(txt_ha,wxSizerFlags().Align(wxALIGN_CENTER_VERTICAL));
  ha = new wxTextCtrl(park,wxID_ANY,_(" 0.0 "));
  ps->Add(ha);
  wxStaticText *txt_dec = new wxStaticText(park,wxID_ANY,_(" Declination: "));
  ps->Add(txt_dec,wxSizerFlags().Align(wxALIGN_CENTER_VERTICAL));
  decl = new wxTextCtrl(park,wxID_ANY,_(" 0.0 "));
  ps->Add(decl);
  psizer->Add(ps,wxSizerFlags().Border(wxALL,okr));
  park->SetSizerAndFit(psizer);

  LayoutDialog();
}

void PrefFrame::PreferRadio(wxCommandEvent& WXUNUSED(event))
{
  if( local->GetValue() ) {
    host->Enable(false);
    port->Enable(false);
    user->Enable(false);
    pass->Enable(false);
  }

  if( remote->GetValue() ) {
    host->Enable(true);
    port->Enable(true);
    user->Enable(true);
    pass->Enable(true);
  }
}

void PrefFrame::set_udelay(const int t)
{
  udelay->SetValue(t);
}

void PrefFrame::set_sdelay(const int t)
{
  sdelay->SetValue(t);
}

void PrefFrame::set_port(const int t)
{
  port->SetValue(t);
}

void PrefFrame::set_local(const bool loc)
{
  if( loc ) {
    local->SetValue(true);
    host->Enable(false);
    port->Enable(false);
    user->Enable(false);
    pass->Enable(false);
  }    
  else {
    remote->SetValue(true);
    host->Enable(true);
    port->Enable(true);
    user->Enable(true);
    pass->Enable(true);
  }
}

void PrefFrame::set_host(const wxString& t)
{
  host->SetValue(t);
}

void PrefFrame::set_ha(const double t)
{
  wxString l;
  l.Printf(_("%.3f"),t);
  ha->SetValue(l);
}

void PrefFrame::set_decl(const double t)
{
  wxString l;
  l.Printf(_("%.3f"),t);
  decl->SetValue(l);
}

int PrefFrame::get_udelay()
{
  return udelay->GetValue();
}

int PrefFrame::get_sdelay()
{
  return sdelay->GetValue();
}

int PrefFrame::get_port()
{
  return port->GetValue();
}

bool PrefFrame::get_local()
{
  return local->GetValue();
}

wxString PrefFrame::get_host()
{
  return host->GetValue();
}

double PrefFrame::get_ha()
{
  wxString l = ha->GetValue();
  double x;
  l.ToDouble(&x);
  return x;
}

double PrefFrame::get_decl()
{
  wxString l = decl->GetValue();
  double x;
  l.ToDouble(&x);
  return x;
}

wxString PrefFrame::get_auth()
{
  wxString u = user->GetValue();
  wxString p = pass->GetValue();

  if( u.IsEmpty() || p.IsEmpty() )
    
    return(_(""));

  else {
  
    wxString xauth = u + _(":") + p;

    size_t l64 = BASE64_LENGTH(xauth.Len())+1;
    char *auth64 = new char[l64];

    base64_encode(xauth.mb_str(),(size_t)xauth.Len(),auth64,l64);
    
    wxString auth(auth64,wxConvUTF8);
    delete auth64;

    return auth;
  }
}

void PrefFrame::set_auth(const wxString& auth)
{

  if( auth.IsEmpty() ) {

    user->SetValue(_(""));
    pass->SetValue(_(""));
    
  }
  else {

    size_t l64 = BASE64_LENGTH(auth.Len())+1;
    char *auth64 = new char[l64];
    base64_decode(auth.mb_str(),(size_t)auth.Len(),auth64,&l64);
    
    wxString xauth(auth64,wxConvUTF8);
    delete auth64;
    
    user->SetValue(xauth.Before(':'));
    pass->SetValue(xauth.After(':'));
  }
}
