
/*

  Xmove

  $Id: simbad.cpp,v 1.3 2007-08-02 19:06:39 hroch Exp $

*/

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

// for all others, include the necessary headers (this file is usually all you
// need because it includes almost all "standard" wxWidgets headers)
#ifndef WX_PRECOMP
    #include "wx/wx.h"
#endif
#include <wx/url.h>
#include <wx/sstream.h>
#include <wx/html/htmlpars.h>

#include "xmove.h"


void TextBracket::Parse(const wxString& t)
{
  int n = 0;
  text = t;
  while( true ) {
  
     int l = text.Find(lb);
     int r = text.Find(rb);
     if( l == -1 || r == -1 )
       return;
     int i = l + lb.Len();
     int j = r + rb.Len();
     wxString s = text.Mid(i,r - i);
     this->Add(s);

     n += j;
     text = t.Mid(n);
  }
}

void SimbadItem::Parse()
{
  TextBracket tabledata(_("<TABLEDATA>"),_("</TABLEDATA>"));
  tabledata.Parse(data);
  if( tabledata.GetCount() == 1 ) {
    TextBracket tr(_("<TR>"),_("</TR>"));
    tr.Parse(tabledata.Item(0));
    for(size_t i = 0; i < tr.GetCount(); i++) {
      
      TextBracket td(_("<TD>"),_("</TD>"));
      td.Parse(tr.Item(i));

      wxString line;
      for(size_t j = 0; j < td.GetCount() && j < 3; j++) {

	line.Append(td.Item(j));
	if( j == 2 ) break;
	line.Append('\t');
      }
      if( ! line.empty() )
	Add(line);
    }
  }
}


bool Simbad::Connect()
{

  // create the query escaped string
  wxString s(_("http://simbad.u-strasbg.fr/simbad/sim-script?"));
  wxString q(_("submit=submit script&script=votable { main_id, coordinates }\nvotable open\nquery id ")+object+_("\nvotable close\n"));
  wxURI uri;
  uri.Create(s+q);
  wxString a = uri.BuildUnescapedURI();
  //wxPrintf(_("%s\n"),uri.GetQuery().c_str());

  // try internet oracle
  //wxURL url(_("http://integral.physics.muni.cz/"));
  wxURL url(a);
  if (url.GetError() == wxURL_NOERR) {
    wxInputStream *http;
    http = url.GetInputStream();
    wxStringOutputStream page;
    http->Read(page);

    wxString p = page.GetString();

    if( p.Find(_("::error::")) > -1 )
      return false;
      
    int data = p.Find(_("::data::"));
    int xmlstart = p.Find(_("<?xml"));
    if( data > -1 && xmlstart > -1 ) {

      SimbadItem sim(p);
      sim.Parse();
      for(size_t i = 0; i < sim.GetCount(); i++) {
	Add(sim.Item(i));
	//	wxPrintf(_("%s\n"),sim.Item(i).c_str());
      }

      return true;

    }

  }
  return false;
}
