
/*

  Xmove
  $Id: xmove.h,v 1.18 2008-02-17 16:18:22 hroch Exp $

*/

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

// for all others, include the necessary headers (this file is usually all you
// need because it includes almost all "standard" wxWidgets headers)
#ifndef WX_PRECOMP
    #include "wx/wx.h"
#endif
#include <wx/process.h>
#include <wx/config.h>
#include <wx/tglbtn.h>
#include <wx/propdlg.h> 
#include <wx/spinctrl.h>
#include <wx/generic/propdlg.h>

enum
{
  ID15,ID16,ID17,ID18,
  ID20,ID21,ID22,ID23,ID24,ID25,ID26,ID27,ID28,ID29,
  ID31,ID32,ID33,ID34,
  ID41,ID42,ID43,ID44,ID45,ID46,ID47,ID48,
  ID50,ID51,ID52,ID53,ID54,ID55,ID56,ID57,ID58,ID59,
  ID61,ID62,
  ID71,ID72,ID73,ID74,
  ID81,ID82,ID83,ID84,ID85,ID86
};

class Catalogue;

class XMove : public wxApp
{
public:
    virtual bool OnInit();
};

class MoveConfig : public wxConfig
{
 public:
  MoveConfig(wxString name);
  ~MoveConfig();

  int Udelay() { return udelay; }
  int Sdelay() { return sdelay; }
  bool Localhost() { return localhost; }
  wxString Remotehost() { return remotehost; }
  int Port() { return port; }
  wxString AuthKey() { return authkey; }
  double ParkHA() { return park_ha; }
  double ParkDecl() { return park_decl; }

  void Set_Udelay(int d) { udelay = d; }
  void Set_Sdelay(int d) { sdelay = d; }
  void Set_Localhost(bool l) { localhost = l; }
  void Set_Remotehost(wxString h) { remotehost = h; }
  void Set_Port(int p) { port = p; }
  void Set_AuthKey(wxString a) { authkey = a; }
  void Set_ParkHA(double x) { park_ha = x; }
  void Set_ParkDecl(double x) { park_decl = x; }

 private:
  
  int udelay,sdelay;
  bool localhost;
  wxString remotehost,authkey;
  int port;
  double park_ha, park_decl;
};


class MoveFrame : public wxFrame
{
 public:
  MoveFrame(wxString title);
  ~MoveFrame() { delete conf; }
  void Open(wxCommandEvent& WXUNUSED(event));
  void Exit(wxCommandEvent& WXUNUSED(event));
  void About(wxCommandEvent& WXUNUSED(event));
  void Calibrate(wxCommandEvent& WXUNUSED(event));
  void OnEndCalibrate(wxProcessEvent& event);
  void Parking(wxCommandEvent& WXUNUSED(event));
  void Clock(wxCommandEvent& WXUNUSED(event));
  void ClockSwitch(bool);
  void OnEndClockSwitch(wxProcessEvent& event);
  void ClockOnOff(wxCommandEvent& WXUNUSED(event));
  void Step(wxCommandEvent& WXUNUSED(event));
  void Up(wxCommandEvent& WXUNUSED(event));
  void OnEndUp(wxProcessEvent& event);
  void Down(wxCommandEvent& WXUNUSED(event));
  void OnEndDown(wxProcessEvent& event);
  void Left(wxCommandEvent& WXUNUSED(event));
  void OnEndLeft(wxProcessEvent& event);
  void Right(wxCommandEvent& WXUNUSED(event));
  void OnEndRight(wxProcessEvent& event);
  void GetObject(wxCommandEvent& WXUNUSED(event));
  void ComboObject(wxCommandEvent& WXUNUSED(event));
  void Velra(wxScrollEvent& WXUNUSED(event));
  void Veldec(wxScrollEvent& WXUNUSED(event));
  void OnClose(wxCloseEvent&);
  void OnSize(wxSizeEvent& event);
  void LoadObject(wxArrayString&,const wxString&);
  void SaveObject(wxArrayString&, const wxString&);
  void CooUpdate(void);
  void EndCooUpdate(wxProcessEvent& event);
  void OnUpdate(wxTimerEvent& event);
  void OnSlew(wxTimerEvent& event);
  void OnEndSlew(wxProcessEvent& event);
  void Slew(wxCommandEvent& event);
  void SlewOn(wxCommandEvent& event);
  void InitMaxVel(double&, double&);
  bool InitClock();
  void ShowCoordinates(const wxArrayString&);
  void Preferences(wxCommandEvent& WXUNUSED(event));
  void PreferRadio(wxCommandEvent& WXUNUSED(event));
  //  void InitPrefer(const wxString&);
  //void SavePrefer(const wxString&);
  void OpenCatalogue(const wxString&);

 private:

  double sixdeg(wxString);
  double adeg(wxString);
  double ddeg(wxString);
  wxString asix(double); 
  wxString dsix(double); 


  // menu act
  wxMenu *menuAct;

  // status bar
  wxGauge *progress;

  // input box
  wxComboBox *cb;
  wxButton *gobj,*calibr;
  wxToggleButton *slewto;
  wxTextCtrl *alfa, *delta;
  Catalogue *catalogue;
  bool inlist;

  // display of coordinates
  wxTextCtrl *ra,*dec,*az,*al,*jd,*ha,*ara,*adec,*mhc;
  wxButton *update;
  wxStaticBitmap *synchro;
  
  // velocity
  wxSlider *velra, *veldec;
  double maxvra, maxdec;
  double vra,vdec;

  // step
  wxRadioBox *step;
  double dstep;

  // direction
  wxButton *up,*down,*right,*left;

  // clock
  wxRadioBox *clock;
  bool clockup;

  // updating
  wxTimer UpdateTimer;
  wxProcess *UpdateProc;
  //int udelay;

  // slewing
  wxTimer SlewTimer;
  wxProcess *SlewProc;
  wxString slewcom;
  long slewpid;
  //  int sdelay;

  // preferences
  MoveConfig *conf;
  //bool localhost;
  //wxString remotehost,user,pass;
  //int port;
  //double park_ha, park_decl;
  void connection_setup(bool,wxString,int,wxString);

  // short time exec processes
  wxProcess *CalProc,*ClockProc,*UpProc,*DownProc,*LeftProc,*RightProc;

  DECLARE_EVENT_TABLE()
};

class TextBracket: public wxArrayString
{
public:
  TextBracket(const wxString& l, const wxString& r): lb(l), rb(r) { }
  void Parse(const wxString& t);

private:
  wxString lb, rb;
  wxString text;
};

class SimbadItem: public wxArrayString
{
  public:
  SimbadItem(const wxString& d): data(d) { }
  void Parse();
  
  private:
    wxString data;
};

class Simbad: public wxArrayString
{
 public:
  Simbad(wxString o): object(o) {}
  bool Connect();

 private:
  wxString object;

};

class Catalogue: public wxArrayString
{
 public:
  Catalogue(): writable(false), iitem(-1) {}
  bool Load(const wxString&,bool=false);
  bool Save(const wxString&);
  void Objects(wxArrayString&);
  bool IsWritable() { return writable; }
  wxString Name(size_t);
  wxString Alpha(size_t);
  wxString Delta(size_t);
  int FindName(wxString);

 private:
  bool writable;
  int iitem;
  wxString name1,alpha1,delta1;
  void Select(size_t);

};

class PrefFrame: public wxPropertySheetDialog
{
 public:
  PrefFrame(wxWindow*, const wxChar*, long style);
  ~PrefFrame() {}
  void set_udelay(const int);
  void set_sdelay(const int);
  void set_port(const int);
  void set_local(const bool);
  void set_host(const wxString&);
  void set_auth(const wxString&);
  void set_ha(const double);
  void set_decl(const double);
  
  int get_udelay();
  int get_sdelay();
  int get_port();
  bool get_local();
  wxString get_host();
  wxString get_auth();
  double get_ha();
  double get_decl();

 private:

  void PreferRadio(wxCommandEvent& WXUNUSED(event));

  wxRadioButton *local,*remote;
  wxTextCtrl *host,*user,*pass,*ha,*decl;
  wxSpinCtrl *sdelay,*udelay,*port;  

  DECLARE_EVENT_TABLE()
};
