#!/usr/bin/env python
#
# xmove
#
# $Id: xmove.py,v 1.9 2007-06-03 10:43:16 hroch Exp $
#

from wxPython.wx import *

def xmoveExe(command):
    import popen2, string 

    print "Lunching command: '",command,"'"

    (stdout, stdin, stderr) = popen2.popen3(command)
    response = stdout.read()

    error = stderr.read()
#    string.replace(error,"\0","")
#    string.replace(error,"\r","")
    stdout.close()
    stdin.close()
    stderr.close()

    if error != "":
      print "Error appeared:",error
    return (response,error)


def xmoveRun(command):
    import popen2
#    print "Lunching and reading from command:",command
    try:
       (stdout, stdin, stderr) = popen2.popen3(command)
       response = stdout.readlines()
       error = stderr.read()
       stdout.close()
       stdin.close()
       stderr.close()
       return (response,error)
    except:
       return []

def GetWebObject(object):
    import urllib, string

    if object == "":
      return [ "0:0:0", "0:0:0" ]

    url1 = 'http://simbad.u-strasbg.fr/sim-id.pl?protocol=html&Ident=sirius&NbIdent=1&Radius=10&Radius.unit=arcmin&CooFrame=FK5&CooEpoch=2000&CooEqui=2000&output.max=all&o.catall=on&output.mesdisp=N&Bibyear1=1983&Bibyear2=2004&Frame1=FK5&Frame2=FK4'

    obj = urllib.quote_plus(object)
    url = string.replace(url1,"sirius",obj)

    u = urllib.urlopen(url)
    lines = u.readlines()
    u.close()
    j = i = 0
    for l in lines:
       if "FK5 2000/2000 coordinates" in l:
          j = i + 3
       i = i + 1
    coo = string.replace(lines[j],">"," ")
    coo = string.replace(coo,"<"," ")
    coo = string.split(coo)
    alfa = coo[1]+":"+coo[2]+":"+coo[3]
    delta = coo[4]+":"+coo[5]+":"+coo[6]
    return [ alfa, delta ]

def deg(a):
    import string, math

    if string.find(a,":") >= 0:
        xl = string.split(a,":")
        if string.find(a,"-") < 0:
            sgn = 1.0
        else:
            sgn = -1.0

        x = []
        for i in xl:
            try: 
                x.append(math.fabs(float(i)))
            except:
                x.append(0.0)
            d = 0.0
            for i in range(len(x)-1,0,-1):
                d = (d + x[i])/60.0
            d = sgn*(x[0] + d)   
    else:
        try:
            d = float(a)
        except:
            d = 0.0

    return d

def six(deg):
    import string, math

    if deg < 0.0:
        sgn = "-"
    else:
        sgn = ""

    deg = math.fabs(deg)+1e-6

    d = int(deg)
    m = int(60.0*(deg - d))
    s = 3600.0*(deg - (d + m/60.0))
    degs = "%d" % d
    min = "%02d" % m
    sec = "%.0f" % s
    sec = "%02d" % int(s + 0.5)
    val = sgn+degs+":"+min+":"+sec
    return val

def fmt(x):
    try:
        a = "%.1f" % x
        return a
    except:
        return "0.0"

class xmoveEntry(wxBoxSizer):
    def __init__(self,parent,text,entry):
        wxBoxSizer.__init__(self,wxHORIZONTAL)

        self.text = wxStaticText(parent,-1,text)
        self.entry = wxTextCtrl(parent,-1,entry)   

        self.Add(self.text,1,wxALL|wxALIGN_RIGHT,2)
        self.Add(self.entry,2,wxALL|wxALIGN_LEFT,2)

    def Text(self):
        return self.text

    def Entry(self):
        return self.entry


class xmoveInfo(wxBoxSizer):
    def __init__(self,parent,label,value):
        wxBoxSizer.__init__(self,wxHORIZONTAL)

        self.label = wxStaticText(parent,-1,label)
        self.value = wxStaticText(parent,-1,value)
        self.Add(self.label)
        self.Add(self.value)

    def Label(self):
        return self.label

    def Value(self):
        return self.value

    def SetFont(self,font):
        self.value.SetFont(font)

    def SetValue(self,value):
        self.value.SetLabel(value)

class xmoveRange(wxBoxSizer):
    def __init__(self,parent,label,value,min,max):
        wxBoxSizer.__init__(self,wxHORIZONTAL)

        self.label = wxStaticText(parent,-1,label)
        self.slider = wxSlider(parent,-1,value,min,max,wxPoint(-1,-1),wxSize(-1,-1),wxSL_AUTOTICKS|wxSL_LABELS)

        self.Add(self.label,1,wxEXPAND|wxALL|wxALIGN_BOTTOM,2)
        self.Add(self.slider,2,wxEXPAND|wxALL,2)

    def Label(self):
        return self.label

    def Slider(self):
        return self.slider

class prefNotebook(wxNotebook):
    def __init__(self,parent,id):
        wxNotebook.__init__(self,parent,id)
        self.parent = parent
        main = parent.parent
        wxNotebookSizer(self)

        pnet = wxPanel(self,-1)
        self.AddPage(pnet,"Network")

        self.switch = wxRadioBox(pnet,wxNewId(),"",wxDefaultPosition,
                        wxDefaultSize,["Local connection","Remote to host:"],
                        1,wxRA_SPECIFY_COLS|wxNO_BORDER)
        self.switch.SetSelection(self.parent.hosttype)
        EVT_RADIOBOX(self,self.switch.GetId(),self.GetNet)

        self.host_entry = wxTextCtrl(pnet,-1,self.parent.host)
        EVT_TEXT(self,self.host_entry.GetId(),self.GetHost)
        if self.parent.hosttype == 0:
           self.host_entry.SetEditable(False)

        netbox = wxStaticBox(pnet,-1," Network ")
        net = wxStaticBoxSizer(netbox,wxVERTICAL)
        net.Add(self.switch,0,wxALL,10)
        net.Add(self.host_entry,0,wxEXPAND|wxALL,10)

  	pnet.SetAutoLayout(True)
        pnet.SetSizer(net)

        pupdate = wxPanel(self,-1)
        self.AddPage(pupdate,"Update")

        tt = wxStaticText(pupdate,-1,"Self update interval (sec):")
        self.ti = wxSpinCtrl(pupdate,-1,"")
        self.ti.SetRange(1,2073600)
        self.ti.SetValue(self.parent.tupdate/1000)
        EVT_SPINCTRL(self,self.ti.GetId(), self.TUpdate)

        tpt = wxStaticText(pupdate,-1,"Slew progress bar update (sec):")
        self.tp = wxSpinCtrl(pupdate,-1,"")
        self.tp.SetRange(1,2147483647)
        self.tp.SetValue(self.parent.slewt)
        EVT_SPINCTRL(self,self.tp.GetId(), self.TSlew)

        updatebox = wxStaticBox(pupdate,-1," Update ")
        update = wxStaticBoxSizer(updatebox,wxVERTICAL)
        update.Add(tt)
        update.Add(self.ti)
        update.Add(tpt)
        update.Add(self.tp)

  	pupdate.SetAutoLayout(True)
        pupdate.SetSizer(update)


    def GetNet(self,evt):
        self.parent.hosttype = self.switch.GetSelection()
        if self.parent.hosttype == 0:
           self.host_entry.SetEditable(False)
        else:
           self.host_entry.SetEditable(True)

    def GetHost(self,evt):
        self.parent.host = self.host_entry.GetValue()

    def TUpdate(self,evt):
        self.parent.tupdate = 1000*self.ti.GetValue() 

    def TSlew(self,evt):
        self.parent.slewt = self.tp.GetValue() 

class prefDialog(wxDialog):
    def __init__(self,parent, id, title, 
                 pos=wxDefaultPosition, size=wxDefaultSize,
                 style=wxDEFAULT_DIALOG_STYLE):
        wxDialog.__init__(self, parent, id,title,pos,(300,250),style)
        self.parent = parent

        if parent.host == "":
           self.hosttype = 0
           self.host = ""
        else:
           self.hosttype = 1
           self.host = parent.host
        self.tupdate = parent.tupdate
        self.slewt = parent.slewt

        noty = prefNotebook(self,-1)

        x_close = wxButton(self,-1,"Close")
        EVT_BUTTON(self,x_close.GetId(),self.Close)

        s = wxBoxSizer(wxVERTICAL)
        s.Add(noty,10,wxEXPAND|wxALL,5)
        s.Add(x_close,0,wxALIGN_RIGHT|wxALL,5)

        self.SetAutoLayout(True)
        self.SetSizer(s)
#        s.Fit(self)

    def Close(self,evt):
	self.EndModal(0)
        
        if self.hosttype == 0:
          self.parent.host = ""
          self.parent.com = self.parent.command
        else:
          self.parent.host = self.host
          self.parent.com = self.parent.command+" -host "+self.host+" " 

        self.parent.tupdate = self.tupdate
        self.parent.slewt = self.slewt

class xmoveFrame(wxFrame):

    def __init__(self, parent, id, title):
        wxFrame.__init__(self, parent, id, title)

        self.parent = parent

        # skutecne veliciny
        self.clock = False
        self.alfa = 0.0
        self.delta = 0.0
        self.azimut = 0.0
        self.alfa_x = 0.0
        self.delta_x = 0.0
        self.alt = 0.0
        self.ha = 0.0
        self.mhc = 0.0
        self.vra_max = 1.0
        self.vdec_max = 1.0
        self.vra = 1.0
        self.vdec = 1.0
        self.object = ""
        self.step = 1.0/60.0
	self.coors = self.initstar()
        self.tupdate = 60000
        self.slewt = 10
        self.host = ""
        self.command = "telescope -q"
        self.com = self.command

        # parametry oken
        dd = 2

# ---------- init -----
        
        self.initresources()
        ( self.vra_max, self.vdec_max) = self.initvel()
        self.vra = self.vra_max
        self.vdec = self.vdec_max
	self.clock = self.initclock()

        self.xbar = self.CreateStatusBar()
        self.SetStatusText("xmove")

# ------------- Menu ------

        menu = wxMenu()
        menu.Append(101,"&Init")
        EVT_MENU(self,101,self.InitWin)
        menu.Append(102,"&Preferences")
        EVT_MENU(self,102,self.PrefWin)
        menu.AppendSeparator()
        menu.Append(200,"&Quit")
        EVT_MENU(self,200,self.CloseWin)
        
        mhelp = wxMenu()
        mhelp.Append(111,"&About")
        EVT_MENU(self,111,self.About)

#        opts = wxMenu()
#        opts.Append(301,"..options..")

        self.tele = wxMenu()
        self.tele.Append(401,"Calibrate")
        EVT_MENU(self,401,self.Cal)
        self.tele.Append(402,"Park")
        EVT_MENU(self,402,self.Park)

        menubar = wxMenuBar()
        menubar.Append(menu,"&File")
#        menubar.Append(opts,"O&ptions")
        menubar.Append(self.tele,"&Action")
        menubar.Append(mhelp,"&Help")
        self.SetMenuBar(menubar)

# --------  input box ------

        # combo box
        self.objs = []
        for ll in self.coors.iterkeys():
           self.objs.append(ll)  
        self.cb = wxComboBox(self,wxNewId(),"",choices=self.objs,
                             style=wxCB_DROPDOWN)
        EVT_TEXT(self,self.cb.GetId(),self.GetObjName)

        # get object button
        self.x_getobject = wxButton(self,-1,"Get coo.")
        EVT_BUTTON(self,self.x_getobject.GetId(),self.GetObject)

        # RA
        self.x_alfa = xmoveEntry(self,"R. A.:","0:0:0")
        EVT_TEXT(self,self.x_alfa.Entry().GetId(),self.e_alfa)

        # Dec
        self.x_delta = xmoveEntry(self,"Dec.:","0:0:0")
        EVT_TEXT(self,self.x_delta.Entry().GetId(),self.e_delta)

        # slew button
        ib = wxButton(self,9110,"Slew to")
        EVT_BUTTON(self,9110,self.Slew)

        input2 = wxBoxSizer(wxHORIZONTAL)
        input2.Add(self.cb,4,wxCENTER|wxALL,dd)
        input2.Add(self.x_getobject,1,wxCENTER|wxALL,dd)

        input3 = wxBoxSizer(wxHORIZONTAL)
        input3.Add(self.x_alfa,2,wxEXPAND|wxALL,dd)
        input3.Add(self.x_delta,2,wxEXPAND|wxALL,dd)
        input3.Add(ib,1,wxALL|wxCENTER,dd)

        input_title = wxStaticBox(self,-1," Input ")
        input_box = wxStaticBoxSizer(input_title,wxVERTICAL)
        input_box.Add(input2,1,wxALL,dd)
        input_box.Add(input3,1,wxALL,dd)
 
        input1 = wxBoxSizer(wxHORIZONTAL)
        input1.Add(input_box,4,wxCENTER,dd)
#        input1.Add(ib,1,wxALL|wxCENTER,dd)

# --------  coordinates ---        

	fn0 = wxFont(-1,wxDEFAULT,wxNORMAL,wxBOLD)
        
        for i in range(6,-1,-1):
	   fn = wxFont(fn0.GetPointSize()+i,wxDEFAULT,wxNORMAL,wxBOLD)
           if fn.Ok() == 1:
             break

        self.x_ra = wxStaticText(self,-1,"99:99:99")
        self.x_ra.SetFont(fn)

        self.x_dec = wxStaticText(self,-1,"99:99:99")
        self.x_dec.SetFont(fn)

        self.x_azimut = xmoveInfo(self,"Azimut: ","0.0")
        self.x_alt = xmoveInfo(self,"Altitude: ","0.0")
               
        updateb = wxButton(self,-1,"Update")    
        EVT_BUTTON(self,updateb.GetId(),self.Update)

        coo1 = wxGridSizer(3,3)
        coo1.AddMany([
                    (wxStaticText(self,-1,"Right Ascension"),1,
                     wxCENTER|wxLEFT|wxRIGHT,10*dd),
#                    (1,1),
                    (wxStaticText(self,-1,"Declination"),1,
                    wxCENTER|wxLEFT|wxRIGHT,10*dd),
                    (1,1),
                    (self.x_ra,1,wxCENTER|wxLEFT|wxRIGHT,10*dd),
#                    (1,1),
                    (self.x_dec,1,wxCENTER|wxLEFT|wxRIGHT,10*dd),
                    (updateb,1,wxCENTER|wxLEFT,dd),
#                    ])
                    (self.x_azimut,1,wxCENTER|wxLEFT|wxRIGHT,10*dd),
#                    (1,1),
                    (self.x_alt,1,wxCENTER|wxLEFT|wxRIGHT,10*dd),
                    (1,1)
                    ])

        coo2 = wxBoxSizer(wxHORIZONTAL)
        coo2.Add(coo1,1,wxCENTER,dd)
#        coo2.Add(updateb,1,wxALIGN_BOTTOM|wxALL,dd)

        self.x_velra = xmoveRange(self,"R.A.(%): ",100,0,100)    
        EVT_COMMAND_SCROLL(self,self.x_velra.Slider().GetId(),self.Velra)
        self.x_veldec = xmoveRange(self,"Dec.(%): ",100,0,100)
        EVT_COMMAND_SCROLL(self,self.x_veldec.Slider().GetId(),self.Veldec)

        velbox = wxStaticBox(self,-1," Velocity ")
        b1e = wxStaticBoxSizer(velbox,wxHORIZONTAL)
	b1e.Add(self.x_velra,0,wxALL,dd)
	b1e.Add(self.x_veldec,0,wxALL,dd)

        bv = wxBoxSizer(wxHORIZONTAL)
        bv.Add(b1e,3)
#        bv.Add(wxStaticText(self,-1,""),1)

        self.b2 = wxRadioBox(self,wxNewId()," Step ",wxDefaultPosition,
                        wxDefaultSize,["1'","5'","10'"],1,wxRA_SPECIFY_COLS)
        EVT_RADIOBOX(self,self.b2.GetId(),self.GetStep)

        self.x_up = wxButton(self,9010,"+ Dec.")
	self.x_left = wxButton(self,9020,"+ R.A.")
        self.x_right = wxButton(self,9030,"- R.A.")
        self.x_down = wxButton(self,9040,"- Dec.")	
        EVT_BUTTON(self,9010,self.Up)
        EVT_BUTTON(self,9040,self.Down)
        EVT_BUTTON(self,9030,self.Right)
        EVT_BUTTON(self,9020,self.Left)

        arrow = wxGridSizer(3,3)
        arrow.AddMany([(10,10),
                       (self.x_up,1,wxCENTER),
                       (10,10),
                       (self.x_left,1,wxCENTER),
                       (10,10),
                       (self.x_right,1,wxCENTER),
                       (10,10),
                       (self.x_down,1,wxCENTER),
                       (10,10)
                       ])

#        cbutt = wxToggleButton(self,9120," Clock ")
#        EVT_TOGGLEBUTTON(self,cbutt.GetId(),self.Clock)
        self.cbutt = wxRadioBox(self,wxNewId()," Clock ",wxDefaultPosition,
                        wxDefaultSize,["On","Off"],1,wxRA_SPECIFY_COLS)
        EVT_RADIOBOX(self,self.cbutt.GetId(),self.Clock)
	if self.clock:
          self.cbutt.SetSelection(0)
        else:
          self.cbutt.SetSelection(1)

        arrow_title = wxStaticBox(self,-1," Direction ")
        ab = wxStaticBoxSizer(arrow_title,wxHORIZONTAL)
        ab.Add(arrow,1,wxCENTRE,2)

        bh = wxBoxSizer(wxHORIZONTAL)
        bh.Add(self.b2,1,wxALL|wxCENTER,2)
        bh.Add(ab,3,wxCENTER,2)
        bh.Add(self.cbutt,1,wxCENTER|wxALL,2)

# -----  main layout ----------

        b = wxBoxSizer(wxVERTICAL)
	b.Add(input1,0,wxCENTRE|wxALL,dd)
        b.Add(coo2,0,wxCENTRE|wxALL,dd)
	b.Add(bv,0,wxCENTRE|wxALL,dd)
        b.Add(bh,0,wxCENTRE|wxALL,dd)

        #update
        self.timer = wxTimer(self,7001)
        self.timer.Start(self.tupdate)
        EVT_TIMER(self,7001,self.OnTimer)

        self.SetSizer(b)
        self.Fit()
#        self.SetAutoLayout(True)

        EVT_CLOSE(self,self.CloseWin)

    def initvel(self):
        import string
  
        (vmax,err) = xmoveExe(self.com+" get -velstat")

        if vmax != "":
          v1 = string.split(vmax)
          v = string.split(v1[0],"/")
          vx = float(v[1])
          v = string.split(v1[1],"/")          
          vy = float(v[1])
        else:
          vx = self.vra_max
          vy = self.vdec_max

        return (vx, vy)

    def initclock(self):
	import string

        clock = False

	(s,err) = xmoveExe(self.com+" get -status")
	
	if s != "":
	  c = string.split(s)
          if c[0] == "1":
            self.clock = True

        return clock

    def initresources(self):
        import os.path, string

        try:
           f = open(os.path.expanduser("~/.xmoverc"),"r")
           ls = f.readlines()
           f.close()
           for l in ls:
              a = string.split(string.replace(l,"\n","")," = ")
              if a[0] == "host":
                 self.host = a[1]
              elif a[0] == "tupdate":
                 self.tupdate = int(a[1])
              elif a[0] == "slewt":
                 self.slewt = int(a[1])
           if self.host != "":
              self.com = self.command+" -host "+self.host+" " 
        except:
           pass

    def initstar(self):
        
        import os.path, string

        v = {"Object":[0.0,0.0]}
        try:
           f = open(os.path.expanduser("~/.xmove.stars"),"r")
           ls = f.readlines()
           f.close()
           for l in ls:
              a = string.split(l,"\t")
              if a[0]:
                 x = float(a[1])
                 y = float(a[2])
                 v[a[0]] = [x,y]
        except:
           pass

        del v["Object"]
        return v

    def saveresources(self):
        import os.path

        f = open(os.path.expanduser("~/.xmoverc"),"w")
        if self.host != "":
           f.write("host = "+self.host+"\n")
        f.write("tupdate = "+str(self.tupdate)+"\n")
        f.write("slewt = "+str(self.slewt)+"\n")
        f.close()  

    def savestar(self,x):
        import os.path

        f = open(os.path.expanduser("~/.xmove.stars"),"w")
        for obj in x.iterkeys():
           coo = x[obj]
           f.write(obj+"\t"+str(coo[0])+"\t"+str(coo[1]))
           f.write("\n")
        f.close()

    def getstatus(self):
        import string

        try:
            (a,e) = xmoveExe(self.com+" get -status")
            if e != "":
               raise

            aa = string.split(a)

            if aa[0] == "1":
                clock = True
            else:
                clock = False

            a1 = string.split(aa[1],"/")
            a2 = string.split(aa[2],"/")

            return [ clock, float(a1[0]), float(a1[1]), float(a2[0]), float(a2[1]) ]

        except:
            self.Warn(e)
            return [ False, 0, -1, 0, -1 ]

    def readcoo(self,text):
        import string
        
        for l in text:
            try:
                line = string.split(l,"=")
                key = string.strip(line[0])
                x = float(line[1])
                if key == "Right Ascension":
                    self.alfa = x
                if key == "Declination":
                    self.delta = x
                if key == "Azimuth":
                    self.azimut = x
                if key == "Altitude":
                    self.alt = x
                if key == "Hour angle":
                    self.ha = x
                if key == "Siderical time":
                    self.mhc = x
            except:
                pass

    def Step(self):
       return str(self.step)

    def GetStep(self,evt):
       step = self.b2.GetSelection()
       if step == 0:
         self.step = 1.0
       if step == 1:
         self.step = 5.0
       if step == 2:
         self.step = 10.0
  
       self.step = self.step/60.0

    def Cal(self,evt):
        self.SetStatusText("calibrating telescope coordinates...")
        (a,e) = xmoveExe(self.com+" set -cal "
                +str(self.alfa_x)+" "+str(self.delta_x))
        if e != "":
            self.Error(e)
        else:
            self.SetStatusText("telescope coordinates calibrated")

    def Slew(self,evt):
        (a,e) = xmoveExe(self.com+" set -coo "+str(self.alfa_x)+" "+
                 str(self.delta_x)+
                 " -vra "+str(self.vra)+" -vdec "+str(self.vdec))
#        if e != 0:
#            self.Error(e)
#            return           

        t = self.getstatus()

        if t[2] > t[4]:
            max = int(t[2])
        else:
            max = int(t[4])
            
        if max > 0:

            dlg = wxProgressDialog("Slew"," Starting slew .. ",max,self,
                                   wxPD_CAN_ABORT|wxPD_APP_MODAL|wxPD_AUTO_HIDE)
            j = 0
            while t[2] > 0.1 or t[4] > 0.2:
                j = j + 2
                wxSleep(self.slewt)

                t = self.getstatus()
                
                if t[1] > 0.1 and t[2] > 0.1:
                    i = int(t[1])
                    st = " Rektascension time "+str(int(t[1]))+" from "\
                       + str(int(t[2]))+" sec"
                elif t[3] > 0.1 and t[4] > 0.1:
                    i = int(t[3])
                    st = " Declination time "+str(int(t[3]))+" from "\
                       + str(int(t[4]))+" sec"
                else:
                    i = 0
                    st = "Status telescope failed."

                if j == 10:
                    j = 0
                    self.Update(None)
                    
                if not dlg.Update(i,st):
                    xmoveExe(self.com+" set +ra !")
                    xmoveExe(self.com+" set +dec !")
                    break

            dlg.Update(max+1,"Slew finished.")
            dlg.Show(False)


    def Up(self,evt):
       (a,e) = xmoveExe(self.com+" set +dec +"+self.Step()+
                        " -vdec "+str(self.vdec))
       if e != 0:
           self.Warn(e)

    def Down(self,evt):
       (a,e) = xmoveExe(self.com+" set +dec -"+self.Step()+
                        " -vdec "+str(self.vdec))
       if e != 0:
           self.Warn(e)

    def Right(self,evt):
       (a,e) = xmoveExe(self.com+" set +ra -"+self.Step()+
                        " -vra "+str(self.vra))
       if e != 0:
           self.Warn(e)

    def Left(self,evt):
       (a,e) = xmoveExe(self.com+" set +ra +"+self.Step()+
                        " -vra "+str(self.vra))
       if e != 0:
           self.Warn(e)

    def Clock(self,evt):
       pos = self.cbutt.GetSelection()
       if pos == 0:
         self.clock = True
       if pos == 1:
         self.clock = False

       try:
           if self.clock:
               (a,e) = xmoveExe(self.com+" set -c on")
           else:
               (a,e) = xmoveExe(self.com+" set -c off")
           if e != 0:
               self.Warn(e)

       except:
           self.Warn("Hourly motion setup failed.")

    def Park(self,evt):
        self.SetStatusText("parking telescope...")
        (a,e) = xmoveExe(self.com+" set -c park")
        if e != 0:
             self.Warn(e)

    def InitWin(self,evt):
        self.SetStatusText("xmove initialized")

    def PrefWin(self,evt):
        self.SetPreferences()

    def CloseWin(self,evt):
        xmoveExe(self.com+" set -c off")
	self.Destroy()
        self.savestar(self.coors)
        self.saveresources()

    def About(self,evt):
        d = wxMessageDialog(self,
            " (C) xmove is a telescope mount control by F. Hroch ", "About",
            wxOK|wxICON_INFORMATION)
        d.ShowModal()
        d.Destroy()

    def Error(self,text):
        d = wxMessageDialog(self,text, "Xmove Error",
            wxOK|wxICON_ERROR)
        d.ShowModal()
        d.Destroy()

    def Warn(self,text):
        self.SetStatusText(text)

    def SetPreferences(self):
        d = prefDialog(self, -1,"Preferences")
        d.ShowModal()
        self.timer.Start(self.tupdate)

    def e_alfa(self,evt):
        x = deg(self.x_alfa.Entry().GetValue())
        self.alfa_x = 15.0*x

    def e_delta(self,evt):
        x = deg(self.x_delta.Entry().GetValue())
        self.delta_x = x

    def Velra(self,evt):
        self.vra = (self.x_velra.Slider().GetValue()/100.0)*self.vra_max
        self.SetStatusText("Velocity in Right Ascension adjusted to %.2f deg/sec" % self.vra)

    def Veldec(self,evt):
        self.vdec = (self.x_veldec.Slider().GetValue()/100.0)*self.vdec_max
        self.SetStatusText("Velocity in Declination adjusted to %.2f deg/sec" % self.vdec)

    def GetObjName(self,evt):
        x = evt.GetString()
        if x:
            self.object = x
        

    def GetObject(self,evt):

        if self.object:            
            if self.object not in self.coors:
               self.SetStatusText("Getting coordinates on request...")
               try:
                  coo = GetWebObject(self.object)
                  if coo:
                     alfa = 15.0*deg(coo[0])
	             delta = deg(coo[1])
                     self.cb.Append(self.object)
                     self.coors[self.object] = [alfa, delta]
               except:
                  alfa = self.alfa
                  delta = self.delta
                  self.Error("Connection to Simbad failed.")
               self.SetStatusText("Coordinate request finished.")
            else:
               x = self.coors[self.object]
               alfa = x[0]
               delta = x[1]

            self.x_alfa.Entry().SetValue(six(alfa/15.0))
            self.x_delta.Entry().SetValue(six(delta))

    def OnTimer(self,evt):
        self.Update(evt)


    def Update(self,evt):

        self.SetStatusText("Updating telescope status...")
        (a,e) = xmoveRun(self.com+" get")
        if e != "":
           self.SetStatusText("Telescope status update failed.")
        else:
           self.readcoo(a)

           a = six(self.alfa/15.0)
           d = six(self.delta)
           self.x_ra.SetLabel(a)
           self.x_dec.SetLabel(d)
           self.x_azimut.SetValue(fmt(self.azimut))
	   self.x_alt.SetValue(fmt(self.alt))
           self.SetStatusText("Telescope status updated.")

class xmoveApp(wxApp):

  def OnInit(self):
      frame = xmoveFrame(NULL, -1, "xmove")
      frame.SetThemeEnabled(true)
      frame.Show(true)

      self.SetTopWindow(frame)

      return true

app = xmoveApp(0) 
app.MainLoop()

