
/*

  Xnightview

  $Id: image.cpp,v 1.7 2008-02-12 23:04:39 hroch Exp $

*/


// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

// for all others, include the necessary headers (this file is usually all you
// need because it includes almost all "standard" wxWidgets headers)
#ifndef WX_PRECOMP
    #include "wx/wx.h"
#endif

#include "nightview.xpm"
#include "xnightview.h"


NightImage::NightImage(wxString name, int bskip, int bbox):
  FitsImage(name,bskip,bbox)
{

  if( ! Presented() ) {

    bmp = new wxBitmap(m101);
    return;
  }

  int width = FitsImage::Width();
  int height = FitsImage::Height();

  int nd = 3*width*height;
  unsigned char *rgb = new unsigned char[nd];

  // 8-bit greyscale bitmap
  int n = 0;
  for(int j = height-1; j >= 0; j-- ) {
    for(int i = 0; i < width; i++ ) {
      unsigned char f = EightBits(i,j);
      for(int l = 0; l < 3; l++) {
      	rgb[n+l] = f;
      }
      n += 3;
    }
  }
    
  wxImage img = wxImage(width,height,rgb,true);
  bmp = new wxBitmap(img);

  delete[] rgb;
}

// subwindow of whole image 
wxBitmap NightImage::Zoom(int x1, int y1, int x2, int y2, float w)
{
  int nx = (x2 - x1);
  int ny = (y2 - y1);

  if( nx < 0 || ny < 0 )
    return wxBitmap();

  if( Presented() ) {

    // greayscaled zoom, w is a weight to adjust intensity
    int nd = 3*nx*ny;
    unsigned char *rgb = new unsigned char[nd];
    int n = 0;
    for(int j = y1; j < y2; j++ ) {
      for(int i = x1; i < x2; i++ ) {
	unsigned char f = EightBits(i,Height()-j-1);
	for(int l = 0; l < 3; l++) {
	  rgb[n+l] = int(w*f);
	}
	n += 3;
      }
    }
    
    wxImage img = wxImage(nx,ny,rgb,true);
    wxBitmap bmp = wxBitmap(img);

    delete[] rgb;
    return bmp;
    

  }
  else {

    if( x1 < 11 || y1 < 11 || x2 > 255 || y2 > 255 ) {

      // a black canvas for points out of border
      int nd = 3*nx*ny;
      unsigned char *rgb = new unsigned char[nd];
      int n = 0;
      for(int j = y1; j < y2; j++ ) {
	for(int i = x1; i < x2; i++ ) {
	  for(int l = 0; l < 3; l++) {
	    rgb[n+l] = 0;
	  }
	  n += 3;
	}
      }
    
      wxImage img = wxImage(nx,ny,rgb,true);
      wxBitmap bmp = wxBitmap(img);
      
      delete[] rgb;
      return bmp;
    }
    else {

      // zoom of splashscreen image
      wxRect rect(x1,y1,nx,ny);
      wxBitmap nightview = wxBitmap(m101);    
      return nightview.GetSubBitmap(rect);
    }
  }  
}

// subwindow of whole image, inverse 
wxBitmap NightImage::iZoomP(int x1, int y1, int x2, int y2, 
			    unsigned char r, unsigned char g, unsigned char b,
			    float w)
{
  int nx = (x2 - x1);
  int ny = (y2 - y1);

  if( nx < 0 || ny < 0 )
    return wxBitmap();

  if( Presented() ) {

    // greayscaled inverse zoom, rgb are used to change of output color
    // for various decoration themes
    int nd = 3*nx*ny;
    unsigned char *rgbi = new unsigned char[nd];
    int n = 0;
    for(int j = y1; j < y2; j++ ) {
      for(int i = x1; i < x2; i++ ) {
	unsigned char f = EightBits(i,Height()-j-1);
	rgbi[n] = int((r/255.0)*(255.0 - w*f));
	rgbi[n+1] = int((g/255.0)*(255.0 - w*f));
	rgbi[n+2] = int((b/255.0)*(255.0 - w*f));
	n += 3;
      }
    }
    
    wxImage imgi = wxImage(nx,ny,rgbi,true);
    wxBitmap bmpi = wxBitmap(imgi);

    delete[] rgbi;
    return bmpi;
    
  }
  else {

    // out of canvas is color of theme's background
    int nd = 3*nx*ny;
    unsigned char *rgbi = new unsigned char[nd];
    int n = 0;
    for(int j = y1; j < y2; j++ ) {
      for(int i = x1; i < x2; i++ ) {
	rgbi[n] = r;
	rgbi[n+1] = g;
	rgbi[n+2] = b;
	n += 3;
      }
    }
    
    wxImage imgi = wxImage(nx,ny,rgbi,true);
    wxBitmap bmpi = wxBitmap(imgi);

    delete[] rgbi;
    return bmpi;

  }
}
