
/*

  Xnightview

  $Id: pref.cpp,v 1.2 2008-02-23 22:53:14 hroch Exp $

*/


// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

// for all others, include the necessary headers (this file is usually all you
// need because it includes almost all "standard" wxWidgets headers)
#ifndef WX_PRECOMP
    #include "wx/wx.h"
#endif

#include "xnightview.h"


#define EXPTIME    _("Exposure_time")
#define EXPTYPE    _("Exposure_type")
#define BINNING    _("Binning")
#define CHIP       _("Chip")
#define OBSERVER   _("Observer")
#define MAXWIDTH   _("MaxWidth")
#define MAXHEIGHT  _("MaxHeight")
#define ZOOMSIZE   _("Zoom_size")
#define ZOOM       _("Zoom")
#define BACKSTEP   _("Background_step")
#define BOXSIZE    _("Box_size")
#define LEGEND     _("Legend")
#define LOCALHOST  _("Local_host")
#define REMOTEHOST _("Remote_host")
#define AUTHKEY    _("AuthKey")
#define PORT       _("Port")
#define FILE       _("Filename")


NightConfig::NightConfig(wxString name): wxConfig(name)
{
  Read(EXPTIME,&exptime,1.0);
  Read(BINNING,&binning,1l);
  Read(EXPTYPE,&exptype,0l);
  Read(CHIP,&chip,_("I"));
  Read(OBSERVER,&observer,_(""));
  Read(MAXWIDTH,&maxwidth,666l);
  Read(MAXHEIGHT,&maxheight,666l);
  Read(ZOOMSIZE,&zoomsize,100l);
  Read(ZOOM,&zoom,10l);
  Read(BACKSTEP,&backstep,10l);
  Read(BOXSIZE,&boxsize,10l);
  Read(LEGEND,&legend,true);
  Read(LOCALHOST,&localhost,true);
  Read(REMOTEHOST,&remotehost,_(""));
  Read(AUTHKEY,&authkey,_(""));
  Read(PORT,&port,7666l);
  Read(FILE,&file,_("nightview.fits"));
}

NightConfig::~NightConfig()
{
  SetUmask(0077);
  Write(EXPTIME,exptime);
  Write(BINNING,binning);
  Write(EXPTYPE,exptype);
  Write(CHIP,chip);
  Write(OBSERVER,observer);
  Write(MAXWIDTH,maxwidth);
  Write(MAXHEIGHT,maxheight);
  Write(ZOOMSIZE,zoomsize);
  Write(ZOOM,zoom);
  Write(BACKSTEP,backstep);
  Write(BOXSIZE,boxsize);
  Write(LEGEND,legend);
  Write(LOCALHOST,localhost);
  Write(REMOTEHOST,remotehost);
  Write(AUTHKEY,authkey);
  Write(PORT,port);
  Write(FILE,file);
}
