
/*

  Xnightview

  $Id: preferences.cpp,v 1.9 2008-02-23 22:59:26 hroch Exp $

*/

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

// for all others, include the necessary headers (this file is usually all you
// need because it includes almost all "standard" wxWidgets headers)
#ifndef WX_PRECOMP
    #include "wx/wx.h"
#endif

#include <wx/notebook.h>
#include <wx/spinctrl.h>

#include "xnightview.h"
#include "base64.h"


BEGIN_EVENT_TABLE(NightPrefer, wxPropertySheetDialog)
  EVT_RADIOBUTTON(ID61, NightPrefer::PreferRadio)
  EVT_RADIOBUTTON(ID62, NightPrefer::PreferRadio)
END_EVENT_TABLE()


NightPrefer::NightPrefer(wxWindow *p, wxString& title, long style):
  wxPropertySheetDialog(p,wxID_ANY,title,wxDefaultPosition,wxDefaultSize,style)
{
  const int okr = 10;

  CreateButtons(wxOK | wxCANCEL);

  wxPanel *net = new wxPanel(GetBookCtrl());
  GetBookCtrl()->AddPage(net, _("Connection"));

  wxBoxSizer *nsizer = new wxBoxSizer(wxVERTICAL);
  local = new wxRadioButton(net,ID61,_(" Local connection "),
                                 wxDefaultPosition, wxDefaultSize,wxRB_GROUP);
  nsizer->Add(local,wxSizerFlags().Border(wxALL,okr));
  remote = new wxRadioButton(net,ID62,_(" Remote to host "),
                                  wxDefaultPosition, wxDefaultSize);
  nsizer->Add(remote,wxSizerFlags().Border(wxLEFT,okr));

  wxBoxSizer *ns1 = new wxBoxSizer(wxHORIZONTAL);
  wxStaticText *txt_host = new wxStaticText(net,wxID_ANY,_("Host:"));
  ns1->Add(txt_host,wxSizerFlags(1).Align(wxALIGN_CENTER_VERTICAL).Border(wxRIGHT,3));
  host = new wxTextCtrl(net,wxID_ANY);
  ns1->Add(host,wxSizerFlags(4).Expand().Border(wxRIGHT,5));
  wxStaticText *txt_port = new wxStaticText(net,wxID_ANY,_("Port:"));
  ns1->Add(txt_port,wxSizerFlags(1).Align(wxALIGN_CENTER_VERTICAL).Border(wxRIGHT,3));
  port = new wxSpinCtrl(net,wxID_ANY,_("7666"),wxDefaultPosition,wxDefaultSize,wxSP_ARROW_KEYS,0,65535,7666);
  ns1->Add(port,wxSizerFlags(2));
  nsizer->Add(ns1,wxSizerFlags().Border(wxLEFT,okr));

  wxBoxSizer *ns2 = new wxBoxSizer(wxHORIZONTAL);
  wxStaticText *txt_user = new wxStaticText(net,wxID_ANY,_("User:"));
  ns2->Add(txt_user,wxSizerFlags(1).Align(wxALIGN_CENTER_VERTICAL).Border(wxRIGHT,3));
  user = new wxTextCtrl(net,wxID_ANY);
  ns2->Add(user,wxSizerFlags(3).Expand().Border(wxRIGHT,5));
  wxStaticText *txt_pass = new wxStaticText(net,wxID_ANY,_("Password:"));
  ns2->Add(txt_pass,wxSizerFlags(2).Align(wxALIGN_CENTER_VERTICAL));
  pass = new wxTextCtrl(net,wxID_ANY,_(""),wxDefaultPosition,wxDefaultSize,wxTE_PASSWORD);
  ns2->Add(pass,wxSizerFlags(3).Expand().Border(wxRIGHT,5));
  nsizer->Add(ns2,wxSizerFlags().Border(wxALL,okr));
  net->SetSizerAndFit(nsizer);


  wxPanel *camera = new wxPanel(GetBookCtrl());
  GetBookCtrl()->AddPage(camera, _("Camera"));

  wxBoxSizer *csizer = new wxBoxSizer(wxVERTICAL);

  wxArrayString ch;
  ch.Add(_(" Imaging "));
  ch.Add(_(" Tracking "));

  chip = new wxRadioBox(camera,wxID_ANY,_(" Select chip "),wxDefaultPosition, 
			wxDefaultSize,ch,1,wxRA_SPECIFY_ROWS);
  csizer->Add(chip,wxSizerFlags().Expand().Border(wxALL,okr));
  camera->SetSizerAndFit(csizer);

  wxPanel *graf = new wxPanel(GetBookCtrl());
  GetBookCtrl()->AddPage(graf, _("Graphics"));

  wxBoxSizer *gsizer = new wxBoxSizer(wxVERTICAL);

  legend = new wxCheckBox(graf,wxID_ANY,_(" Legend "));
  gsizer->Add(legend,wxSizerFlags().Expand().Border(wxALL,okr));

  int xmax,ymax;
  ::wxDisplaySize(&xmax,&ymax);

  wxBoxSizer *ggsizer1 = new wxBoxSizer(wxHORIZONTAL);
  wxStaticText *txt_xsize = new wxStaticText(graf,wxID_ANY,_(" Maximum image width:  "));
  ggsizer1->Add(txt_xsize,wxSizerFlags(1).Align(wxALIGN_CENTER_VERTICAL).Border(wxRIGHT,3));
  xsize = new wxSpinCtrl(graf,wxID_ANY,_("666"),wxDefaultPosition,wxDefaultSize,wxSP_ARROW_KEYS,1,xmax,666);
  ggsizer1->Add(xsize);
  gsizer->Add(ggsizer1,wxSizerFlags().Expand().Border(wxALL,okr));

  wxBoxSizer *ggsizer2 = new wxBoxSizer(wxHORIZONTAL);
  wxStaticText *txt_ysize = new wxStaticText(graf,wxID_ANY,_(" Maximum image height: "));
  ggsizer2->Add(txt_ysize,wxSizerFlags(1).Align(wxALIGN_CENTER_VERTICAL).Border(wxRIGHT,3));
  ysize = new wxSpinCtrl(graf,wxID_ANY,_("666"),wxDefaultPosition,wxDefaultSize,wxSP_ARROW_KEYS,1,ymax,666);
  ggsizer2->Add(ysize);
  gsizer->Add(ggsizer2,wxSizerFlags().Expand().Border(wxALL,okr));

  graf->SetSizerAndFit(gsizer);
  

  wxPanel *zoom = new wxPanel(GetBookCtrl());
  GetBookCtrl()->AddPage(zoom, _("Zoom"));

  wxBoxSizer *zsizer = new wxBoxSizer(wxVERTICAL);

  wxBoxSizer *zsizer1 = new wxBoxSizer(wxHORIZONTAL);

  wxStaticText *txt_half = new wxStaticText(zoom,wxID_ANY,_(" Zoom ratio : "));
  zsizer1->Add(txt_half,wxSizerFlags(1).Align(wxALIGN_CENTER_VERTICAL).Border(wxRIGHT,3));
  half = new wxSpinCtrl(zoom,wxID_ANY,_("10"),wxDefaultPosition,wxDefaultSize,wxSP_ARROW_KEYS,2,30,10);
  zsizer1->Add(half);
  zsizer->Add(zsizer1,wxSizerFlags().Expand().Border(wxALL,okr));

  wxBoxSizer *zsizer2 = new wxBoxSizer(wxHORIZONTAL);
  wxStaticText *txt_zsize = new wxStaticText(zoom,wxID_ANY,_(" Zoom window size (needs restart):  "));
  zsizer2->Add(txt_zsize,wxSizerFlags(1).Align(wxALIGN_CENTER_VERTICAL).Border(wxRIGHT,3));
  zsize = new wxSpinCtrl(zoom,wxID_ANY,_("100"),wxDefaultPosition,wxDefaultSize,wxSP_ARROW_KEYS,10,xmax < ymax ? xmax : ymax,100);
  zsizer2->Add(zsize);
  zsizer->Add(zsizer2,wxSizerFlags().Expand().Border(wxALL,okr));

  zoom->SetSizerAndFit(zsizer);

  wxPanel *anal = new wxPanel(GetBookCtrl());
  GetBookCtrl()->AddPage(anal, _("Analysis"));

  wxBoxSizer *asizer = new wxBoxSizer(wxVERTICAL);

  wxBoxSizer *asizer1 = new wxBoxSizer(wxHORIZONTAL);
  wxStaticText *txt_bstep = new wxStaticText(anal,wxID_ANY,_(" Background step : "));
  asizer1->Add(txt_bstep,wxSizerFlags(1).Align(wxALIGN_CENTER_VERTICAL).Border(wxRIGHT,3));
  bstep = new wxSpinCtrl(anal,wxID_ANY,_("10"),wxDefaultPosition,wxDefaultSize,wxSP_ARROW_KEYS,1,1000,10);
  asizer1->Add(bstep);
  asizer->Add(asizer1,wxSizerFlags().Expand().Border(wxALL,okr));

  wxBoxSizer *asizer2 = new wxBoxSizer(wxHORIZONTAL);
  wxStaticText *txt_box = new wxStaticText(anal,wxID_ANY,_(" Box size : "));
  asizer2->Add(txt_box,wxSizerFlags(1).Align(wxALIGN_CENTER_VERTICAL).Border(wxRIGHT,3));
  box = new wxSpinCtrl(anal,wxID_ANY,_("10"),wxDefaultPosition,wxDefaultSize,wxSP_ARROW_KEYS,2,1000,10);
  asizer2->Add(box);
  asizer->Add(asizer2,wxSizerFlags().Expand().Border(wxALL,okr));

  anal->SetSizerAndFit(asizer);

  LayoutDialog();
}

void NightPrefer::PreferRadio(wxCommandEvent& WXUNUSED(event))
{
  if( local->GetValue() ) {
    host->Enable(false);
    port->Enable(false);
    user->Enable(false);
    pass->Enable(false);
  }

  if( remote->GetValue() ) {
    host->Enable(true);
    port->Enable(true);
    user->Enable(true);
    pass->Enable(true);
  }
}

void NightPrefer::set_port(const int t)
{
  port->SetValue(t);
}

void NightPrefer::set_local(const bool loc)
{
  if( loc ) {
    local->SetValue(true);
    host->Enable(false);
    port->Enable(false);
    user->Enable(false);
    pass->Enable(false);
  }    
  else {
    remote->SetValue(true);
    host->Enable(true);
    port->Enable(true);
    user->Enable(true);
    pass->Enable(true);
  }
}
void NightPrefer::set_host(const wxString& t)
{
  host->SetValue(t);
}

void NightPrefer::set_chip(const wxChar t)
{
  if( t == 'I' )
    chip->SetSelection(0);
  else if( t == 'T' )
    chip->SetSelection(1);
}

void NightPrefer::set_legend(const bool l)
{
  legend->SetValue(l);
}

void NightPrefer::set_xsize(const int i)
{
  xsize->SetValue(i);
}

void NightPrefer::set_ysize(const int i)
{
  ysize->SetValue(i);
}

void NightPrefer::set_zsize(const int i)
{
  zsize->SetValue(i);
}

void NightPrefer::set_half(const int i)
{
  half->SetValue(i);
}

void NightPrefer::set_bstep(const int i)
{
  bstep->SetValue(i);
}

void NightPrefer::set_box(const int i)
{
  box->SetValue(i);
}


int NightPrefer::get_port()
{
  return port->GetValue();
}

bool NightPrefer::get_local()
{
  return local->GetValue();
}

wxString NightPrefer::get_host()
{
  return host->GetValue();
}

wxChar NightPrefer::get_chip()
{
  if( chip->GetSelection() == 0 )
    return 'I';
  else if ( chip->GetSelection() == 1 )
    return 'T';
  else
    return ' ';
}

bool NightPrefer::get_legend()
{
  return legend->GetValue();
}

int NightPrefer::get_xsize()
{
  return xsize->GetValue();
}

int NightPrefer::get_ysize()
{
  return ysize->GetValue();
}

int NightPrefer::get_zsize()
{
  return zsize->GetValue();
}

int NightPrefer::get_half()
{
  return half->GetValue();
}

int NightPrefer::get_bstep()
{
  return bstep->GetValue();
}

int NightPrefer::get_box()
{
  return box->GetValue();
}

wxString NightPrefer::get_auth()
{
  wxString u = user->GetValue();
  wxString p = pass->GetValue();

  if( u.IsEmpty() || p.IsEmpty() )
    
    return(_(""));

  else {
  
    wxString xauth = u + _(":") + p;

    size_t l64 = BASE64_LENGTH(xauth.Len())+1;
    char *auth64 = new char[l64];

    base64_encode(xauth.mb_str(),(size_t)xauth.Len(),auth64,l64);
    
    wxString auth(auth64,wxConvUTF8);
    delete auth64;

    return auth;
  }
}

void NightPrefer::set_auth(const wxString& auth)
{

  if( auth.IsEmpty() ) {

    user->SetValue(_(""));
    pass->SetValue(_(""));
    
  }
  else {

    size_t l64 = BASE64_LENGTH(auth.Len())+1;
    char *auth64 = new char[l64];
    base64_decode(auth.mb_str(),(size_t)auth.Len(),auth64,&l64);
    auth64[l64] = '\0';
    wxString xauth(auth64,wxConvUTF8);
    delete auth64;

    user->SetValue(xauth.Before(':'));
    pass->SetValue(xauth.After(':'));
  }
}
