

/*

  Xnightview

  $Id: xnightview.h,v 1.24 2008-03-30 00:43:58 hroch Exp $

*/

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

// for all others, include the necessary headers (this file is usually all you
// need because it includes almost all "standard" wxWidgets headers)
#ifndef WX_PRECOMP
    #include "wx/wx.h"
#endif
#include <wx/propdlg.h>

#include <wx/tglbtn.h>
#include <wx/spinctrl.h>
#include <wx/list.h>
#include <wx/process.h>
#include <wx/config.h>
#include <wx/thread.h>
#include "nightview.h"

enum
{
  ID11,ID12,ID13,ID14,ID15,ID16,ID17,ID18,ID19,
  ID61,ID62,
  File_Open,
  File_Save,
  File_Exit,
  Set_Binning,
  Set_Zooming,
  Set_Zoom_41,
  Set_Zoom_21,
  Set_Zoom_11,
  Set_Zoom_12,
  Set_Zoom_14,
  Set_Chip,
  Set_Chip_I,
  Set_Chip_T,
  Set_Legend,
  Set_Preferences,
  About_Help,
  About_Camera,
  About_Fits,
  About_About = wxID_ABOUT,
  Power_But,
  Regulate_But,
  Temp_spin,
  Exp_But,
  Exp_Obs,
  Exp_Obj,
  Filt_But,
  Scroll_win,
  NightFrame_ID
};



class XNightview : public wxApp
{
public:
    virtual bool OnInit();
    //    int OnExit();
};


class FitsImage
{
 public:
  FitsImage(wxString,int bskip=10,int bbox=10);
  virtual ~FitsImage();

  // true when a FITS is loaded sucessfully
  bool Presented() { return presented; }
  
  // get 8-bit representation of intensity 
  unsigned char EightBits(int, int);

  // get 16-bit intensity
  float Intensity(int,int);

  // get sky's level
  float Mean() { return sky; }

  // get fwhm of object
  float xFwhm(int,int);
  float yFwhm(int,int);

  // S/N
  float Sn(int,int);

  // FITS keywords
  wxString Object() { return object; }
  wxString DateObs() { return dateobs; }
  wxString Filter() { return filter; }
  wxString ExpTime() { return exptime; }
  wxString Focus() { return focus; }
  wxString PixSize() { return xpixsize; }
  wxString Binning() { return binning; }
  wxArrayString Header() { return head; }

  // size, if not presented, it is 0
  virtual int Height() { return ny; }
  virtual int Width() { return nx; }

  // get/set size of neigberhoot for compute of fwhm and sn
  int Box() { return box; }
  void BoxSize(int b) { if( b > 1 ) box = b; }

  // step over image to compute backgroudn level
  int Bstep() { return bstep; }
  void BstepSize(int b) { if( bstep > 0 ) bstep = b; Statistics(); }

 private:

  // internal statistics of image
  void Statistics();
  float mean,dev,sig,sky;
  int box,bstep;

  // quick-sort median
  float QMed(int, float *, int);

  // FITS header
  wxString filename;
  wxString object,filter,exptime,dateobs,xpixsize,focus,binning;
  wxArrayString head;

  // data
  int nx,ny;
  float *data;
  bool presented;
};


class NightImage: public FitsImage
{
public:
  NightImage(wxString a,int bskip=10, int bbox = 10);
  virtual ~NightImage() { delete bmp; }
  const wxBitmap *xpm(void) { return bmp; }
  int Height() { return bmp->GetHeight(); }
  int Width() { return bmp->GetWidth(); }
  wxBitmap Zoom(int x1, int y1, int x2, int y2,float w = 1.0);
  wxBitmap iZoomP(int x1, int y1, int x2, int y2, 
		  unsigned char, unsigned char, unsigned char, float w = 1.0);

private:

  wxBitmap *bmp;

};


class NightConfig : public wxConfig
{
 public:
  NightConfig(wxString name);
  ~NightConfig();

  // exposure time in seconds
  double Exptime() { return exptime; }

  // default binning: 1,2,3
  long Binning() { return binning; }

  // exposure type: 0,1,2 (light, dark, continous)
  long Exptype() { return exptype; }

  // chip: I,T (imaging, tracking)
  wxChar Chip() { return chip.GetChar(0); }

  // observer's ID
  wxString Observer() { return observer; }

  // max. size of image in pix
  long MaxWidth() { return maxwidth; }
  long MaxHeight() { return maxheight; }

  // size of zoom window in control panel in pix
  long ZoomSize() { return zoomsize; }

  // zoom factor
  long Zoom() { return zoom; }

  // step-over for background estimate, affects speed and precision
  long Backstep() { return backstep; }

  // box size in pixels for computaion of FWHM and S/N
  long BoxSize() { return boxsize; }

  // draw legend on bottom of image
  bool Legend() { return legend; }

  // connect to localhost (true) or remote (false)
  bool Localhost() { return localhost; }

  // remote host address
  wxString Remotehost() { return remotehost; }
  
  // MD5 sum based auth-key (identical to http authentification)
  wxString AuthKey() { return authkey; }

  // remote port (default 7666)
  long Port() { return port; }

  // default filename
  wxString File() { return file; }


  // setting methods
  void Set_Exptime(double e) { exptime = e; }
  void Set_Binning(long b) { binning = b; }
  void Set_Exptype(long e) { exptype = e; }
  void Set_Chip(wxChar c) { chip = c; }
  void Set_Observer(wxString o) { observer = o; }
  void Set_MaxWidth(long m) { maxwidth = m; }
  void Set_MaxHeight(long m) { maxheight = m; }
  void Set_ZoomSize(long z) { zoomsize = z; }
  void Set_Zoom(long z) { zoom = z; }
  void Set_Backstep(long b) { backstep = b; }
  void Set_BoxSize(long b) { boxsize = b; }
  void Set_Legend(bool l) { legend = l; }
  void Set_Localhost(bool l) { localhost = l; }
  void Set_Remotehost(wxString r) { remotehost = r; }
  void Set_AuthKey(wxString a) { authkey = a; }
  void Set_Port(long p) { port = p; }
  void Set_File(wxString f) { file = f; }

 private:

  double exptime;
  long binning;
  long exptype;
  wxString chip;
  wxString observer;
  long maxwidth;
  long maxheight;
  long zoomsize;
  long zoom;
  long backstep;
  long boxsize;
  bool legend;
  bool localhost;
  wxString remotehost;
  wxString authkey;
  long port;
  wxString file;

};


class NightPrefer : public wxPropertySheetDialog
{
public:
  NightPrefer(wxWindow *p, wxString& title, long);
  virtual ~NightPrefer() {}
  void set_port(const int);
  void set_local(const bool);
  void set_host(const wxString&);
  void set_auth(const wxString&);
  void set_chip(const wxChar t);
  void set_legend(const bool);
  void set_xsize(const int);
  void set_ysize(const int);
  void set_zsize(const int);
  void set_half(const int);
  void set_bstep(const int);
  void set_box(const int);

  int get_port();
  bool get_local();
  wxString get_host();
  wxString get_auth();
  wxChar get_chip();
  bool get_legend();
  int get_xsize();
  int get_ysize();
  int get_zsize();
  int get_half();
  int get_bstep();
  int get_box();

private:

  void PreferRadio(wxCommandEvent& WXUNUSED(event));

  wxRadioButton *local,*remote;
  wxTextCtrl *host,*user,*pass;
  wxSpinCtrl *port;  
  wxRadioBox *chip;
  wxCheckBox *legend;
  wxSpinCtrl *xsize,*ysize,*zsize,*half,*bstep,*box;  

  DECLARE_EVENT_TABLE()
};

class NightFrame;
class NightControl;

class NightZoom : public wxWindow
{
 public:
  NightZoom(NightControl *f, const wxSize& s): 
    wxWindow((wxWindow *)f,wxID_ANY,wxPoint(-1,-1),s) 
    { night_control = f; half = 10; }
  ~NightZoom() {}

  void OnPaint(wxPaintEvent& event);
  void SetHalf(int h) { half = h; }

 private:
  NightControl *night_control;
  int half;
  DECLARE_EVENT_TABLE()
};

class NightGraph : public wxWindow
{
 public:
  NightGraph(NightControl *f, const wxSize& s):
    wxWindow((wxWindow *)f,wxID_ANY,wxPoint(-1,-1),s) 
    { night_control = f; width=100; height = 100; half = 10; ltic = 5; }
  ~NightGraph() {}

 void OnPaint(wxPaintEvent& event);
 void SetHalf(int h) { half = h; }

 private:
  NightControl *night_control;
  int width, height, half, ltic;
  DECLARE_EVENT_TABLE()
};

class NightControl : public wxFrame
{
public:
  NightControl(NightFrame *p, wxString title, NightImage *i);
  virtual ~NightControl();
  void WmExit(wxCloseEvent& WXUNUSED(event));
  void Exitus(void);
  void View(void) { active = !active; Show(active); }
  void FileOpen(wxCommandEvent& WXUNUSED(event));
  void FileSave(wxCommandEvent& WXUNUSED(event));
  void FileExit(wxCommandEvent& WXUNUSED(event));
  void SetPreferences(wxCommandEvent& WXUNUSED(event));
  void AboutHelp(wxCommandEvent& WXUNUSED(event));
  void AboutCamera(wxCommandEvent& WXUNUSED(event));
  void AboutFits(wxCommandEvent& WXUNUSED(event));
  void AboutAbout(wxCommandEvent& WXUNUSED(event));
  void OnEndInfo(wxProcessEvent& event);
  void PowerButton(wxCommandEvent& WXUNUSED(event));
  void RegulateButton(wxCommandEvent& WXUNUSED(event));
  void TemperatureText(wxCommandEvent& WXUNUSED(event));
  void TemperatureChange(wxCommandEvent& WXUNUSED(event));
  void ExposureButton(wxCommandEvent& WXUNUSED(event));
  void OnExposure(wxTimerEvent& event);
  void OnEndExposure(wxProcessEvent& event);
  void OnContinue(wxTimerEvent& event);
  void FilterSwitch(wxCommandEvent& WXUNUSED(event));
  void OnFilterSwitch(wxTimerEvent& event);
  void OnEndFilterSwitch(wxProcessEvent& event);

  void OnTempUpdate(wxTimerEvent& event);
  void TempUpdate();
  void EndTempUpdate(wxProcessEvent& event);
  void OnEndRegulate(wxProcessEvent& event);

  void UpdateFluxEtc();
  void UpdateGraphs();

  void DisablePower() { power->Disable(); }
  void SetTempStatus(wxString);
  void SetExposure(bool b) { start->SetValue(b); }

  void FinishExp();

  NightFrame *GetParent() { return frame; }

private:

  bool active;
  NightFrame *frame;
  wxPanel *panel;
  NightPrefer *pref;
  NightImage *image;
  wxToggleButton *power,*regulate;
  wxArrayString filters;
  wxToggleButton *start;
  wxChoice *etype, *ebin;
  wxTextCtrl *eobs, *eobj, *etime, *temp;
  wxBoxSizer *controls;
  wxRadioBox *filt;
  wxStaticText *value, *coordinate, *fwhm, *mean;
  NightZoom *winzoom;
  NightGraph *winprofi;
  wxString dir,file,object,name;

  int x_coo,y_coo;

  // exposure update
  wxProcess *ExpProc;
  wxTimer ExpTimer, ContinueTimer;
  long ExpPid;
  int ExpStat; // 1=exposing, 2=downloading
  bool setpoint;

  // temperature update
  double LastTemperature;
  wxTimer TempTimer;
  wxProcess *TempProc,*RegProc;
  int TempIter;
  
  // filter update
  wxProcess *FiltProc;
  wxTimer FilterTimer;
  int FilterIter;

  // info
  wxProcess *InfoProc;

  // progress bar
  wxGauge *progress,*fprogress;

  void connection_setup(bool,wxString,int,wxString);
  
  DECLARE_EVENT_TABLE()
};

class NightDisplay: public wxScrolledWindow
{
 public:
  NightDisplay(NightFrame *w);
  ~NightDisplay() { }
  void OnMouseRun(wxMouseEvent& event);
  void OnRightDown(wxMouseEvent& event);  
  void OnKeyDown(wxKeyEvent& event);
  void OnPaint(wxPaintEvent& WXUNUSED(event));
  void OnScroll(wxScrollWinEvent& event);

  int Xoff() { return xoff; }
  int Yoff() { return yoff; }
  void Origin();

 private:
  
  int xoff,yoff;

  DECLARE_EVENT_TABLE()
};

class InputName : public wxThread
{
 public:

  InputName(wxFrame *f): wxThread() { parent = f; }
  ~InputName() {}
  virtual void *Entry();
  virtual void OnExit();

 private:
  wxFrame *parent;
};


// top class
class NightFrame : public wxFrame
{
public:
  NightFrame(wxString name, bool stdinp, wxString title);
  ~NightFrame() { panel->Destroy(); display->Destroy();
    delete image; delete conf; }

  void OnClose(wxCloseEvent&);
  void OnSize(wxSizeEvent& WXUNUSED(sz)) { Resize(); }
  bool LoadImage(wxString);

  long XPointer() { return xcoo; }
  long YPointer() { return ycoo; }
  NightImage *Image() { return image; }
  NightControl *Panel() { return panel; }
  NightDisplay *Display() { return display; }
  NightConfig *Config() { return conf; }

  void set_coo(long x, long y) { xcoo = x; ycoo = y; }

  void SendName(wxCommandEvent &event) { LoadImage(event.GetString()); }
  void NameSender(const wxString&);

private:
  long xcoo,ycoo;
  NightImage *image;
  NightControl *panel;
  NightDisplay *display;
  NightConfig *conf;
  InputName *im; 
  void Resize();

  DECLARE_EVENT_TABLE()
};



