package sbig;

public final class SBIGStatus {
   /* imaging_ccd_status     0 idle, 2 in progress, or 3 for image complete */
   /* tracking_ccd_status    same, but for tracking CCD */
   /* fan_on                 0 fan is off, 1 fan is on */
   /* shutter_state          0 open, 1 closed, 2 opening, 3 closing */
   /* led_state              0 LED is off, 2 slow blink, 3 fast blink */
   /* shutter_edge           255 indicates shutter failure; all others OK [?] */
   /* plus_x_relay           boolean indicating whether +X relay is active */
   /* minus_x_relay          boolean indicating whether -X relay is active */
   /* plus_y_relay           boolean indicating whether +Y relay is active */
   /* minus_y_relay          boolean indicating whether -Y relay is active */
   /* temperature_regulation boolean indicating whether temp regulation is on */
   /* temperature_setpoint   target temperature for regulation, in 0.01 deg C */
   /* cooling_power          amount of cooling being applied in arbitrary units */
   /*                        from 0 to 255, inclusive */
   /* ccd_temperature        in units of 0.01 deg C */
   /* air_temperature        in units of 0.01 deg C */

    public static final int CCD_STATUS_IDLE = 0;
    public static final int CCD_STATUS_IN_PROGRESS = 2;
    public static final int CCD_STATUS_COMPLETE = 3;

    public static final int CCD_SHUTTER_OPENED = 0;
    public static final int CCD_SHUTTER_CLOSED = 1;
    public static final int CCD_SHUTTER_OPENING = 2;
    public static final int CCD_SHUTTER_CLOSING = 3;

    public int  imaging_ccd_status;
    public int  tracking_ccd_status;
    public int  fan_on;
    public int  shutter_state;
    public int  led_state;
    public int  shutter_edge;
    public int  plus_x_relay;
    public int  minus_x_relay;
    public int  plus_y_relay;
    public int  minus_y_relay;
    public int  pulse_active;
    public int  temperature_regulation;
    public int  temperature_setpoint;
    public int  cooling_power;
    public int  air_temperature;
    public int  ccd_temperature;

    private static int[] status_buffer = new int[16];

    public static final String decode_ccd_status(int st) {
	switch(st) {
	case CCD_STATUS_IDLE:
	    return "no-exposure";
	case CCD_STATUS_IN_PROGRESS:
	    return "exposure-in-progress";
	case CCD_STATUS_COMPLETE:
	    return "expose-complete";
	}
	return "unknown ccd status " + st;
    }

    public static final String decode_shutter(int sh) {
	switch(sh) {
	case CCD_SHUTTER_OPENED:   /* 0 */
	    return "open";
	case CCD_SHUTTER_CLOSED:   /* 1 */
	    return "closed";
	case CCD_SHUTTER_OPENING:  /* 2 */
	    return "opening";
	case CCD_SHUTTER_CLOSING:  /* 3 */
	    return "closing";
	}
	return "unknown shutter state " + sh;
    }

    public String toString() {
	return "imaging_ccd_status=" + decode_ccd_status(imaging_ccd_status) +
	  "\ntracking_ccd_status=" + decode_ccd_status(tracking_ccd_status) +
	  "\nfan_on=" + fan_on +
	  "\nshutter_state=" + decode_shutter(shutter_state) +
	  "\nled_state=" + led_state +
	  "\nshutter_edge=" + shutter_edge +
	  "\nplus_x_relay=" + plus_x_relay +
	  "\nminus_x_relay=" + minus_x_relay +
	  "\nplus_y_relay=" + plus_y_relay +
	  "\nminus_y_relay=" + minus_y_relay +
	  "\npulse_active=" + pulse_active +
	  "\ntemperature_regulation=" + temperature_regulation +
	  "\ntemperature_setpoint=" + 0.01*temperature_setpoint +
	  "\ncooling_power=" + cooling_power +
	  "\nair_temperature=" + 0.1*air_temperature +
	  "\nccd_temperature=" + 0.1*ccd_temperature +
	  "\n";
    }
}
