#include <sys/types.h> /* for broken ibm jdk */
#include <sys/shm.h>
#include <stdarg.h>
#include <stdio.h>

#ifdef CNI
#include <cni.h>
#include <SBIGCamera.h>
#include <SBIGReadoutCallback.h>
#include <SBIGCameraInfo.h>

static sbig::SBIGReadoutCallback *callback_ptr;
static void fatal(char *s);
extern "C" {
#include "sbig.h"
    static int do_callback(float percent)
    {
	return (int)callback_ptr->callback((jfloat)percent);
    }
}

jint sbig::SBIGCamera::command(jint opcode, jintArray jdata,
	 jshortArray jimage, java::lang::Object *jother)
{
    int  *ip;
    int  ret, length;
    struct sbig_readout  ro;

    if (jdata == NULL) {
	ip = NULL;
	length = 0;
    } else {
	ip = (int *)elements(jdata);
	length = JvGetArrayLength(jdata);
    }
    switch(opcode) {
    case 0x378:
    case 0x2BC:
	if (4*length < sizeof(struct sbig_init))
	    fatal("sbig_init, data too short");
	ret = sbig_init(opcode, 0, (struct sbig_init *)ip);
	break;
    case 'c':
	if (4*length < sizeof(struct sbig_control))
	    fatal("sbig_control, data too short");
	ret = sbig_control((struct sbig_control *)ip);
	break;

    case 'd':  /* deflect ao7 */
	if (length < 2)
	    fatal("sbig_deflect, data too short");
	ret = sbig_set_ao7_deflection(ip[0], ip[1]);
	break;

    case 's':
	if (4*length < sizeof(struct sbig_status))
	    fatal("sbig_status, data too short");
	ret = sbig_get_status((struct sbig_status *)ip);
	break;

    case 't':
	/*struct sbig_cool {
	 *    int regulation;		* 0 off, 1 on, 2 direct_drive
	 *    int temperature;		* in 0.1 deg C, if 'on'
	 *    int direct_drive;		* power [0..255], direct_drive
	 *};
	 * extern int  sbig_set_cooling(struct sbig_cool *);
	*/
	if (4*length < sizeof(struct sbig_cool))
	    fatal("sbig_cool, data too short");
	ret = sbig_set_cooling((struct sbig_cool *)ip);
	break;

    case 'e':
	/*
	 *  struct sbig_expose {
	 *      int ccd;
	 *      int exposure_time;
	 *      int abg_state;
	 *      int shutter;
	 *  };
	 * extern int  sbig_expose(struct sbig_expose *);
	 */
	if (4*length < sizeof(struct sbig_expose))
	    fatal("sbig_expose, data too short");
	ret = sbig_expose((struct sbig_expose *)ip);
	break;

    case 'p':
	/* struct sbig_pulse {
	 *    int nmbr_pulses;		0 to 255
	 *    int pulse_width;		microsec, min 9
	 *    int pulse_interval;	microsec, min 27+pulse_width
	 * };
	 * extern int  sbig_pulse(struct sbig_pulse *);
	 */
	if (4*length < sizeof(struct sbig_pulse))
	    fatal("sbig_pulse, data too short");
	ret = sbig_pulse((struct sbig_pulse *)ip);
	break;

    case 'r':
!!!!FIX THIS FOR sbigreadout2 !!!!
!!!!FIX this for data being null in abort case !!!!
	/* struct sbig_readout {
	 *     int ccd;
	 *     int binning;
	 *     int x, y;
	 *     int width, height;
	 *     unsigned short *data;
	 *     int data_size_in_bytes;
	 *     int (*callback)(float percent_complete);
	 * };
	 * extern int  sbig_readout(struct sbig_readout *);
	 */
	ro.ccd = ip[0];
	ro.binning = ip[1];
	ro.x = ip[2];
	ro.y = ip[3];
	ro.width = ip[4];
	ro.height = ip[5];
	ro.data = (unsigned short *)elements(jimage);
	ro.data_size_in_bytes = ip[7]*sizeof(short);
	/* blagh: get the callback method out of the callback object */
	if (jother != NULL) {
	    callback_ptr = (sbig::SBIGReadoutCallback *) jother;
	    ro.callback = do_callback;
	} else {
	    ro.callback = NULL;
	    callback_ptr = NULL;
	}
	/* get the SBIGReadoutCallback class */
	/* yank the Callback method from it and stash it away */

	ret = sbig_readout(&ro);
	break;

    default:
	fprintf(stderr, "sbigjni: invalid opcode %d\n", opcode);
    }
    return ret;
}

java::lang::String *sbig::SBIGCamera::show_error(jint error)
{
    char *s;
    switch(error) {
    case SBIG_CAMERA_NOT_FOUND: s = "SBIG_CAMERA_NOT_FOUND"; break;
    case SBIG_EXPOSURE_IN_PROGRESS: s = "SBIG_EXPOSURE_IN_PROGRESS"; break;
    case SBIG_NO_EXPOSURE_IN_PROGRESS: s = "SBIG_NO_EXPOSURE_IN_PROGRESS"; break;
    case SBIG_UNKNOWN_COMMAND: s = "SBIG_UNKNOWN_COMMAND"; break;
    case SBIG_BAD_CAMERA_COMMAND: s = "SBIG_BAD_CAMERA_COMMAND"; break;
    case SBIG_BAD_PARAMETER: s = "SBIG_BAD_PARAMETER"; break;
    case SBIG_TX_TIMEOUT: s = "SBIG_TX_TIMEOUT"; break;
    case SBIG_RX_TIMEOUT: s = "SBIG_RX_TIMEOUT"; break;
    case SBIG_NAK_RESBIGIVED: s = "SBIG_NAK_RESBIGIVED"; break;
    case SBIG_CAN_RESBIGIVED: s = "SBIG_CAN_RESBIGIVED"; break;
    case SBIG_UNKNOWN_RESPONSE: s = "SBIG_UNKNOWN_RESPONSE"; break;
    case SBIG_BAD_LENGTH: s = "SBIG_BAD_LENGTH"; break;
    case SBIG_AD_TIMEOUT: s = "SBIG_AD_TIMEOUT"; break;
    case SBIG_CHECKSUM_ERROR: s = "SBIG_CHECKSUM_ERROR"; break;
    case SBIG_EEPROM_ERROR: s = "SBIG_EEPROM_ERROR"; break;
    case SBIG_SHUTTER_ERROR: s = "SBIG_SHUTTER_ERROR"; break;
    case SBIG_UNKNOWN_CAMERA: s = "SBIG_UNKNOWN_CAMERA"; break;
    case SBIG_DRIVER_NOT_FOUND: s = "SBIG_DRIVER_NOT_FOUND"; break;
    case SBIG_DRIVER_NOT_OPEN: s = "SBIG_DRIVER_NOT_OPEN"; break;
    case SBIG_DRIVER_NOT_CLOSED: s = "SBIG_DRIVER_NOT_CLOSED"; break;
    case SBIG_SHARE_ERROR: s = "SBIG_SHARE_ERROR"; break;
    case SBIG_TSBIG_NOT_FOUND: s = "SBIG_TSBIG_NOT_FOUND"; break;
    case SBIG_NEXT_ERROR: s = "SBIG_NEXT_ERROR"; break;
    case SBIG_NOT_ROOT: s = "SBIG_NOT_ROOT"; break;
    default:
	fprintf(stderr, "sbigjni: unknown error code %d\n", error);
	s = "Unknown Error";
    }
    return JvNewStringUTF(s);
}

static void fatal(char *s)
{
    fprintf(stderr, "sbigjni internal error: %s\nAborting.\n", s);
}

#else /* use JNI */

#include "sbig.h"
#include <jni.h>
static JNIEnv  *callback_env;
static jclass  callback_class;  /* class of SBIGReadoutCallback */
static jmethodID  callback_method_id;
static jobject callback_this;
static int ro_callback(float percent_complete);

static void fatal(char *s, ...)
{
    va_list  va;

    fprintf(stderr, "sbigjni internal error: ");
    va_start(va, s);
    vfprintf(stderr, s, va);
    va_end(va);
    fprintf(stderr, "\nAborting.\n");
    exit(1);
}


#ifdef REMOTE
static unsigned char  *sp;  /* shared mem pointer */
static FILE  *fp;	    /* remote's stdin */

/*
 * get data from a remote command
 * if size is 0, just wait for a response
 * wait time is in millis
 */
static int get_remote(void *p, int size, int wait)
{
    int  i;

    wait /= 10;
    for (i = 0; i < wait; ++i) {
	if (*sp != 0)
	    break;
	usleep(10000);   /* hundreth of a second */
    }
    if (i == wait)
	return SBIG_RX_TIMEOUT;

    if (sp[0] == 0xFF) {
	*sp = 0;
	fprintf(fp, "errno\n");
	fflush(fp);
	for (i = 0; i < 100; ++i) {
	    if (*sp != 0)
		break;
	    usleep(10000);   /* hundreth of a second */
	}
	if (i == 100)
	    return SBIG_RX_TIMEOUT;
	return *(int *)(sp + 4);
    }
    if (size > 0)
	memcpy(p, sp+4, size);
    return 0;
}

/*
 * Class:     SBIG
 * Method:    command
 * Signature: (I[I[S)I
 */
JNIEXPORT jint JNICALL
Java_sbig_SBIGCamera_command(JNIEnv *env, jclass this_class, jint opcode,
		   jintArray jdata, jshortArray jimage, jobject jother)
{
    int  *ip;
    int  ret = 0, length;
    struct sbig_readout2  ro;
    static int  id = -1;


    if (jdata == NULL) {
	ip = NULL;
	length = 0;
    } else {
	ip = (int *) (*env)->GetIntArrayElements(env, jdata, NULL);
	length = (*env)->GetArrayLength(env, jdata);
    }
    switch(opcode) {
    case 0x378:
    case 0x2BC:
	if (4*length < sizeof(struct sbig_init))
	    fatal("sbig_init, data too short");
	if (id >= 0)
	    fatal("sbig_init: called more than once");
	id = shmget(4099, 1024*1024, IPC_CREAT|0777);
	if (id < 0) {
	    perror("sbig: could not create shared memory");
	    exit(1);
	}
	printf("sbig: shm id = %d\n", id);
	sp = shmat(id, NULL, 0);
	if (sp == NULL || (int)sp == -1) {
	    perror("sbig: could not map shared memory");
	    exit(1);
	}
	*sp = 0;
	if (opcode == 0x2BC)
	    fp = popen("ccd_prog -key 4099 -port 0x2BC", "w");
	else
	    fp = popen("ccd_prog -key 4099", "w");
	if (fp == NULL)
	    fatal("cannot find/run 'ccd_prog'");
	/* init command is implicit */
	ret = get_remote((void *)ip, sizeof(struct sbig_init), 15000);
	break;

    case 'c':
	if (4*length < sizeof(struct sbig_control))
	    fatal("sbig_control, data too short");
	sp[0] = 0;
	memcpy(sp+4, (struct sbig_control *)ip, sizeof(struct sbig_control));
	fprintf(fp, "control\n");
	fflush(fp);
	ret = get_remote(NULL, 0, 2000);
	break;

    case 'd':  /* deflect ao7 */
	if (length < 2)
	    fatal("sbig_deflect, data too short");
	sp[0] = 0;
	memcpy(sp+4, ip, 2*sizeof(int));
	fprintf(fp, "deflect\n");
	fflush(fp);
	ret = get_remote(NULL, 0, 2000);
	break;

    case 's':
	if (4*length < sizeof(struct sbig_status))
	    fatal("sbig_status, data too short");
	sp[0] = 0;
	fprintf(fp, "status\n");
	fflush(fp);
	ret = get_remote((void *)ip, sizeof(struct sbig_status), 2000);
	break;

    case 't':
	/*struct sbig_cool {
	 *    int regulation;		* 0 off, 1 on, 2 direct_drive
	 *    int temperature;		* in 0.1 deg C, if 'on'
	 *    int direct_drive;		* power [0..255], direct_drive
	 *};
	 * extern int  sbig_set_cooling(struct sbig_cool *);
	*/
	if (4*length < sizeof(struct sbig_cool))
	    fatal("sbig_cool, data too short");
	sp[0] = 0;
	memcpy(sp+4, ip, sizeof(struct sbig_cool));
	fprintf(fp, "cool\n");
	fflush(fp);
	ret = get_remote(NULL, 0, 2000);
	break;

    case 'e':
	/*
	 *  struct sbig_expose {
	 *      int ccd;
	 *      int exposure_time;
	 *      int abg_state;
	 *      int shutter;
	 *  };
	 * extern int  sbig_expose(struct sbig_expose *);
	 */
	if (4*length < sizeof(struct sbig_expose))
	    fatal("sbig_expose, data too short");
	sp[0] = 0;
	memcpy(sp+4, ip, sizeof(struct sbig_expose));
	fprintf(fp, "expose\n");
	fflush(fp);
	ret = get_remote(NULL, 0, 2000);
	break;

    case 'p':
	/* struct sbig_pulse {
	 *    int nmbr_pulses;		0 to 255
	 *    int pulse_width;		microsec, min 9
	 *    int pulse_interval;	microsec, min 27+pulse_width
	 * };
	 * extern int  sbig_pulse(struct sbig_pulse *);
	 */
	if (4*length < sizeof(struct sbig_pulse))
	    fatal("sbig_pulse, data too short");
	sp[0] = 0;
	memcpy(sp+4, ip, sizeof(struct sbig_pulse));
	fprintf(fp, "pulse\n");
	fflush(fp);
	ret = get_remote(NULL, 0, 2000);
	break;

    case 'r':
	/* struct sbig_readout {
	 *     int ccd;
	 *     int binning;
	 *     int x, y;
	 *     int width, height;
	 *     unsigned short *data;
	 *     int data_size_in_bytes;
	 *     int (*callback)(float percent_complete);
	 * };
	 * extern int  sbig_readout(struct sbig_readout *);
	 */
	ro.flags = ip[0]? SBIG_NO_SHUTTER_DELAY : 0;
	ro.ccd = ip[1];
	ro.binning = ip[2];
	ro.x = ip[3];
	ro.y = ip[4];
	ro.width = ip[5];
	ro.height = ip[6];
	if (jimage) {
	    ro.data = (*env)->GetShortArrayElements(env, jimage, NULL);
	    ro.data_size_in_bytes = ip[8]*sizeof(short);
	} else {
	    ro.data = NULL;
	    ro.data_size_in_bytes = 0;
	}
	/* blagh: get the callback method out of the callback object */
	if (jother != NULL) {
	    callback_env = env;
	    callback_this = (*env)->NewGlobalRef(env, jother);
	    callback_class = (*env)->GetObjectClass(env, jother); /*notused? */
	    callback_method_id = (*env)->GetMethodID(env,
				 callback_class, "readout_callback", "(F)Z");
	    if (callback_method_id == 0)
		fatal("sbigjni: cannot location method callback");
	    ro.callback = ro_callback;
	} else {
	    callback_this = NULL;
	    ro.callback = NULL;
	}
	/* get the SBIGReadoutCallback class */
	/* yank the Callback method from it and stash it away */

	sp[0] = 0;
	memcpy(sp+4, &ro, sizeof(struct sbig_readout2));
	fprintf(fp, "readout2\n");
	fflush(fp);
	ret = get_remote(ro.data, ro.data_size_in_bytes, 90000);
	if (ro.callback != NULL)
	    (*ro.callback)(100.0F); /* FIX ME */
	if (callback_this != NULL)
	    (*env)->DeleteGlobalRef(env, callback_this);
	(*env)->ReleaseShortArrayElements(env, jimage, ro.data, 0);
	break;

    default:
	fprintf(stderr, "sbigjni: invalid opcode %d\n", (int) opcode);
    }
    if (ip != NULL)
	(*env)->ReleaseIntArrayElements(env, jdata, (jint *) ip, 0);
    return ret;
}

#else /* not REMOTE */

/*
 * Class:     SBIG
 * Method:    command
 * Signature: (I[I[S)I
 */
JNIEXPORT jint JNICALL
Java_sbig_SBIGCamera_command(JNIEnv *env, jclass this_class, jint opcode,
		   jintArray jdata, jshortArray jimage, jobject jother)
{
    int  *ip;
    int  ret = 0, length;
    struct sbig_readout2  ro;

    if (jdata == NULL) {
	ip = NULL;
	length = 0;
    } else {
	ip = (int *) (*env)->GetIntArrayElements(env, jdata, NULL);
	length = (*env)->GetArrayLength(env, jdata);
    }
    switch(opcode) {
    case 0x378:
    case 0x2BC:
	if (4*length < sizeof(struct sbig_init))
	    fatal("sbig_init, data too short");
	sbig_set_linux_strategy(SBIG_DISABLE_INTERRUPTS); /* !!!! */
	ret = sbig_init(opcode, 0, (struct sbig_init *)ip);
	break;
    case 'c':
	if (4*length < sizeof(struct sbig_control))
	    fatal("sbig_control, data too short");
	ret = sbig_control((struct sbig_control *)ip);
	break;

    case 'd':  /* deflect ao7 */
	if (length < 2)
	    fatal("sbig_deflect, data too short");
	ret = sbig_set_ao7_deflection(ip[0], ip[1]);
	break;

    case 's':
	if (4*length < sizeof(struct sbig_status))
	    fatal("sbig_status, data too short");
	ret = sbig_get_status((struct sbig_status *)ip);
	break;

    case 't':
	/*struct sbig_cool {
	 *    int regulation;		* 0 off, 1 on, 2 direct_drive
	 *    int temperature;		* in 0.1 deg C, if 'on'
	 *    int direct_drive;		* power [0..255], direct_drive
	 *};
	 * extern int  sbig_set_cooling(struct sbig_cool *);
	*/
	if (4*length < sizeof(struct sbig_cool))
	    fatal("sbig_cool, data too short");
	ret = sbig_set_cooling((struct sbig_cool *)ip);
	break;

    case 'e':
	/*
	 *  struct sbig_expose {
	 *      int ccd;
	 *      int exposure_time;
	 *      int abg_state;
	 *      int shutter;
	 *  };
	 * extern int  sbig_expose(struct sbig_expose *);
	 */
	if (4*length < sizeof(struct sbig_expose))
	    fatal("sbig_expose, data too short");
	ret = sbig_expose((struct sbig_expose *)ip);
	break;

    case 'p':
	/* struct sbig_pulse {
	 *    int nmbr_pulses;		0 to 255
	 *    int pulse_width;		microsec, min 9
	 *    int pulse_interval;	microsec, min 27+pulse_width
	 * };
	 * extern int  sbig_pulse(struct sbig_pulse *);
	 */
	if (4*length < sizeof(struct sbig_pulse))
	    fatal("sbig_pulse, data too short");
	ret = sbig_pulse((struct sbig_pulse *)ip);
	break;

    case 'r':
	/* struct sbig_readout {
	 *     int ccd;
	 *     int binning;
	 *     int x, y;
	 *     int width, height;
	 *     unsigned short *data;
	 *     int data_size_in_bytes;
	 *     int (*callback)(float percent_complete);
	 * };
	 * extern int  sbig_readout(struct sbig_readout *);
	 */
	ro.flags = ip[0]? SBIG_NO_SHUTTER_DELAY : 0;
	ro.ccd = ip[1];
	ro.binning = ip[2];
	ro.x = ip[3];
	ro.y = ip[4];
	ro.width = ip[5];
	ro.height = ip[6];
	if (jimage) {
	    ro.data = (*env)->GetShortArrayElements(env, jimage, NULL);
	    ro.data_size_in_bytes = ip[8]*sizeof(short);
	} else {
	    ro.data = NULL;
	    ro.data_size_in_bytes = 0;
	}
	/* blagh: get the callback method out of the callback object */
	if (jother != NULL) {
	    callback_env = env;
	    callback_this = (*env)->NewGlobalRef(env, jother);
	    callback_class = (*env)->GetObjectClass(env, jother); /*notused? */
	    callback_method_id = (*env)->GetMethodID(env,
				 callback_class, "readout_callback", "(F)Z");
	    if (callback_method_id == 0)
		fatal("sbigjni: cannot location method callback");
	    ro.callback = ro_callback;
	} else {
	    callback_this = NULL;
	    ro.callback = NULL;
	}
	/* get the SBIGReadoutCallback class */
	/* yank the Callback method from it and stash it away */

	ret = sbig_readout2(&ro);
	if (callback_this != NULL)
	    (*env)->DeleteGlobalRef(env, callback_this);
	(*env)->ReleaseShortArrayElements(env, jimage, ro.data, 0);
	break;

    default:
	fprintf(stderr, "sbigjni: invalid opcode %d\n", (int) opcode);
    }
    if (ip != NULL)
	(*env)->ReleaseIntArrayElements(env, jdata, (jint *) ip, 0);
    return ret;
}
#endif /* REMOTE */
/*
 * this is the callback registered with readout.
 * Given the way env's work, we are in deep doo-doo if the
 * signal handler is registered from a different thread than
 * it gets called from!  Nor can I figure out a way to detect this.
 */
static int ro_callback(float percent_complete)
{
    return (*callback_env)->CallBooleanMethod(callback_env, callback_this,
			callback_method_id, percent_complete);
}



/*
 * Class:     SBIG
 * Method:    show_error
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL
Java_sbig_SBIGCamera_show_1error(JNIEnv *env, jclass this_class, jint error)
{
    char *s;
    switch(error) {
    case SBIG_CAMERA_NOT_FOUND: s = "SBIG_CAMERA_NOT_FOUND"; break;
    case SBIG_EXPOSURE_IN_PROGRESS: s = "SBIG_EXPOSURE_IN_PROGRESS"; break;
    case SBIG_NO_EXPOSURE_IN_PROGRESS: s = "SBIG_NO_EXPOSURE_IN_PROGRESS"; break;
    case SBIG_UNKNOWN_COMMAND: s = "SBIG_UNKNOWN_COMMAND"; break;
    case SBIG_BAD_CAMERA_COMMAND: s = "SBIG_BAD_CAMERA_COMMAND"; break;
    case SBIG_BAD_PARAMETER: s = "SBIG_BAD_PARAMETER"; break;
    case SBIG_TX_TIMEOUT: s = "SBIG_TX_TIMEOUT"; break;
    case SBIG_RX_TIMEOUT: s = "SBIG_RX_TIMEOUT"; break;
    case SBIG_NAK_RESBIGIVED: s = "SBIG_NAK_RESBIGIVED"; break;
    case SBIG_CAN_RESBIGIVED: s = "SBIG_CAN_RESBIGIVED"; break;
    case SBIG_UNKNOWN_RESPONSE: s = "SBIG_UNKNOWN_RESPONSE"; break;
    case SBIG_BAD_LENGTH: s = "SBIG_BAD_LENGTH"; break;
    case SBIG_AD_TIMEOUT: s = "SBIG_AD_TIMEOUT"; break;
    case SBIG_CHECKSUM_ERROR: s = "SBIG_CHECKSUM_ERROR"; break;
    case SBIG_EEPROM_ERROR: s = "SBIG_EEPROM_ERROR"; break;
    case SBIG_SHUTTER_ERROR: s = "SBIG_SHUTTER_ERROR"; break;
    case SBIG_UNKNOWN_CAMERA: s = "SBIG_UNKNOWN_CAMERA"; break;
    case SBIG_DRIVER_NOT_FOUND: s = "SBIG_DRIVER_NOT_FOUND"; break;
    case SBIG_DRIVER_NOT_OPEN: s = "SBIG_DRIVER_NOT_OPEN"; break;
    case SBIG_DRIVER_NOT_CLOSED: s = "SBIG_DRIVER_NOT_CLOSED"; break;
    case SBIG_SHARE_ERROR: s = "SBIG_SHARE_ERROR"; break;
    case SBIG_TSBIG_NOT_FOUND: s = "SBIG_TSBIG_NOT_FOUND"; break;
    case SBIG_NEXT_ERROR: s = "SBIG_NEXT_ERROR"; break;
    case SBIG_NOT_ROOT: s = "SBIG_NOT_ROOT"; break;
    default:
	fprintf(stderr, "sbigjni: unknown error code %d\n", (int) error);
	s = "Unknown Error";
    }
    return (*env)->NewStringUTF(env, s);
}
#endif
