import sbig.SBIGCamera;
import sbig.SBIGStatus;
import sbig.SBIGReadoutCallback;
/*
 * This may be the world's shortest image aquisition and display program!
 * Main.java by Steven Ashe, 5 June 1999,  ashe@dimensional.com
 * ABSOLUTELY NO WARRANTY.
 */

public final class Main
{
    public static void main(String[] args) {
	/* camera on standard parallel port */
	SBIGCamera ccd = new SBIGCamera(0x378);
	System.out.println(ccd);

	ccd.set_control(SBIGCamera.LEAVE_SHUTTER, true,
		SBIGCamera.LED_OFF);
	SBIGStatus  status = new SBIGStatus();
	ccd.get_status(status);
	System.out.println(status);

	System.out.println("starting 1 second exposure");
	ccd.expose_dark(SBIGCamera.IMAGING_CCD, 1.0F);
	while (true) {
	    ccd.get_status(status);
	    if (status.imaging_ccd_status == SBIGStatus.CCD_STATUS_COMPLETE)
		break;
	    System.out.print(".");
	    System.out.flush();
	    try {			/* wait 1/4 second */
		Thread.sleep(250);
	    } catch (Exception e) {
	    }
	}
	System.out.println("1 second exposure complete");

	int  width = ccd.get_image_width(SBIGCamera.IMAGING_CCD,
					 SBIGCamera.BIN_2X2);
	int  height = ccd.get_image_height(SBIGCamera.IMAGING_CCD,
					   SBIGCamera.BIN_2X2);
	short[] data = new short[width*height];
	System.out.println("starting readout");
	ccd.readout_image(SBIGCamera.IMAGING_CCD, SBIGCamera.BIN_2X2,
			 data, new MyCallback());
	System.out.println("readout done");

	int  min = 65536, max = -65537;
	for (int i = width*height; --i >= 0; ) {
	    int d = data[i]&0xFFFF;
	    if (d < min)
		min = d;
	    if (d > max)
		max = d;
	}
	System.out.println("data ranges from " + min + " to " + max);
	/*
	 * Inefficiently calculate a full-saturation logarithmic
	 * view in the awt standard color representation
         */
	int[]  im_data = new int[width*height];
	for (int k = width*height; --k >= 0; ) {
	    int d = data[k]&0xFFFF;
	    double x = 100.0*((double)d - min)/(max - min + 1.0);
	    d = (int)(255.0*Math.log(x + 1.0)/Math.log(101.0));
	    im_data[k] = 0xFF000000|(d<<16)|(d<<8)|d;
	}
	new ImageDisplayer(width, height, im_data);
    }
}

class MyCallback implements SBIGReadoutCallback {
    public boolean  readout_callback(float percent) {
	System.out.println(percent + "%");
	return true;		/* i.e., don't abort */
    }
}

class ImageDisplayer extends java.awt.Frame
{
    private java.awt.Image  im;

    ImageDisplayer(int width, int height, int[] im_data) {
	super("SBIG Demo");
	setSize(width+16, height+32);
	setLayout(null);
	im = createImage(new java.awt.image.MemoryImageSource(width,
					 height, im_data, 0, width));
	setVisible(true);
    }
    public void paint(java.awt.Graphics g) {
	g.drawImage(im, 8, 24, this);
    }
}
