program Heliocentric_Correction;
uses dos,crt,planets;

var           data,output : Text;
    jd,jdh,mag,ra,de,corr : Real;
                     i,io : Integer;
                      rec : String;

Procedure help;
begin
writeln;
writeln('Some error...');
highvideo;
writeln('helcor.exe <input.dat> <output.helcor> RA. DEC.');
normvideo;
writeln;
writeln('where:');
writeln('        input.dat is an ASCII data file - JD vs. Mag');
writeln('        output.faze is ASCII output - JD_hel vs. Mag');
writeln('        RA. is a right ascension');
writeln('        DEC. is a declination');
writeln;
lowvideo;
writeln('Example: helcor.exe grtau.dat grtau.out 245.2541 45.213');
normvideo;
writeln;
writeln;
highvideo;
writeln('(c) Rudolf Novak, e-mail:rudolfn@physics.muni.cz');
writeln('Nicholas Copernicus Observatory');
writeln('Brno 616 00');
writeln('Czech Republic');
normvideo;
halt;
end;

Procedure chyba;
begin
writeln('Some error during reading parameters!');
delay(1000);
help;
end;

begin
 clrscr;
 if (paramcount<>4) or (paramstr(1)='/?')then help;
 clrscr;
 io:=0;
 assign(data,paramstr(1));
 reset(data);
 assign(output,paramstr(2));
 rewrite(output);
 val(paramstr(3),ra,io);
 if io <> 0 then chyba;
 io:=0;
 val(paramstr(4),de,io);
 if io <> 0 then chyba;
 writeln('Seems that`s all right. Here we go...');
 writeln('Counting heliocentric corrections for julian dates. Wait a bit...');
 for i:=1 to 2 do begin readln(data,rec);writeln(data,rec); end;
repeat
 readln(data,jd,rec);
 corr:=(heliocentric_correction_s(jd,ra,de))/86400;
 if jd <2000000 then
  begin
    writeln('You want to make correction to short JD. Hmm, it is not possible here.');
    writeln('Try different file and have a fun (& press a key to quit...)');
    readln;
    halt;
    end
    else
   jdh:=jd+corr;
 writeln(output,jdh:10:6,' ',rec);
until eof(data);
sound(100);
nosound;
writeln('Done.');
close(data);
close(output);
end.