unit Mouse;

interface

   uses DOS;
   var
     Reg     : Registers;
     M1      : Word;
     M11     : word;
     M2      : Word;
     M21     : Word;
     Step    : Word;

     procedure MouseInit;
     procedure MouseOn;
     procedure MouseOff;
     procedure GetMousePos(var M1,M2 : integer);
     procedure SetMousePos(M1, M2 : integer);
     function  MousePress(var M1,M2 : integer) : boolean;
     function  MouseLoosen(var M1,M2 : integer) : boolean;
     procedure MouseBorder(M1,M2,M11,M21 : integer);
     procedure MousePenOn;
     procedure MousePenOff;
     procedure MouseStep(Step : integer);
     procedure MouseWait;
     procedure Mousesetgr(var pole;x,y:integer);
     function  MouseTest(var M1,M2 : integer):byte;

implementation

procedure MouseInit;
begin
Reg.AX := $0000;
Intr($33,Reg);
end;

procedure MouseOn;
begin
Reg.AX := $0001;
Intr($33,Reg);
end;

procedure MouseOff;
begin
Reg.AX := $0002;
Intr($33,Reg);
end;

procedure GetMousePos(var m1,m2 : integer);
begin
Reg. Ax := $0003;
Intr($33,Reg);
M1 := Reg.Cx;
M2 := Reg.Dx;
end;

procedure SetMousePos(M1, M2 : integer);
begin
Reg.ax := $0004;
Reg.cx := M1;
Reg.dx := M2;
Intr($33,Reg);
end;

function MousePress(var M1,M2 : integer) : boolean;
begin
Reg.AX := $0005;
Intr($33,Reg);
if Reg.BX <> 0 then MousePress := true
   else MousePress := false;
M1 := Reg.CX;
M2 := Reg.DX;
end;


function MouseLoosen(var M1,M2 : integer) : boolean;
begin
Reg.AX := $0006;
Intr($33,Reg);
if Reg.BX <> 0 then MouseLoosen := true
   else  MouseLoosen := false;
M1 := Reg.CX;
M2 := Reg.CX;
end;

procedure MouseBorder(M1,M2,M11,M21 : integer);
begin
Reg.Cx := M1;
Reg.Dx := M2;
Reg.Ax := $0007;
Intr($33,Reg);
Reg.Cx := M11;
Reg.Dx := M21;
Reg.Ax := $0008;
Intr($33,Reg);
end;

procedure MousePenOn;
begin
Reg.Ax := $0013;
Intr($33,Reg);
end;

procedure MousePenOff;
begin
Reg.Ax := $0014;
Intr($33,Reg);
end;

procedure MouseStep(Step : integer);
begin
Reg.Bx := 1;
Reg.AX := $0015;
Intr($33,Reg);
end;

procedure MouseWait;
begin
Reg.AX := $0005;
Intr($33,Reg);
while Reg.Bx = 0 do begin
    Reg.AX := $0005;
    Intr($33,Reg);
end;
end;

procedure mousesetgr(var pole;x,y:integer);
type arr=array[0..31] of word;
var a:integer;
begin
for a:=16 to 31 do arr(pole)[a]:=swap(arr(pole)[a]);
reg.ax:=9;
reg.bx:=x;
reg.cx:=y;
reg.es:=seg(pole);
reg.dx:=ofs(pole);
intr($33,reg);
end;

function mousetest(var m1,m2:integer):byte;
begin
reg.ax:=3;
intr($33,reg);
m1:=reg.cx;
m2:=reg.dx;
mousetest:=reg.bx;
end;

begin
Reg.AX := $0000;
Intr($33,Reg);
end.