(*   Author: Rudolf Novak
             Nicholas Copernicus Observatory & Planetarium in Brno
             Kravi hora 2
             616 00 Brno
             Czech Republic
     e-mail: rudolfn@physics.muni.cz
Last Update: 16.1.1998 *)


Program Analyzing_Star_Field_From_Matching_Routines;

uses crt,dos,graph,mouse,str_num;
label 10;
type star = record
        n : integer;
        x : integer;
        y : integer;
        m : integer;
end;



var
    pocet_hvezd,k,x_c,y_c,gd,gm,i,mx,my,io                        : integer;
    ok,again,back : boolean;
    hvezda : array [1..1000] of star;
    variable,comp_1,comp_2,comp_3 : star;
    julDate : real;

 (* Functions *)
function press(x,y,x1,y1,x2,y2:integer):boolean;
 begin press:=(x>x1)and(y>y1)and(x<x2)and(y<y2); end;

function JD ( y,M,D : real ) : real;
 var a,B,jd1 : real;
 begin
 if (M=1.0)or(M=2.0) then begin
   y:=y-1.0;
   M:=M+12.0; end;
 a:=int(0.01*y);
 B:=2-a+int(0.25*a);
 jd1:=int(365.25*y)+int(30.6001*(M+1.0))+D+1.7209945E6;
 if (y<=1582.0)and(M<=10.0)and(D<15) then
   JD:=a
 else
   JD:=jd1+B;
end; (* JD *)


(*Procedures *)

Procedure Morse;
begin;
for i:=1 to 10 do
begin
sound(i*100);delay(3);nosound;
sound((10-i)*100);delay(6);nosound;
end;
end;


Procedure file_chyba(jmeno:string);

begin
setfillstyle(1,white);
bar((getmaxx div 2)-151, (getmaxy div 2)-11,(getmaxy div 2) +251,(getmaxy div 2) +11);
setfillstyle(1,black);
bar((getmaxx div 2)-150, (getmaxy div 2)-10,(getmaxy div 2) +250,(getmaxy div 2) +10);
setfillstyle(1,red);
bar((getmaxx div 2)-149, (getmaxy div 2)-9,(getmaxy div 2) +249,(getmaxy div 2) +9);
outtextxy((getmaxx div 2)-140,getmaxy div 2 - 3,'THERE IS NO FILE '+jmeno+' TO READ!');
repeat until keypressed;
closegraph;
halt;
end;


Procedure Screen; (* Initialize graphic Screen *)
begin
 gd:=0;gm:=8;
 initgraph(gd,gm,getenv('bgi'));
 cleardevice;
 setfillstyle(1,white);
 bar(1,1,getmaxx,getmaxy);
 setfillstyle(blue,blue);
 bar(2,2,getmaxx-1,getmaxy-1);
end; (* End of Procedure "Screen" *)

Procedure Scale;
begin
 line(1,getmaxy-40,getmaxx,getmaxy-40);
 setfillstyle(1,white);
 for i:=1 to 5 do
 begin
  circle((i+10)*i,getmaxy-20,i+2);
  floodfill((i+10)*i,getmaxy-20,white);
 end;
 line((i+10)*i+20,getmaxy-40,(i+10)*i+20,getmaxy);
 outtextxy((i+10)*i+30,getmaxy-30,'Use mouse to select stars, first must be');
 outtextxy((i+10)*i+30,getmaxy-20,'variable and then select comparisons.');
 line(getmaxx-50,getmaxy-20,getmaxx,getmaxy-20);line(getmaxx-50,getmaxy-20,getmaxx-50,getmaxy);
 outtextxy(getmaxx-40,getmaxy-14,'Quit');
end; (* Of Scale *)



Procedure file_chyba2(jmeno:string);

begin
end;


Procedure Help;
begin
writeln('Analyze needs three parameters as an input. First one is list of');
writeln('FITS files and second one is an output. Third is a MUNIDIR path.');
writeln;
writeln('analyze.exe fts.dir output.txt MUNIDIR' );
halt;
end;


Procedure beep;
begin
 sound(1000);
 delay(100);
 nosound;
end; (* of Beep *)

Procedure beep_err;
begin
 sound(1000);
 delay(100);
 nosound;
 sound(1000);
 delay(100);
 nosound;
 sound(1000);
 delay(100);
 nosound;
end; (* of beep_err *)

Procedure mys; (* Mouse init *)
begin
 mouseinit;
end; (* of Mys *)



Procedure Read_Mat_File;
var
       f,m1 : text;
       k_s,rec,vecko,first_name,mat_name,empty,a_s,x_s,y_s : string;
       rad,s_x,s_y,a,radek,point : integer;
       aa,x,y,mag,max,min : real;
       findme : boolean;

begin
 findme:=false;
 (* Read fts.dir and first fts file *)

 {$I-$}
 assign(f,paramstr(1));
 reset(f);
 if ioresult <> 0 then file_chyba(paramstr(1));
 {$I+$}
repeat
 readln(f,first_name);
 point:=pos('.',first_name);
 mat_name:=copy(first_name,1,point)+'mat';
 {$I-$}
 assign(m1,mat_name);
 reset(m1);
 if ioresult<>0 then file_chyba2(mat_name) else findme:=true;
until findme;
 {$I+$}
 radek:=1;
 for radek:=1 to 2 do readln(m1,empty);
  min:=100;max:=-1;
 repeat (* Find maximal and minimal value of brightness *)
 readln(m1,rec);radek:=radek+1;
 if itemcount(rec) <> 0 then
  begin
    a_s:=itemstr(1,rec);
    x_s:=itemstr(2,rec);y_s:=itemstr(3,rec);vecko:=itemstr(4,rec);
    val(vecko,mag,io);
    if Io<>0 then
     begin
     beep_err;
     end;
    if (mag < min) then if (vecko <> '99.999') then min:=mag;
    if (mag > max) and (vecko <>'99.999') then max:=mag;
    for radek:=1 to 2 do readln(m1,empty); radek:=radek+2;
  end
until eof(m1);
close(m1);
(* Knowing magnitude scale - we can plot a field *)
 {$I-$}
 assign(m1,mat_name);
 reset(m1);
 if ioresult <> 0 then file_chyba(mat_name);
 {$I+$}
radek:=1;
readln(m1,empty);
readln(m1,a,x_c,y_c);
readln(m1,empty);
aa:=max;
max:=min;min:=aa;
 k:=1;
radek:=3;
 repeat (* Plot a field *)
    readln(m1,rec);radek:=radek+1;
  if itemcount(rec) <> 0 then
   begin
    a_s:=itemstr(1,rec);
    x_s:=itemstr(2,rec);y_s:=itemstr(3,rec);vecko:=itemstr(4,rec);
    val(vecko,mag,io);val(x_s,x,io);val(y_s,y,io);
    s_x:=round((x/x_c)*getmaxx);s_y:=round((y/y_c)*(getmaxy-50));
    rad:=round(5-(mag-max)+2);
    if rad=1 then rad:=2;
    setfillstyle(1,blue);
    circle(s_x,s_y,rad);
(*    setfillstyle(1,white);
    floodfill(s_x,s_y,white); *)
    setfillstyle(1,blue);
    str(k,k_s);
    floodfill(s_x-1,s_y-1,white);
    hvezda[k].m:=rad;hvezda[k].n:=radek;hvezda[k].x:=s_x;hvezda[k].y:=s_y;
    readln(m1,empty);readln(m1,empty);
    radek:=radek+2;
    inc(k);
  end
  else
  begin
   hvezda[k].m:=0;hvezda[k].x:=0;hvezda[k].y:=0;hvezda[k].n:=0;
   readln(m1,empty);readln(m1,empty);radek:=radek+2;
  end;
 until eof(m1);
close(m1);
close(f);
pocet_hvezd:=k;
end; (* Of Read_Mat_File *)


Procedure Chose_stars;

Var
    ch : char;
    x1,x2,y1,y2 : integer;
    mx_s,my_s : string;
    nasel,comp_b,ch1_b,ch2_b,var_b : boolean;


Procedure mistake;
begin
closegraph;
writeln('You chose two times same star. Run program again and be careful...');
writeln;
writeln('Press ENTER to continue...');
readln;
halt;
end;


begin
 var_b:=false;comp_b:=false;ch1_b:=false;ch2_b:=false;
 setfillstyle(1,white);
 bar(getmaxx-201,getmaxy-31,getmaxx-59,getmaxy-9);
 setfillstyle(1,black);
 bar(getmaxx-200,getmaxy-30,getmaxx-60,getmaxy-10);
 nasel:=false;
 outtextxy(getmaxx-195,getmaxy-25,'Click on stars...');
 repeat
  ok:=mousepress(mx,my);
  if keypressed then ch:=readkey;
  if ch=#27 then
   begin
    closegraph;
    halt;
   end;
  if ok and press(mx,my,getmaxx-50,getmaxy-20,getmaxx,getmaxy) then
   begin
    closegraph;
    halt;
    end;
  if ok then
   begin
   for i:=1 to k do
    begin
     if (not nasel) then
       begin
       if ((mx > (hvezda[i].x-hvezda[i].m)) and  (mx < (hvezda[i].x+hvezda[i].m)))

         and
          ((my > (hvezda[i].y-hvezda[i].m)) and (my < (hvezda[i].y+hvezda[i].m)))
        then
         begin
          var_b:=true;
          mouseoff;
          beep;
          nasel:=true;
          setfillstyle(1,white);
          bar(getmaxx-201,getmaxy-31,getmaxx-59,getmaxy-9);
          setfillstyle(1,black);
          bar(getmaxx-200,getmaxy-30,getmaxx-60,getmaxy-10);
          str(hvezda[i].n,mx_s);str(my,my_s);
          variable:=hvezda[i];
          outtextxy(getmaxx-199,getmaxy-25,'V is number '+ mx_s);
          setcolor(yellow);
          circle(hvezda[i].x,hvezda[i].y,hvezda[i].m+1);
          outtextxy(hvezda[i].x+10,hvezda[i].y+10,'Var.');
          setfillstyle(1,yellow);
          floodfill(hvezda[i].x,hvezda[i].y,yellow);
          setcolor(white);
          mouseon;
         end;
       end;
     end;
    end;

  until nasel;
 nasel:=false;
 repeat
  ok:=mousepress(mx,my);
  if ok then
   begin
   for i:=1 to k do
    begin
     if (not nasel) and (not comp_b) then
      begin
       if ((mx > (hvezda[i].x-hvezda[i].m)) and  (mx < (hvezda[i].x+hvezda[i].m)))

         and
          ((my > (hvezda[i].y-hvezda[i].m)) and (my < (hvezda[i].y+hvezda[i].m)))
        then
         begin
          comp_b:=true;
          beep;
          mouseoff;
          nasel:=true;
          setfillstyle(1,white);
          bar(getmaxx-201,getmaxy-31,getmaxx-59,getmaxy-9);
          setfillstyle(1,black);
          bar(getmaxx-200,getmaxy-30,getmaxx-60,getmaxy-10);
          str(hvezda[i].n,mx_s);str(my,my_s);
          comp_1:=hvezda[i];
          if comp_1.n=variable.n then mistake;
          outtextxy(getmaxx-199,getmaxy-25,'C1 is number '+mx_s);
          setcolor(yellow);
          circle(hvezda[i].x,hvezda[i].y,hvezda[i].m+1);
          outtextxy(hvezda[i].x+10,hvezda[i].y+10,'Comp.');
          setfillstyle(1,yellow);
          floodfill(hvezda[i].x,hvezda[i].y,yellow);
          setcolor(white);
          mx:=0;my:=0;
          mouseon;
         end;
       end;
     end;
    end;
  until nasel;
 nasel:=false;
  repeat
   ok:=mousepress(mx,my);
   if ok then
    begin
    for i:=1 to k do
     begin
      if (not nasel) and (not ch1_b) then
       begin
        if ((mx > (hvezda[i].x-hvezda[i].m)) and  (mx < (hvezda[i].x+hvezda[i].m)))

          and
           ((my > (hvezda[i].y-hvezda[i].m)) and (my < (hvezda[i].y+hvezda[i].m)))
         then
          begin
           ch1_b:=true;
           beep;
           mouseoff;
           nasel:=true;
           setfillstyle(1,white);
           bar(getmaxx-201,getmaxy-31,getmaxx-59,getmaxy-9);
           setfillstyle(1,black);
           bar(getmaxx-200,getmaxy-30,getmaxx-60,getmaxy-10);
           str(hvezda[i].n,mx_s);str(my,my_s);
           comp_2:=hvezda[i];
           if comp_2.n=comp_1.n then mistake;
           outtextxy(getmaxx-199,getmaxy-25,'C2 is number '+mx_s);
           setcolor(yellow);
           circle(hvezda[i].x,hvezda[i].y,hvezda[i].m+1);
           outtextxy(hvezda[i].x+10,hvezda[i].y+10,'Check 1');
           setfillstyle(1,yellow);
           floodfill(hvezda[i].x,hvezda[i].y,yellow);
           setcolor(white);
           mx:=0;my:=0;
           mouseon;
          end;
        end;
      end;
     end;
   until nasel;
 nasel:=false;
  repeat
   ok:=mousepress(mx,my);
   if ok then
    begin
    for i:=1 to k do
     begin
      if (not nasel) and (not ch2_b) then
       begin
        if ((mx > (hvezda[i].x-hvezda[i].m-1)) and  (mx < (hvezda[i].x+hvezda[i].m+1)))

          and
           ((my > (hvezda[i].y-hvezda[i].m-1)) and (my < (hvezda[i].y+hvezda[i].m+2)))
         then
          begin
           ch2_b:=true;
           beep;
           mouseoff;
           nasel:=true;
           setfillstyle(1,white);
           bar(getmaxx-201,getmaxy-31,getmaxx-59,getmaxy-9);
           setfillstyle(1,black);
           bar(getmaxx-200,getmaxy-30,getmaxx-60,getmaxy-10);
           str(hvezda[i].n,mx_s);str(my,my_s);
           comp_3:=hvezda[i];
           if comp_3.n=comp_2.n then mistake;
           outtextxy(getmaxx-199,getmaxy-25,'C3 is number '+mx_s);
           setcolor(yellow);
           circle(hvezda[i].x,hvezda[i].y,hvezda[i].m+1);
           outtextxy(hvezda[i].x+10,hvezda[i].y+10,'Check 2');
           setfillstyle(1,yellow);
           floodfill(hvezda[i].x,hvezda[i].y,yellow);
           setcolor(white);
           mx:=0;my:=0;
           mouseon;
          end;
        end;
      end;
     end;
   until nasel;

 setfillstyle(1,blue);
 bar(getmaxx-201,getmaxy-31,getmaxx-59,getmaxy-9);

end; (* Of Chose_Stars *)




Procedure Load_Fts(infile:string);

var
     rowf_exp,ho_s,mi_s,se_s,mo_s,ye_s,day_s,rowf_dat,rowf_time : string;
     single_fts : text;
     rowfb : char;
     expo,ho,mi,se,day,mo,ye : real;

begin
 rowf_dat:='';rowf_time:='';
  {$I-$}
 assign(single_fts,infile);
 reset(single_fts);
 if ioresult <> 0 then file_chyba(infile);
 {$I+$}
 for i:=1 to 571 do read(single_fts,rowfb);
 for i:=1 to 8 do
  begin
   read(single_fts,rowfb);
   rowf_dat:=rowf_dat+rowfb;
  end;
 for i:=1 to 72 do read(single_fts,rowfb);
 for i:=1 to 8 do
  begin
   read(single_fts,rowfb);
   rowf_time:=rowf_time+rowfb;
  end;
 for i:=1 to 555 do read(single_fts,rowfb);
  rowf_exp:='';
 for i:=1 to 16 do

  begin
   read(single_fts,rowfb);
   rowf_exp:=rowf_exp+rowfb;
  end;
 val(rowf_exp,expo,io);
 day_s:=copy(rowf_dat,1,2);mo_s:=copy(rowf_dat,4,2);ye_s:=copy(rowf_dat,7,2);
 val(day_s,day,io);val(mo_s,mo,io);val(ye_s,ye,io);
 ye:=ye+1900;
 ho_s:=copy(rowf_time,1,2);mi_s:=copy(rowf_time,4,2);se_s:=copy(rowf_time,7,2);
 val(ho_s,ho,io);val(mi_s,mi,io);val(se_s,se,io);
 se:=se/60+expo/2;mi:=(mi+se)/60;ho:=(ho+mi)/24;day:=day+ho;
 JulDate:=JD(ye,mo,day);
 close(single_fts);
end; (* Of Load_Fts *)


Procedure Analyzing_all_files;
var
  f,m1,g,h                                                        : text;
  mag_ds,mag_cs3,mag_cs2,mag_cs,mag_s,mag_sn,rec,rec1,rec2,
  rec3,rec4,rec5,mat_name,first_name                              : string;
  point                                                           : integer;
  mag_dv,mag_dc,mag_dc1,mag_dc2,mc1,mc2,mc3,mc4,mc5,mc,mag_c,
  mag_c2,mag_c3,mag,dvc,dvc1,dvc2,dcc1,dcc2,dc1c2                 : real;
  error                                                           : boolean;

begin
 setfillstyle(1,white);
 bar((getmaxx div 2)-100,(getmaxy div 2)-40,(getmaxx div 2)+1,(getmaxy div 2)-20);
 setfillstyle(1,black);
 bar((getmaxx div 2)-99,(getmaxy div 2)-39,(getmaxx div 2),(getmaxy div 2)-21);
 setcolor(red+128);
 outtextxy((getmaxx div 2)-90,(getmaxy div 2) -34,'  Wait...');
 setcolor(white);
 {$I-}
 assign(f,paramstr(1));
  if ioresult <> 0 then file_chyba(paramstr(1));
 reset(f);
 assign(g,paramstr(2));
   if ioresult <> 0 then file_chyba(paramstr(2));
 rewrite(g);
 writeln(g,'Julian date|  |Var-Comp| s1 |Var-Check1| s2 |Var-Check2| s3 |Comp-Check1| s4 |Comp-Check2| s5 |Check1-Check2| s6u');
 writeln(g,'             where s1,...,s6 are deviations of given difference based on DaoPhot deviations');
 {$I+$}
 mag_s:='';
 mag_cs:='';
 repeat
 error:=false;
 readln(f,first_name);
 point:=pos('.',first_name);
 mat_name:=copy(first_name,1,point)+'mat';
 {$I-$}
 assign(m1,mat_name);
 reset(m1);
 if ioresult<>0 then
  begin
   error:=true;
   beep;
   writeln(g,'         ');
  end;
 {$I+}
 if not error then
  begin
   mag_sn:='';mag_cs:='';mag_cs2:='';mag_cs3:='';
   load_fts(first_name);
   for i:=1 to variable.n do readln(m1,rec);
   if itemcount(rec) <> 0 then
      begin
       mag_s:=itemstr(4,rec);val(mag_s,mag,io);
       if mag_s='99.999' then mag_sn:='99.999';
       mag_sn:=mag_s;
       readln(m1,rec);
       mag_ds:=itemstr(4,rec);val(mag_ds,mag_dv,io);
      End
   else begin mag_sn:='99.999';mag_dv:=0; end;
   close(m1);
   assign(m1,mat_name);
   reset(m1);
   for i:=1 to comp_1.n do readln(m1,rec1);
   if itemcount(rec1) <> 0 then
      begin
       mag_s:=itemstr(4,rec1);val(mag_s,mag_c,io);
       if mag_s='99.999' then mag_cs:='99.999';
       readln(m1,rec1);
       mag_ds:=itemstr(4,rec1);val(mag_ds,mag_dc,io);
      End
   else begin mag_cs:='99.999';mag_dc:=0; end;
   close(m1);
   assign(m1,mat_name);
   reset(m1);
   for i:=1 to comp_2.n do readln(m1,rec2);
   if itemcount(rec2) <> 0 then
      begin
       mag_s:=itemstr(4,rec2);val(mag_s,mag_c2,io);
       if mag_s='99.999' then mag_cs2:='99.999';
       readln(m1,rec2);
       mag_ds:=itemstr(4,rec2);val(mag_ds,mag_dc1,io);
      End
   else begin mag_cs2:='99.999';mag_dc1:=0; end;
   close(m1);
   assign(m1,mat_name);
   reset(m1);
   for i:=1 to comp_3.n do readln(m1,rec3);
   if itemcount(rec3) <> 0 then
      begin
       mag_s:=itemstr(4,rec3);val(mag_s,mag_c3,io);
       if mag_s='99.999' then mag_cs3:='99.999';
       readln(m1,rec3);
       mag_ds:=itemstr(4,rec3);val(mag_ds,mag_dc2,io);
      End
   else begin mag_cs3:='99.999'; mag_dc2:=0; end;
   close(m1);

   if (mag_sn <> '99.999') and (mag_cs <> '99.999') then
    begin
     mc:=mag-mag_c;
     dvc:=sqrt(mag_dv*mag_dv+mag_dc*mag_dc);
    end

    else mc:=99.999;

   if (mag_sn <> '99.999') and (mag_cs2 <> '99.999') then
    begin
     mc1:=mag-mag_c2;
     dvc1:=sqrt(mag_dv*mag_dv+mag_dc1*mag_dc1);
    end
    else mc1:=99.999;

   if (mag_sn <> '99.999') and (mag_cs3 <> '99.999') then
    begin
     mc2:=mag-mag_c3;
     dvc2:=sqrt(mag_dv*mag_dv+mag_dc2*mag_dc2);
    end
    else mc2:=99.999;

   if (mag_cs <> '99.999') and (mag_cs2 <> '99.999') then
    begin
     mc3:=mag_c-mag_c2;
     dcc1:=sqrt(mag_dc*mag_dc+mag_dc1*mag_dc1);
     end
    else mc3:=99.999;

   if (mag_cs <> '99.999') and (mag_cs3 <> '99.999') then
    begin
     mc4:=mag_c-mag_c3;
     dcc2:=sqrt(mag_dc*mag_dc+mag_dc2*mag_dc2);
    end
    else mc4:=99.999;

   if (mag_cs2 <> '99.999') and (mag_cs3 <> '99.999') then
    begin
     mc5:=mag_c2-mag_c3;
     dc1c2:=sqrt(mag_dc1*mag_dc1+mag_dc2*mag_dc2);
    end
    else mc5:=99.999;

   writeln(g,juldate:10:5,' ',mc:4:3,' ',dvc:4:3,' ',mc1:4:3,' ',
   dvc1:4:3,' ',mc2:4:3,' ',dvc2:4:3,' ',mc3:4:3,' ',dcc1:4:3,' ',mc4:4:3,' ',dcc2:4:3,' ',
   mc5:4:3,' ',dc1c2:4:3);
  end;

 mag_s:='';mag_cs:='';mag_cs2:='';mag_cs3:='';
 error:=false;
 until eof(f);
 close(g);close(f);
end; (* OF Analyzing_all_files *)

Procedure Screen_for_Kresligraf;
begin

mouseoff;
beep;
cleardevice;
setfillstyle(1,white);
bar(0,0,getmaxx,getmaxy);
setfillstyle(1,darkgray);
bar(1,1,getmaxx-1,getmaxy-1);
setfillstyle(1,white);
bar(getmaxx-50,getmaxy-20,getmaxx-2,getmaxy-2);
setfillstyle(1,red);
bar(getmaxx-49,getmaxy-19,getmaxx-1,getmaxy-1);
outtextxy(getmaxx-40,getmaxy-13,'Quit');
mouseon;
end;

Procedure Kresli_graf(a,b : integer);
var     quit_mouse2 : boolean;
                inf : text;
popy,popx,dilx,dy,dily,dx,julda,maxx,minx,maxy,miny,magac : real;

procedure ozzy; (*subprocedure for kresli_graf *)
var popys,popxs,rados,jds,mags : string;
begin
maxy:=-1;miny:=100;
maxx:=0;minx:=3000000;
settextstyle(gothicfont,horizdir,4);
outtextxy(getmaxx div 2 -100,20,'Variable - Comparison');
 repeat
  readln(inf,rados);
  jds:=itemstr(1,rados);val(jds,julda,io);
  mags:=itemstr(b,rados);val(mags,magac,io);
  if julda>maxx then maxx:=julda;if julda<minx then minx:=julda;
  if magac>maxy then maxy:=magac;if magac<miny then miny:=magac;
 until eof(inf);
line(50,440,600,440);
line(60,50,60,450);
settextstyle(smallfont,horizdir,4);
outtextxy(10,getmaxy-20,'Gothic Font World!');

maxx:=maxx-2450000;minx:=minx-2450000;dx:=maxx-minx;
dilx:=dx/10;
dy:=maxy-miny;
dily:=dy/10;
settextstyle(smallfont,horizdir,4);
for i:=1 to 10 do
 begin
  popx:=minx+i*dx;str(popx:4:3,popxs);
  outtextxy(60+i*52-10,450,popxs);
  popy:=miny+i*dy;str(popy:4:3,popys);
  outtextxy(10,40+i*37-5,popys);
  line(55,40+i*37,65,40+i*37);
  line(60+i*52,445,60+i*52,435);
 end;
settextstyle(defaultfont,horizdir,1);
end;



begin
screen_for_kresligraf;
quit_mouse2:=false;
assign(inf,paramstr(2));
reset(inf);
ozzy;
 repeat
  ok:=mousepress(mx,my);
  if ok and press(mx,my,getmaxx-50,getmaxy-20,getmaxx,getmaxy) then quit_mouse2:=true;
 until quit_mouse2;

end;

Procedure Save_Data_File;
begin
beep;beep;
end;

Procedure Screen_of_menu2;
begin
mouseoff;
cleardevice;
setfillstyle(1,white);
bar(0,0,getmaxx,getmaxy);
setfillstyle(1,1);
bar(1,1,getmaxx-1,getmaxy-1);
setfillstyle(1,white);
bar((getmaxx div 2)-100,(getmaxy div 2)-100,(getmaxx div 2)+100,(getmaxy div 2)+100);
setfillstyle(1,darkgray);
bar((getmaxx div 2)-99,(getmaxy div 2)-99,(getmaxx div 2)+99,(getmaxy div 2)+99);
line((getmaxx div 2)-99,(getmaxy div 2)-80,(getmaxx div 2)+99,(getmaxy div 2)-80);
line((getmaxx div 2)-99,(getmaxy div 2)-60,(getmaxx div 2)+99,(getmaxy div 2)-60);
line((getmaxx div 2)-99,(getmaxy div 2)-40,(getmaxx div 2)+99,(getmaxy div 2)-40);
line((getmaxx div 2)-99,(getmaxy div 2)-20,(getmaxx div 2)+99,(getmaxy div 2)-20);
line((getmaxx div 2)-99,(getmaxy div 2),(getmaxx div 2)+99,(getmaxy div 2));
line((getmaxx div 2)-99,(getmaxy div 2)+20,(getmaxx div 2)+99,(getmaxy div 2)+20);
line((getmaxx div 2)-99,(getmaxy div 2)+40,(getmaxx div 2)+99,(getmaxy div 2)+40);
line((getmaxx div 2)-99,(getmaxy div 2)+60,(getmaxx div 2)+99,(getmaxy div 2)+60);
line((getmaxx div 2)-99,(getmaxy div 2)+80,(getmaxx div 2)+99,(getmaxy div 2)+80);
outtextxy((getmaxx div 2)-80,(getmaxy div 2)-93,'variable - comparison');
outtextxy((getmaxx div 2)-80,(getmaxy div 2)-73,'variable - 1. check');
outtextxy((getmaxx div 2)-80,(getmaxy div 2)-53,'variable - 2. check');
outtextxy((getmaxx div 2)-80,(getmaxy div 2)-33,'comparison - 1. check');
outtextxy((getmaxx div 2)-80,(getmaxy div 2)-13,'comparison - 2. check');
outtextxy((getmaxx div 2)-80,(getmaxy div 2)+6,'1. check - 2. check');
outtextxy((getmaxx div 2)-80,(getmaxy div 2)+26,'V-C, V-C1, V-C2');
outtextxy((getmaxx div 2)-80,(getmaxy div 2)+46,'C-C1, C-C2, C1-C2');
outtextxy((getmaxx div 2)-80,(getmaxy div 2)+66,'C-C1, C-C2, C1-C2');
setcolor(black);
outtextxy((getmaxx div 2)-80,(getmaxy div 2)+86,'Save data to a file');
setcolor(white);
setfillstyle(1,white);
bar(getmaxx-50,getmaxy-20,getmaxx-2,getmaxy-2);
setfillstyle(1,red);
bar(getmaxx-49,getmaxy-19,getmaxx-1,getmaxy-1);
outtextxy(getmaxx-40,getmaxy-13,'Quit');
setfillstyle(1,white);
bar(1,getmaxy-20,50,getmaxy-2);
setfillstyle(1,black);
bar(49,getmaxy-19,1,getmaxy-1);
outtextxy(10,getmaxy-13,'Back');

mouseon;
end;

Procedure menu2;

var quit_mouse : boolean;

begin
quit_mouse:=false;
screen_of_menu2;
mouseon;
back:=false;
repeat
 ok:=mousepress(mx,my);
 quit_mouse:=false;
 if ok and press(mx,my,getmaxx-50,getmaxy-20,getmaxx,getmaxy) then begin quit_mouse:=true; again:=false; end;
 if ok and press(mx,my,(getmaxx div 2)-99,(getmaxy div 2)-99,(getmaxx div 2)+99,(getmaxy div 2)-80) then kresli_graf(1,2);
 if ok and press(mx,my,(getmaxx div 2)-99,(getmaxy div 2)-80,(getmaxx div 2)+99,(getmaxy div 2)-60) then kresli_graf(1,3);
 if ok and press(mx,my,(getmaxx div 2)-99,(getmaxy div 2)-60,(getmaxx div 2)+99,(getmaxy div 2)-40) then kresli_graf(1,4);
 if ok and press(mx,my,(getmaxx div 2)-99,(getmaxy div 2)-40,(getmaxx div 2)+99,(getmaxy div 2)-20) then kresli_graf(1,4);
 if ok and press(mx,my,(getmaxx div 2)-99,(getmaxy div 2)-20,(getmaxx div 2)+99,(getmaxy div 2)-0) then kresli_graf(1,4);
 if ok and press(mx,my,(getmaxx div 2)-99,(getmaxy div 2)-0,(getmaxx div 2)+99,(getmaxy div 2)+20) then kresli_graf(1,4);
 if ok and press(mx,my,(getmaxx div 2)-99,(getmaxy div 2)+20,(getmaxx div 2)+99,(getmaxy div 2)+40) then kresli_graf(1,4);
 if ok and press(mx,my,(getmaxx div 2)-99,(getmaxy div 2)+40,(getmaxx div 2)+99,(getmaxy div 2)+60) then kresli_graf(1,4);
 if ok and press(mx,my,(getmaxx div 2)-99,(getmaxy div 2)+60,(getmaxx div 2)+99,(getmaxy div 2)+80) then kresli_graf(1,4);
 if ok and press(mx,my,(getmaxx div 2)-99,(getmaxy div 2)+80,(getmaxx div 2)+99,(getmaxy div 2)+100) then save_data_file;
 if ok and press(mx,my,1,getmaxy-20,50,getmaxy-2) then back:=true;
 if ok then Screen_of_menu2;
until quit_mouse or back;
mouseoff;
end;




Begin   (* Begin of main program *)
mouseinit;
nosound;
if paramcount<>3 then help;
again:=true;
mx:=0;my:=0;
mys;
screen;
scale;
read_mat_file;
mouseon;
Chose_Stars;
mouseoff;
Analyzing_all_files;
(*menu2;*)
closegraph;
textcolor(white);
textbackground(black);
clrscr;
end.  (* end of main program *)