(*   Author: Rudolf Novak
             Nicholas Copernicus Observatory & Planetarium in Brno
             Kravi hora 2
             616 00 Brno
             Czech Republic
     e-mail: rudolfn@physics.muni.cz
Last Update: 16.1.1998

If you will change this file let us know about the changes
This is Public Domain software                                      *)

Program Write_Photometry_Options_To_A_File;

Uses Crt,Dos;

var
                                        value_S  : String;
                    RN,LGD,THR,AMPSF,EPSFCP,PERR : Real;
GAIN,HGD,FWHM,LS,HS,LR,HR,WP,FR,PSFR,VPSF,FPE,PE : Real;
                                        value,io : Integer;

Procedure Help; (* If there is no input or bad one *)
begin
 clrscr;
 writeln('This program will generate "mphot.opt" file if you need');
 writeln('change THRESHOLD value during photometry');
 writeln('Read documentation first!');
 writeln;
 writeln('Rudolf Novak');
 gotoxy(1,7);
 writeln('Press a key to continue...');
 repeat until keypressed;
halt;
end;

Procedure Help_File;
begin
 clrscr;
 writeln('It is not possible to create a "mphot.opt" file. Disk full?');
 writeln;
 writeln('Press a key and try again...');
 repeat until keypressed;
 halt;
end;

Procedure constants;
var f : text;
    s1 : string[29];
Procedure File_Problem;
begin
 clrscr;
 writeln('Can read input file'+paramstr(1)+'\mphot.opt" with parameters!');
 repeat until keypressed;
 halt;
end;
begin
 {$I-}
 assign(f,paramstr(1)+'\BIN\mphot.opt');
 reset(f);
 if IOresult<>0 then file_problem;
 {$I+}
 readln(f,s1,RN);
 readln(f,s1,GAIN);
 readln(f,s1,LGD);
 readln(f,s1,HGD);
 readln(f,s1,FWHM);
 readln(f,s1,THR);
 readln(f,s1,LS);
 readln(f,s1,HS);
 readln(f,s1,LR);
 readln(f,s1,HR);
 readln(f,s1,WP);
 readln(f,s1,FR);
 readln(f,s1,PSFR);
 readln(f,s1,VPSF);
 readln(f,s1,FPE);
 readln(f,s1,AMPSF);
 readln(f,s1,EPSFCP);
 readln(f,s1,PE);
 readln(f,s1,PERR);
end;

Procedure Write_File(name : string);

var g : text;

begin
{$I-$}
assign(g,paramstr(1)+'\BIN\'+name);
rewrite(g);
if IOResult <> 0 then Help_File;
{$I+$}

writeln(g,'READ NOISE (ADU; 1 frame)  = ',rn:4:2);
writeln(g,'GAIN (e-/ADU; 1 frame)     = ',gain:4:2);
writeln(g,'LOW GOOD DATUM (in sigmas) = ',lgd:4:2);
writeln(g,'HIGH GOOD DATUM (in ADU)   = ',hgd:8:2);
writeln(g,'FWHM OF OBJECT             = ',fwhm:4:2);
writeln(g,'THRESHOLD (in sigmas)      = ',thr:4:2);
writeln(g,'LS (LOW SHARPNESS CUTOFF)  = ',ls:4:2);
writeln(g,'HS (HIGH SHARPNESS CUTOFF) = ',hs:4:2);
writeln(g,'LR (LOW ROUNDNESS CUTOFF)  = ',lr:4:2);
writeln(g,'HR (HIGH ROUNDNESS CUTOFF) = ',hr:4:2);
writeln(g,'WATCH PROGRESS             = ',wp:4:2);
writeln(g,'FITTING RADIUS             = ',fr:4:2);
writeln(g,'PSF RADIUS                 = ',psfr:4:2);
writeln(g,'VARIABLE PSF               = ',vpsf:4:2);
writeln(g,'FRACTIONAL-PIXEL EXPANSION = ',fpe:4:2);
writeln(g,'ANALYTIC MODEL PSF         = ',ampsf:4:2);
writeln(g,'EXTRA PSF CLEANING PASSES  = ',epsfcp:4:2);
writeln(g,'PERCENT ERROR (in %)       = ',pe:4:2);
writeln(g,'PROFILE ERROR (in %)       = ',perr:4:2);
close(g);
window(1,23,80,24);
textbackground(black);
gotoxy(2,24);write('FILE MPHOT.OPT SAVED, CHANGES ACCEPTED!                                             ESC --- Quit');

end;




Procedure Windows;

Var   I : Integer;
     ch : char;
   quit : boolean;

begin
 quit:=false;
 window(1,1,80,25);
 textbackground(black);
 textcolor(white);
 clrscr;
 window(1,1,50,23);
 clrscr;
 textbackground(blue);
 textcolor(white);
 writeln('ͻ');
 writeln(' READ NOISE (ADU; 1 frame)  =            ');
 writeln(' GAIN (e-/ADU; 1 frame)     =            ');
 writeln(' LOW GOOD DATUM (in sigmas) =            ');
 writeln(' HIGH GOOD DATUM (in ADU)   =            ');
 writeln(' FWHM OF OBJECT             =            ');
 writeln(' THRESHOLD (in sigmas)      =            ');
 writeln(' LS (LOW SHARPNESS CUTOFF)  =            ');
 writeln(' HS (HIGH SHARPNESS CUTOFF) =            ');
 writeln(' LR (LOW ROUNDNESS CUTOFF)  =            ');
 writeln(' HR (HIGH ROUNDNESS CUTOFF) =            ');
 writeln(' WATCH PROGRESS             =            ');
 writeln(' FITTING RADIUS             =            ');
 writeln(' PSF RADIUS                 =            ');
 writeln(' VARIABLE PSF               =            ');
 writeln(' FRACTIONAL-PIXEL EXPANSION =            ');
 writeln(' ANALYTIC MODEL PSF         =            ');
 writeln(' EXTRA PSF CLEANING PASSES  =            ');
 writeln(' PERCENT ERROR (in %)       =            ');
 writeln(' PROFILE ERROR (in %)       =            ');
 writeln('ͼ');
 gotoxy(32,2);write(rn:4:2);gotoxy(32,3);write(gain:4:2);gotoxy(32,4);write(lgd:4:2);
 gotoxy(32,5);write(hgd:8:2);gotoxy(32,6);write(fwhm:4:2);gotoxy(32,7);write(thr:4:2);
 gotoxy(32,8);write(ls:4:2);gotoxy(32,9);write(hs:4:2);gotoxy(32,10);write(lr:4:2);
 gotoxy(32,11);write(hr:4:2);gotoxy(32,12);write(wp:4:2);gotoxy(32,13);write(fr:4:2);
 gotoxy(32,14);write(psfr:4:2);gotoxy(32,15);write(vpsf:4:2);gotoxy(32,16);write(fpe:4:2);
 gotoxy(32,17);write(ampsf:4:2);gotoxy(32,18);write(epsfcp:4:2);gotoxy(32,19);write(pe:4:2);
 gotoxy(32,20);write(perr:4:2);
 i:=2;
 gotoxy(32,2);

 window(1,23,80,24); (* Help Banner *)
 textbackground(black);
 gotoxy(2,24);write('Use "up" and "down" arrows to move, "ENTER" to select. "ESC" to quit and "S" to save.');

 window(53,2,79,20); (* Info Window *)
 textbackground(red);
 textcolor(white);
 clrscr;

 writeln('ͻ');
 writeln('  ! !   WARNING    ! !  ');
 writeln('͹');
 writeln(' Edit this values just  ');
 writeln(' if you know what you   ');
 writeln(' are EXACTLY doing!     ');
 writeln('                        ');
 writeln(' THRESHOLD --- this will');
 writeln('  set the limit for     ');
 writeln('  founded stars.        ');
 writeln('(1=faint *`s 10=bright )');
 writeln(' FWHM --- This will set ');
 writeln('  fwhm of an object     ');
 writeln('   READ NOISE & GAIN    ');
 writeln(' are constants for your ');
 writeln(' camera. Change this    ');
 writeln(' just first time.       ');
 writeln(' Defaults are for ST-7  ');
   write('ͼ');
 window(1,1,50,23);
 textbackground(blue);
 gotoxy(32,2);
 repeat
  if i>20 then i:=20;
  if i<2 then i:=2;
  if keypressed then
  begin
   ch:=readkey;
    case ch of
     #80 : begin if i<>20 then i:=i+1;gotoxy(32,i); end;
     #72 : begin if i<>2 then i:=i-1; gotoxy(32,i); end;
     #13 : case i of
                 2 :
                      begin
                       gotoxy(32,2);
                       textcolor(yellow);
                       write('           ');
                       gotoxy(32,2);
                       readln(rn);
                       textcolor(white);
                       gotoxy(32,2);
                       write(rn:4:2);
                       ch:=#0;
                       i:=i+1;
                       gotoxy(32,3);
                      end;

                 3 :
                      begin
                       gotoxy(32,3);
                       textcolor(yellow);
                       write('           ');
                       gotoxy(32,3);
                       readln(gain);
                       textcolor(white);
                       gotoxy(32,3);
                       write(gain:4:2);
                       ch:=#0;
                       i:=i+1;
                       gotoxy(32,4);
                      end;

                 4 :
                      begin
                       gotoxy(32,4);
                       textcolor(yellow);
                       write('           ');
                       gotoxy(32,4);
                       readln(lgd);
                       textcolor(white);
                       gotoxy(32,4);
                       write(lgd:4:2);
                       ch:=#0;
                       i:=i+1;
                       gotoxy(32,5);
                      end;

                 5 :
                      begin
                       gotoxy(32,5);
                       textcolor(yellow);
                       write('           ');
                       gotoxy(32,5);
                       readln(hgd);
                       textcolor(white);
                       gotoxy(32,5);
                       write(hgd:4:2);
                       ch:=#0;
                       i:=i+1;
                       gotoxy(32,6);
                      end;

                 6 :
                      begin
                       gotoxy(32,6);
                       textcolor(yellow);
                       write('           ');
                       gotoxy(32,6);
                       readln(fwhm);
                       textcolor(white);
                       gotoxy(32,6);
                       write(fwhm:4:2);
                       ch:=#0;
                       i:=i+1;
                       gotoxy(32,7);
                      end;

                 7 :
                      begin
                       gotoxy(32,7);
                       textcolor(yellow);
                       write('           ');
                       gotoxy(32,7);
                       readln(thr);
                       textcolor(white);
                       gotoxy(32,7);
                       write(thr:4:2);
                       ch:=#0;
                       i:=i+1;
                       gotoxy(32,8);
                      end;

                 8 :
                      begin
                       gotoxy(32,8);
                       textcolor(yellow);
                       write('           ');
                       gotoxy(32,8);
                       readln(ls);
                       textcolor(white);
                       gotoxy(32,8);
                       write(ls:4:2);
                       ch:=#0;
                       i:=i+1;
                       gotoxy(32,9);
                      end;

                 9 :
                      begin
                       gotoxy(32,9);
                       textcolor(yellow);
                       write('           ');
                       gotoxy(32,9);
                       readln(hs);
                       textcolor(white);
                       gotoxy(32,9);
                       write(hs:4:2);
                       ch:=#0;
                       i:=i+1;
                       gotoxy(32,10);
                      end;

                 10 :
                      begin
                       gotoxy(32,10);
                       textcolor(yellow);
                       write('           ');
                       gotoxy(32,10);
                       readln(lr);
                       textcolor(white);
                       gotoxy(32,10);
                       write(lr:4:2);
                       ch:=#0;
                       i:=i+1;
                       gotoxy(32,11);
                      end;

                 11 :
                      begin
                       gotoxy(32,11);
                       textcolor(yellow);
                       write('           ');
                       gotoxy(32,11);
                       readln(hr);
                       textcolor(white);
                       gotoxy(32,11);
                       write(hr:4:2);
                       ch:=#0;
                       i:=i+1;
                       gotoxy(32,12);
                      end;


                 12 :
                      begin
                       gotoxy(32,12);
                       textcolor(yellow);
                       write('           ');
                       gotoxy(32,12);
                       readln(wp);
                       textcolor(white);
                       gotoxy(32,12);
                       write(wp:4:2);
                       ch:=#0;
                       i:=i+1;
                       gotoxy(32,13);
                      end;

                 13 :
                      begin
                       gotoxy(32,13);
                       textcolor(yellow);
                       write('           ');
                       gotoxy(32,13);
                       readln(fr);
                       textcolor(white);
                       gotoxy(32,13);
                       write(fr:4:2);
                       ch:=#0;
                       i:=i+1;
                       gotoxy(32,14);
                      end;

                 14 :
                      begin
                       gotoxy(32,14);
                       textcolor(yellow);
                       write('           ');
                       gotoxy(32,14);
                       readln(psfr);
                       textcolor(white);
                       gotoxy(32,14);
                       write(psfr:4:2);
                       ch:=#0;
                       i:=i+1;
                       gotoxy(32,15);
                      end;

                 15 :
                      begin
                       gotoxy(32,15);
                       textcolor(yellow);
                       write('           ');
                       gotoxy(32,15);
                       readln(vpsf);
                       textcolor(white);
                       gotoxy(32,15);
                       write(vpsf:4:2);
                       ch:=#0;
                       i:=i+1;
                       gotoxy(32,16);
                      end;

                 16 :
                      begin
                       gotoxy(32,16);
                       textcolor(yellow);
                       write('           ');
                       gotoxy(32,16);
                       readln(fpe);
                       textcolor(white);
                       gotoxy(32,16);
                       write(fpe:4:2);
                       ch:=#0;
                       i:=i+1;
                       gotoxy(32,17);
                      end;

                 17 :
                      begin
                       gotoxy(32,17);
                       textcolor(yellow);
                       write('           ');
                       gotoxy(32,17);
                       readln(ampsf);
                       textcolor(white);
                       gotoxy(32,17);
                       write(ampsf:4:2);
                       ch:=#0;
                       i:=i+1;
                       gotoxy(32,18);
                      end;

                 18 :
                      begin
                       gotoxy(32,18);
                       textcolor(yellow);
                       write('           ');
                       gotoxy(32,18);
                       readln(epsfcp);
                       textcolor(white);
                       gotoxy(32,18);
                       write(epsfcp:4:2);
                       ch:=#0;
                       i:=i+1;
                       gotoxy(32,19);
                      end;

                 19 :
                      begin
                       gotoxy(32,19);
                       textcolor(yellow);
                       write('           ');
                       gotoxy(32,19);
                       readln(pe);
                       textcolor(white);
                       gotoxy(32,19);
                       write(pe:4:2);
                       ch:=#0;
                       i:=i+1;
                       gotoxy(32,20);
                      end;

                 20 :
                      begin
                       gotoxy(32,20);
                       textcolor(yellow);
                       write('           ');
                       gotoxy(32,20);
                       readln(perr);
                       textcolor(white);
                       gotoxy(32,20);
                       write(perr:4:2);
                       ch:=#0;
                       i:=i+1;
                       gotoxy(32,20);
                      end;
          end;
      #115 : write_file('mphot.opt');
      'S'  : write_file('mphot.opt');

      #27 :
           begin
            window(1,23,80,24);
            textbackground(black);
            gotoxy(2,24);
            writeln('                                                                                         ');
            writeln('Quit? (y/n)');
            ch:=readkey;
            if ch='y' then quit:=true
            else quit:=false;
            window(1,23,80,24); (* Help Banner *)
            textbackground(black);
            gotoxy(2,24);write('Use "up" and "down" arrows to move, "ENTER" to select. "ESC" to quit and "S" to save.');
            window(1,1,50,23);
            gotoxy(32,2);
            ch:=#0;
           end;

    end;
   end;
 until quit;
  gotoxy(32,2);read;
  window(1,1,80,30);
  textbackground(black);
  textcolor(white);
end;



begin                               (* Begin of main program *)
 if ParamCount<>1 then Help;
 Constants;
 Windows;
 (*write_file('mphot.opt');*)
 window(1,1,80,25);
 textcolor(white);
 textbackground(black);
 clrscr;
end.                                (* And finaly the end...*)