@echo New files only photometry:
@echo ***************
@echo Listing data...
@echo ***************
dir /b /on /a-d %PATHD%\*.* >temp\all.dir
bin\mkdif temp\all.dir temp\old.dir temp\dir.dir bin\oldcount.bat
call bin\oldcount.bat
bin\check %oldcount% oldcount bin\oldcount.bat
@if ERRORLEVEL 1 echo Error setting number of old images - probably too little space for system variables, halting procedure... 
if ERRORLEVEL 1 GOTO END
copy temp\all.dir temp\old.dir /Y
bin\mklist temp\dir.dir %PATHD%

@echo **************************
@echo Converting ST-X to FITS...
@echo **************************
bin\konve -flip x -c %oldcount% @temp\LIST.DAT par=bin\par.dat mask=FITS\kou????.fts tcor=%1

dir /b /on /s fits\*.fts >temp\allf.dir
bin\mkdif temp\allf.dir temp\oldf.dir temp\nfits.dir
copy temp\allf.dir temp\oldf.dir /Y

@echo ******************
@echo Dark correction...
@echo ******************
bin\darkbat @temp\nfits.dir dark=temp\dark.fts mask=.

@echo ******************
@echo Flat correction...
@echo ******************
bin\flatbat @temp\nfits.dir flat=temp\flat.fts mask=.

@echo *************
@echo Photometry...
@echo *************
copy bin\mp*.opt %MUNIDIR%
bin\muniphot @temp\nfits.dir com=bin\com.dat
del %MUNIDIR%\mp*.opt

@echo ***********
@echo Matching...
@echo ***********

dir /b /on /s fits\*.srt > temp\alls.dir
bin\mkdif temp\alls.dir temp\olds.dir temp\srt.dir
copy temp\alls.dir temp\olds.dir /Y

@if not exist fits\%REF% echo Error - selected reference file does not exist!
@if not exist fits\%REF% goto end
bin\wrref fits\%REF%
move ref.dat fits\ref.dat
bin\munimat.exe @temp\srt.dir ref=fits\ref.dat

dir /b /on /s fits\*.mat >temp\mat.dir
dir /b /on /s fits\*.fts >temp\fits.dir

:end

