program editpar;

{Seeks for a string - parameter's name - (f.e."datapath") in a text file
and writes a new value of this parameter (f.e."c:\data"). If the parameter
is not found in the file, nothing is done.

After the name of the parameter in the text file must follow "=" and
then the value, all WITHOUT SPACES, and the rest of the line must
be empty!

F. ex. "datapath=c:/data"

When the new value is "d:\", then the result is "datapath=d:\"


Author: Lukas Kral <krall@troja.fjfi.cvut.cz>
Last change: Jan 2001}

uses crt,dos,MyUtils;

var t,temp:text;
    n,parpos:longint;
    err:boolean;
    ch:char;
    newvalue,oldvalue,command:string;

begin

if (paramcount<2) or (paramcount>3) then begin
  writeln('Bad number of parameters!');
  writeln('Use: editpar [filename] [parameter name] [new value]');
  writeln('(the [new value] can be omitted, when the new value should be an empty string)');
  halt;
end;

if (paramcount=3) then newvalue:= paramstr(3)
else newvalue:= '';

assign(t,paramstr(1));
{$I-}
reset(t);
{$I+}
if IOResult<>0 then begin
  clrscr;
  crash('File not found!'+#13+#10+'File: '+paramstr(1));
end;

FindStr(t,(paramstr(2)+'='),err,parpos);
close(t);

if err=true then begin
  writeln('Parameter ',paramstr(2),' not found in file ',paramstr(1),'!');
  halt;
end;

assign(temp,'temp.txt');
rewrite(temp);
reset(t);

for n:=1 to (parpos-1+length(paramstr(2))) do begin {copying first part}
  read(t,ch);                                       {of the file}
  write(temp,ch);
end;

write(temp,'=');
writeln(temp,newvalue);   {writing new value}

read(t,ch);
readln(t,oldvalue);          {reading old value only for info}

while not eof(t) do begin    {copying the rest of the file}
  read(t,ch);
  write(temp,ch);
end;

close(t);
close(temp);

erase(t);

Command:= '/C copy temp.txt ' + paramstr(1);

SwapVectors;
Exec(GetEnv('COMSPEC'), Command);
SwapVectors;

if DosError=0 then erase(temp)
else writeln('Error - cannot move the resulting file - use the backup temp.txt');

writeln;
writeln('Results:');
writeln('========');
writeln('File:      ',paramstr(1));
writeln('Parameter: ',paramstr(2));
writeln('Old value: ',oldvalue);
writeln('New value: ',newvalue);
writeln('Successfully changed.');
end.