program filter;

{data filtering routine for Munipack output data files

Created by Rudolf Novak <codel@ian.cz>
Modified by Lukas Kral <krall@troja.fjfi.cvut.cz> in May 2001

version 3.0

input: input data file
output: output data file

Only data with s1 <= mean(s1) + coef*sigma(s1) will be leaved in

s1 means the third column in standard Munipack output file
= st. dev. of the V-C magnitude

If coef<0 then only blank lines and bad data removal will be done,
no filtering. Bad data means 2nd col. = 99.999

}


uses crt,dos;

const nhead = 2; {number of lines in header of input file to skip}

var f,g : text;
    i   : integer;
    a   : double;
    b,c,mean,sigma,border,coef : real;
    st  : string;
    n   : longint;

function bad(b:real):boolean; {bad magnitude}
begin
  if (b>=100) or (b<=99.998) then bad:=false
  else bad:=true;
end;

{is it end of the input file filled with spaces only?}
function endf(a,b,c:real; var f:text):boolean;
begin
  if (a=0) and (b=0) and (c=0) and (eof(f)=true) then endf:= true
  else endf:= false;
end;


begin
clrscr;

if paramcount <> 2 then
 begin
  writeln('filter.exe input_file coef');
  writeln;
  writeln('Only data with s1 <= mean(s1) + coef*sigma(s1) will be leaved in');
  writeln('If coef<0 then no filtering will be performed');
  writeln('(only blank lines and bad data removal)');
  halt;
 end;

coef:= 0;

val(paramstr(2),coef,i);
if (i<>0) then begin
  writeln('Error reading 3rd parameter - must be a number!');
  readkey;
  halt;
end;



assign(f,paramstr(1));


{first, lets find mean and sigma of the 3rd column of input file}

{1. finding the mean}

{$I-}
reset(f);
{$I+}
if IOResult <> 0 then begin
  writeln('Error - cannot open file "',paramstr(1),'"!');
  readkey;
  halt;
end;

for i:=1 to nhead do begin {skipping header}
  readln(f,st);
end;

mean:= 0;
n:= 0; {count of data}

while not eof(f) do begin
 readln(f,a,b,c,st);
 if (not bad(b)) and (not endf(a,b,c,f)) then begin
   mean:= mean + c;
   inc(n);
 end;
end;

close(f);

if n=0 then begin
  writeln('Error - no data found!');
  readkey;
  halt;
end;

mean:= mean/n;


{2. finding the standard deviation}
reset(f);

for i:=1 to nhead do begin {skipping header}
  readln(f,st);
end;

sigma:=0;

while not eof(f) do begin
 readln(f,a,b,c,st);
 if (not bad(b)) and (not endf(a,b,c,f)) then
   sigma:= sigma + (c - mean)*(c - mean);
end;

sigma:= sqrt(sigma/(n - 1));
writeln('3rd column: mean = ',mean:0:5,', sigma = ',sigma:0:6);
writeln;
close(f);

border:= mean + coef*sigma;

(*if paramstr(5)='3' then begin
  {skipping first few lines with expected header}
  for i:=1 to nhead do begin
    readln(f);
  end;

  while not eof(f) do begin
    readln(f,a,b,c);
    if (c <= (mu+sig*3)) and (not bad(b)) and (not endf(a,b,c,f)) then
     writeln(g,a:0:6,' ',b:5:3,' ',c:5:3);
  end;
end;*)


{doing final copying}

assign(g,'temp.txt');
rewrite(g);
reset(f);

{copying the header}
for i:=1 to nhead do begin
  readln(f,st);
  writeln(g,st);
end;

n:= 0; {now count of removed non-blank lines}

if coef>0 then begin
{filtering}
  while not eof(f) do begin
   readln(f,a,b,c,st);
   if (c <= border) and (not bad(b)) and (not endf(a,b,c,f)) then
     writeln(g,a:0:6,' ',b:5:3,' ',c:5:3,st);
   if (c > border) or (bad(b)) then inc(n);
  end;
end
else begin
{only blank lines and bad data removal}
  while not eof(f) do begin
   readln(f,a,b,c,st);
   if (not bad(b)) and (not endf(a,b,c,f)) then
     writeln(g,a:0:6,' ',b:5:3,' ',c:5:3,st);
  end;
end;

close(f);
close(g);

erase(f);
rename(g,paramstr(1));

writeln('Data successfully filtered.');
if coef>=0 then writeln(n,' non-blank lines were removed.');
writeln('Press any key...');
readkey;

end.
