program fitsv;

{
Simple FITS Viewer version 0.7
Lukas Kral <krall@troja.fjfi.cvut.cz>

Function DetectSVGA256 taken from some older program, I cannot remember
the author :-)
}
uses graph,crt,MyUtils,ftsread;

const version:string = '0.7';

var i,n,naxis1,naxis2,errcode:integer;
    gd,gm:integer;
    ch:char;
    t1,t2,datastart,pos,max,min:longint;
    f:text;
    low,high,bzero,tt:longint;
    AutoDetectPointer : pointer;
    tr,bscale,aver,koef:real;
    px:word;
    err:boolean;
    st:string;


{$F+}
function DetectSVGA256 : integer;
{ Detects ?VGA or MCGA video cards }
var
  DetectedDriver : integer;
  SuggestedMode  : integer;
begin
  DetectGraph(DetectedDriver, SuggestedMode);
  if (DetectedDriver = VGA) or (DetectedDriver = MCGA) then
    DetectSVGA256 := 3        { Default video mode = 0 }
  else
    DetectSVGA256 := grError; { Couldn't detect hardware }
end; { DetectVGA256 }
{$F-}


procedure GraphInitError(gerr:integer);
begin
writeln('Cannot initialize graphics:');
case abs(gerr) of
1 : writeln('BGI graphics not installed!');
2 : writeln('Graphics hardware not detected!');
3 : writeln('Device driver file not found!');
4 : writeln('Invalid device driver file!');
5 : writeln('Not enough memory to load driver!');
6 : writeln('Out of memory in scan fill!');
7 : writeln('Out of memory in flood fill!');
8 : writeln('Font file not found!');
9 : writeln('Not enough memory to load font!');
10: writeln('Invalid graphics mode for selected driver!');
11: writeln('Graphics error (generic error)!');
12: writeln('Graphics I/O error!');
13: writeln('Invalid font file!');
14: writeln('Invalid font number!');
end;
readkey;
end;


{=================================================}

begin
clrscr;

high:=0; low:=0;
aver:=0.0;
datastart:=2880;
bscale:=1.0;
bzero:=0;
naxis1:=382;
naxis2:=255;
max:=-100000;
min:=100000;

if paramcount=0 then begin
 writeln('Simple FITS Viewer by Lukas Kral');
 writeln('Use: fitsv [filename of FITS image]  (or fitsv ? for help)');
 halt;
end;

if paramstr(1)='?' then begin
  writeln('Simple FITS viewer, version ',version);
  writeln('Written by Lukas Kral <krall@troja.fjfi.cvut.cz>');
  writeln('Use to view 16-bit FITS images not larger than 800x600 pixels');
  writeln('You must have a SVGA graphics card');
  halt;
end;

writeln('Reading FITS file...');

assign(f,paramstr(1));

{$I-}
reset(f);

if IOresult<>0 then begin
  writeln('Cannot open file ',paramstr(1),' !');
  halt;
end;
{$I+}


{getting info from the fits file:}

{how long is the header?}
findstr(f,'END',err,pos);
close(f);
if err=false then begin
  datastart:= (pos div 2880 + 1)*2880;
end
else begin
  writeln('End of FITS header not found!');
  halt;
end;

reset(f);
readpar(f,'SIMPLE',st,err);
close(f);
if err=false then begin
  if (st<>'T') then crash('Only simple FITS images supported!');
end
else crash('Cannot read SIMPLE parameter!');


reset(f);
readpar(f,'BITPIX',st,err);
close(f);
if err=false then begin
  val(st,tt,i);
  if (i=0) and (tt<>16) then crash('Only 16-bit images supported!');
end
else crash('Cannot read BITPIX parameter!');

reset(f);
readpar(f,'NAXIS',st,err);
close(f);
if err=false then begin
  if (st<>'2') then crash('Only FITS images with 2 axes supported!');
end
else crash('Cannot read NAXIS parameter!');

reset(f);
readpar(f,'NAXIS1',st,err);
close(f);
if err=false then begin
  val(st,tt,i);
  if (i=0) then naxis1:= tt
  else crash ('Error reading NAXIS1');
end
else crash('Cannot read NAXIS1 parameter!');
if naxis1>800 then crash('Sorry, image too large');

reset(f);
readpar(f,'NAXIS2',st,err);
close(f);
if err=false then begin
  val(st,tt,i);
  if (i=0) then naxis2:= tt
  else crash('Error reading NAXIS2');
end
else crash('Cannot read NAXIS2 parameter!');
if naxis2>600 then crash('Sorry, image too large');

reset(f);
readpar(f,'BZERO',st,err);
close(f);
if err=false then begin
  val(st,tr,i);
  if (i=0) then bzero:= trunc(tr)
  else crash('Error reading BZERO');
end;

reset(f);
readpar(f,'BSCALE',st,err);
close(f);
if err=false then begin
  val(st,tr,i);
  if (i=0) then bscale:= tr
  else crash('Error reading BSCALE');
end;


{^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^}
{reading the image itself - at first to find average, max and min pixel}


reset(f);

for i:=1 to datastart do begin
  if not eof(f) then read(f,ch)
  else begin
    crash('Unexpected end of file!');
  end;
end;

for i:=0 to (naxis2-1) do begin
  for n:=0 to (naxis1-1) do begin
    read(f,ch); t1:=ord(ch);
    read(f,ch); t2:=ord(ch);
    tt:= t1*256 + t2;
    if tt>32767 then tt:= tt - 65536;

    if round(bscale*tt + bzero)>=0 then px:= round(bscale*tt + bzero)
    else px:= 0;

    if px>max then max:=px;
    if px<min then min:=px;
    aver:= aver + px;
  end;
end;
close(f);

tr:=naxis1;
tr:= tr*naxis2;
aver:= aver/(tr); {average value}


{-------------------------------------------------------------------}
{showing the image}

AutoDetectPointer := @DetectSVGA256;   { Point to detection routine }
gd := InstallUserDriver('SVGA256', AutoDetectPointer);
gm := 3;

initgraph(gd,gm,'');
errcode:= GraphResult;
if errcode<>0 then begin
  closegraph;
  GraphInitError(errcode);
  halt;
end;

for i:=0 to 63 do begin
  SetRGBPalette(i,i,i,i);
end;

setcolor(45);
outtextxy(30,560,'Use arrow keys to adjust brightness/contrast, PgUp/PgDown to change the step, Esc to exit');

high:= max;
low:= round(aver-2*(aver-min));
koef:= 0.1;

repeat
  reset(f);

  for i:=1 to datastart do begin
    if not eof(f) then read(f,ch)
    else begin
      crash('Unexpected end of file!');
    end;
  end;

 for n:=0 to (naxis2-1) do begin
  for i:=0 to (naxis1-1) do begin

     read(f,ch); t1:=ord(ch);
     read(f,ch); t2:=ord(ch);
     tt:= t1*256 + t2;
     if tt>32767 then tt:= tt - 65536;

     if round(bscale*tt + bzero)>=0 then px:= round(bscale*tt + bzero)
     else px:= 0;

     tr:= px;
     if max<>min then begin
       tr := tr - low;
       tr := 63*tr/(high - low);
       if tr>=0 then px:=round(tr) else px:=0;
       if px>63 then px:= 63;
     end
     else px:=0;

     putpixel(i,n,px);

   end;
  end;

close(f);

  tt:=rdkey;
  if (tt=-77) then high:=round(high + koef*(high-low));
  if (tt=-75) and (round(high - koef*(high - low))>low) then high:=round(high - koef*(high-low));
  if (tt=-72) and (round(low + koef*(high - low))<high) then low:=round(low + koef*(high-low));
  if (tt=-80) then low:=round(low - koef*(high - low));
  if tt=-73 then koef:= koef*1.5;
  if tt=-81 then koef:= koef/1.5;

until tt=27;

closegraph;


writeln('Simple FITS Viewer ',version,' by Lukas Kral ... Bye!');

end.