 {~ Graph from a text file on the screen (for PostScript or LaTeX ouptut use ~}
 {~  Graph_d).~}

Program Munigraf; {by Rudolf Novak}
           {adaptation to tolerate text lines,
            allowing arbitrary columns for X and Y,
            and speaking English (leaving the source code being rather Czech)
                 by Jan Hollan}
(*  Copyright (C) 1999 Jan Hollan

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*)

(*edited by Lukas Kral in 2001 to reject values 99.999 - photometry errors
and adapted to run under Munipack - different labels etc.
Ability to change y range by arrows and grid lines were added
Renamed from Grafik to Munigraf
*)


Uses crt,dos,graph, {: Borland units}
                    {and J.Hollan's units: }
     g_scree,regress,Str_Num,
     {and L. Kral's unit: }
     MyUtils;

const
 Pos_X:byte=1;
 Pos_Y:byte=2;
 Printer_mode:byte=1; {9 for 9-needle Epson printer, 24 for 24-needle printer}
 h1=
 'Usage:'+cl2+

 'Munigraph <file> [<X-axis description> <Y-axis description> <Graph description>'+cl+
 '       /i /x# /y# /p# /m# /l#'+cl2;

 h2=
 '  Makes a graph from a text file. Lines with no numbers in x and y columns'+cl+
 'are ignored (columns: words separated by blanks). No parameters other than'+cl+
 'file name are obligatory. Graph description may contain up to two words.'+cl;
 h3=
 '  Parameters starting with / (or with -) are:'+cl+
 '/i reverses an Y-axis,'+cl+
 '/x# gives a column for x-values (default 1),'+cl+
 '/y# gives a column for y-values (default 2).'+cl+
 '/p9 switches to Epson 9-needle printer, /p24 to 24-needle one for hardcopy'+cl;
 h4=
 '/m Gives maximal value of Y axis and switch auto scale off'+cl+
 '/l Gives minimal value of Y axis and switch auto scale off'+cl;
 h5=
 '  Program ends on pressing Esc key, however, pressing P produces a hardcopy'+cl+
 'of the screen on a printer (default Consul CS 212-25, but this can be changed'+cl+
 'to some Epson printer by changing Printer_mode in the source code to 9 or 24).'+cl;
 h6=
 '  Example:'+cl+
 'MUNIGRAPH RT_And.dat Time Faintness RT And /i /x2 /y4'+cl2;
 h7=
'((C) R.Novak+J.Hollan, N.Copernicus Observatory and Planetarium in Brno, 1999;'+cl+
' subject to the GNU General Public License, http://www.gnu.org/copyleft;'+cl+
' source code available at http://astro.sci.muni.cz/pub/hollan/programmes)'+cl;


{just initialization:}
 jp:byte=1; {order of positional command-line parameter}

var
       f,g                                                          : Text;

       io,tecka,i,dx,dy,y_osa,x_osa,kcode                           : Integer;

       maxy,miny,dily,stupeny,x,ny,maxx,
       dilx,stupenx,dilekx,dileky,x_graf,y_graf,
       minx,ypol,dif_y,mean_x,mean_y,maxx_y,minx_y,
       maxy_x,miny_x,dif_x,sum_x,sum_y,sum_sqx,sum_xy,
       c_a,c_b,bd,suma,st_dev,max_y,low_y,
       stepcoef, range, offset                                      : Real;

       nadpis,soub,str_maxx,str_minx,str_maxy,
       str_miny,str_dily,str_dilx,xpopis,ypopis,
       NadpisGrafu,par                                              : String;

       ch                                                           : Char;

       inv,xp,yp,np,tisk,osy_auto                                   : Boolean;

       PolDegree,j                                                  : Byte;

       gmy,gmx,maxgx,maxgy,mingx,mingy,gridlength                   : Integer;

       countik,pocet                                                : longint;




procedure help;
begin
 writeln('This program must run under Munipack!');
 write(h1,h2,h3,h4,h5,h6);
 halt;
end;

procedure input_xy;
var line:string; IC:byte; wrong_code:integer;
begin
 wrong_code:=1;
 while (wrong_code>0) and not(eof(f)) do
  begin
   readln(f,line);
   IC:=ItemCount(line);
   if Pos_X <= IC then val(ItemStr(Pos_X,line),x,wrong_code);
   if wrong_code=0 then
    if Pos_Y <= IC then val(ItemStr(Pos_Y,line),ny,wrong_code);
  end;
end;





procedure nacti;
begin
  sum_x:=0;sum_y:=0;sum_sqx:=0;sum_xy:=0;
  mean_Y:=0;
  mean_X:=0;
  countik:=0;
  pocet:=0;
  i:=0;
  maxx:=-9999999;
  minx:=99999999;
  miny:=99999999;
  maxy:=-9999099;
  {$I-}
  assign(f,soub);
  reset(f);
  if IOresult <> 0 then
   begin
    clrscr;
    textcolor(white);
    Writeln('Given file not present!');
    ch:=readkey;
    help;
   end;
  {$I+}
   writeln('Reading line:',pocet);
  while not eof(f) do
   begin
     input_xy;
     if (ny<=99.998) or (ny>=100) then begin    {rejects 99.999}
       inc(countik,1);
       sum_x:=sum_x+x;sum_y:=sum_y+ny;sum_sqx:=sum_sqx+x*x;sum_xy:=sum_xy+x*ny;
       mean_x:=mean_x+x;
       mean_y:=mean_y+ny;
       if x > 2000000 then x:=x-2400000;
       if x > maxx then begin maxx:=x; maxx_y:=ny; end;
       if x < minx then begin minx:=x; minx_y:=ny; end;
       if ny > maxy then begin maxy:=ny; maxy_x:=x; end;
       if ny < miny then begin miny:=ny; miny_x:=x; end;
       inc(pocet);
       if (pocet mod 100 ) =0 then
         begin
         gotoxy(16,2);
         write(pocet)
         end;
     end;
   end;
close(f);
mean_x:=mean_x/countik;mean_y:=mean_y/countik;
if not osy_auto then
 begin
  maxy:=max_y;miny:=low_y;
 end;
end;

Procedure coeff;
begin
 suma:=0;
(* reginit(1);*)
 assign(f,paramstr(1));
 reset(f);
 while not eof(f) do
  begin
    input_xy;
    regenter(x,ny);
  end;
 if not regcompute then halt;
 close(f);
 assign(f,paramstr(1));
 reset(f);
  while not eof(f) do
  begin
    input_xy;
    suma:=suma+(ny-(polynome_coeffs[2]*x+polynome_coeffs[1]))*
               (ny-(polynome_coeffs[2]*x+polynome_coeffs[1]));
  end;
 st_dev:=sqrt((suma/(countik-1)));
 close(f);
end;

(* NOT IMPLEMENTED NOW
Procedure Regrese(poldegree : Byte);
begin
 {$I-}
  assign(f,soub);
  reset(f);
  if IOresult <> 0 then
   begin
    clrscr;
    textcolor(white);
    Writeln('Given file not present!');
    ch:=readkey;
    help;
   end;
  {$I+}
 reginit(PolDegree);
 i:=0;
 while not eof(f) do
  begin
   inc(i);
   input_xy;
   regenter(x,ny);
  end;
 regcompute;
 x:=minx;
 moveto(0,0);
 repeat
  ypol:=regvalue(x,yd);
  if (maxy>=ypol) and (ypol>=miny) then
   begin
     x_graf:=mingx+(x-minx)*dilekx;
     if not inv then y_graf:=maxgy-(ypol-miny)*dileky
     else  y_graf:=30+mingy+(ny-miny)*dileky;
   end;
  x:=x+1/dilekx;
 until x > maxx;
sound(100);
delay(100);
nosound;
ch:=readkey;
end; *)

procedure grafika;
var gd,gm : integer;
begin
 gd:=0;
 initgraph(gd,gm,getenv('bgi'));
end;

procedure osy;

begin
 gmy:=getmaxy;          (*Graficke konstanty*)
 gmx:=getmaxx;
 maxgx:=gmx-50;
 mingx:=50;
 maxgy:=gmy-50;
 mingy:=10;
 setfillstyle(1,15);
 bar(0,0,gmx,gmy);
 setfillstyle(1,0);
 bar(1,1,gmx-1,gmy-1);
 line(40,maxgy,maxgx+10,maxgy);            (* osy grafu*)
 line(50,gmy-40,50,20);                    (*          *)
 line(45,mingy+30,55,mingy+30);            (*                                       *)
 settextstyle(smallfont,horizdir,4);
 str(minx:4:2,str_minx);
 str(maxx:4:2,str_maxx);
 str(maxy:4:2,str_maxy);
 str(miny:4:2,str_miny);
 settextstyle(Triplexfont,horizdir,3);
 if (NadpisGrafu<>'0') then outtextxy((gmx div 2)-60, 10,NadpisGrafu);
 settextstyle(smallfont,horizdir,4);
 outtextxy(maxgx-10,maxgy+25,'  ');
 outtextxy(10,5,'   ');
 dy:=maxgy-(mingy+30);
 dx:=maxgx-50;

 if (maxy-miny)<>0 then begin
   dily:=(maxy-miny)/20;
   stupeny:=(dy*dily)/(maxy-miny);
 end
 else begin
   closegraph;
   writeln('Error - only one Y value');
   readkey;
   halt;
 end;

 if yp then outtextxy(10,5,ypopis);

  for i:=0 to 20 do                 (*Automaticky popis osy y*)
   begin
    if not inv then y_osa:=round((maxgy-i*stupeny)) else y_osa:=round((mingy+i*stupeny+30));
    if not inv then str((miny+i*dily):4:3,str_dily) else str((miny+i*dily):4:3,str_dily);
    line(45,y_osa,gridlength,y_osa);
    outtextxy(10,y_osa-10,str_dily);
   end;

 if (maxx-minx)<>0 then begin
   dilx:=(maxx-minx)/10;         (* Automaticky popis osy X*)
   stupenx:=(dx*dilx)/(maxx-minx);
 end
 else begin
   closegraph;
   writeln('Error - only one X value');
   readkey;
   halt;
 end;

 if xp then outtextxy(getmaxx-70,gmy-20,xpopis);
   for i:=0 to 10 do
    begin
     x_osa:=round(mingx+i*stupenx);
     str((minx+i*dilx):4:2,str_dilx);
     if i = 10 then begin outtextxy(x_osa-15,maxgy+10,str_dilx); i:=10; end;
     line(x_osa,maxgy+5,x_osa,maxgy-5);
     if  i <> 10  then outtextxy(x_osa-10,maxgy+10,str_dilx);
    end;

  setcolor(15);
  outtextxy(10,getmaxy-20,'Arrows .. adjust offset & range, PgUp & PgDown .. change the step, g .. grid lines, Esc .. quit');
  setcolor(7);

  dilekx:=dx/(maxx-minx);           (*Vykreslovani bodu grafu*)
  dileky:=dy/(maxy-miny);
  moveto(0,0);
  for i:=0 to pocet-1 do
   begin
     input_xy;
     if (ny<=99.998) or (ny>=100) then begin
       if x > 2000000 then x:=x-2400000;
       x_graf:=mingx+(x-minx)*dilekx;
       if not inv then y_graf:=maxgy-(ny-miny)*dileky else  y_graf:=30+mingy+(ny-miny)*dileky;
       setcolor(15);
        if tisk then
         begin
          line(round(x_graf)+2,round(y_graf),round(x_graf)-2,round(y_graf));
          line(round(x_graf),round(y_graf)+2,round(x_graf),round(y_graf)-2);
         end
        else
        begin
          line(round(x_graf)+1,round(y_graf),round(x_graf)-1,round(y_graf));
          line(round(x_graf),round(y_graf)-1,round(x_graf),round(y_graf)+1);
        end;
       setcolor(7);
     end
     else i:= i - 1;
   end;
  setcolor(lightgray);

end;


begin                                         {ZACATEK PROGRAMU}
 gridlength:=55;
 FileMode:=0;
 inv:=false;np:=false;xp:=false;yp:=false;tisk:=false;osy_auto:=true;
 xpopis:='';ypopis:='';nadpisgrafu:='';
 if paramcount = 0 then help;
 for j:=1 to paramcount do
  begin
   par:=paramstr(j);
   if pos('?',par) > 0 then help;
   if par[1] in ['/','-'] then
    case UpCase(par[2]) of
     'I': inv:=true;
     'X': Pos_X:=I_S(copy(par,3,length(par)-2));
     'Y': Pos_Y:=I_S(copy(par,3,length(par)-2));
     'M':begin
          max_y:=I_S(copy(par,3,length(par)-2));
          osy_auto:=false;
         end;
     'L':begin;
          low_y:=I_S(copy(par,3,length(par)-2));
          osy_auto:=false;
         end;

    end
   else
    begin
     case jp of
      1: soub := par;
      2: begin xp:=true; xpopis:=par; end;
      3: begin yp:=true; ypopis:=par; end;
      4: begin np:=true; nadpisgrafu:=par; end;
      5: begin nadpisgrafu:=nadpisgrafu+' '+par; end;
     end;
     inc(jp);
    end;
  end;
 if (Pos_X=0) or (Pos_Y=0) then help;
 tecka:=pos('.',soub);
 nadpis:=copy(soub,1,tecka-1);
 clrscr;
 writeln;
 nacti;
(* coeff;*)

 grafika;

 stepcoef:= 0.35;

 assign(f,soub);

 repeat
   reset(f);
   setcolor(7);
   osy;
   kcode:=rdkey;

   range:= maxy - miny;

   {changing offset and range by arrow keys}
   if (kcode=-77) then begin
     range:= range*(stepcoef + 1);
     miny:= (maxy + miny)/2 - range/2;
     maxy:= (maxy + miny)/2 + range/2;
   end;
   if (kcode=-75) then begin
     range:= range/(stepcoef + 1);
     miny:= (maxy + miny)/2 - range/2;
     maxy:= (maxy + miny)/2 + range/2;
   end;
   if (kcode=-72) then begin
     offset:= (range/7)*stepcoef;
     miny:= miny + offset;
     maxy:= maxy + offset;
   end;
   if (kcode=-80) then begin
     offset:= (range/7)*stepcoef;
     miny:= miny - offset;
     maxy:= maxy - offset;
   end;

   {changing step by PgUp and PgDown}
   if kcode=-73 then stepcoef:= stepcoef*1.5;
   if kcode=-81 then stepcoef:= stepcoef/1.5;

   {drawing or removing grid lines by G key}
   if (kcode=71) or (kcode=103) then begin
     if (gridlength=maxgx+10) then gridlength:=55
     else gridlength:=maxgx+10;
   end;

   close(f);
 until (kcode=27) or (kcode=13); {wait for Esc or Enter}

 if (kcode=112) or (kcode=80) then  {p or P}
  begin
   cleardevice;
   setcolor(white);
   tisk:=true;
   nacti;osy;
   PriGScr('',0,Printer_mode)
  end;
  (*
  if (ch='r') then
   begin
    gotoxy(1,20);readln(poldegree);
    regrese(poldegree);
   end;
    *)
closegraph;
clrscr;
writeln('Overview of data:');
writeln('-------------------------------------------------');
writeln('Minimum value of Y:',miny:6:5,' for x=',miny_x:6:5);
writeln('Maximum value of Y:',maxy:6:5,' for x=',maxy_x:6:5);
writeln('Minimum value of X:',minx:6:5,' for y=',minx_y:6:5);
writeln('Maximum value of X:',maxx:6:5,' for y=',maxx_y:6:5);
writeln('Mean value of    X:',mean_x:6:5);dif_x:=maxx-minx;
writeln('Mean value of    Y:',mean_y:6:5);dif_y:=maxy-miny;
writeln('Range of         Y:',dif_y:6:5);
writeln('Range of         X:',dif_x:6:5);
writeln('-------------------------------------------------');
end.