unit ftsread;
{written by Lukas Kral <krall@troja.fjfi.cvut.cz> in Jan 2001}

interface
uses MyUtils;

procedure readpar(var t:text; par:string; var value:string; var err:boolean);

procedure readstrpar(var t:text; par:string; var value:string; var err:boolean);


implementation

procedure readpar(var t:text; par:string; var value:string; var err:boolean);
{reads value of non-string parameter par from opened FITS file
 ver. 1.2}
var n:integer;
    a:char;
    posit,curpos:longint;
    firsttime:boolean;

begin
firsttime:=true;
posit:=0;
curpos:=0;
err:=false;
value:='';

close(t);
reset(t); {sets pointer at the first byte of the file}

for n:=1 to (8 - length(par)) do par:= par + ' ';

repeat
  FindStr(t,par,err,curpos);
  if err=true then exit;
  posit:=posit + curpos;
  if not firsttime then posit:=posit + length(par) - 1;
  firsttime:=false;
until ((posit-1) mod 80)=0;

for n:=1 to (10 - length(par)) do read(t,a);

for n:=1 to 20 do begin
  read(t,a);
  value:= value + a;
end;

remspace(value);

end;


procedure readstrpar(var t:text; par:string; var value:string; var err:boolean);
{reads value of string parameter par from opened FITS file
Should work for every string parameter except COMMENT, which have special format
ver. 1.2}

var n:integer;
    a:char;
    posit,curpos:longint;
    temp:string;
    firsttime:boolean;

begin
firsttime:=true;
err:=false;
value:='';
posit:=0;
curpos:=0;

close(t);
reset(t); {sets pointer at the first byte of the file}

for n:=1 to (8 - length(par)) do par:= par + ' ';

repeat
  FindStr(t,par,err,curpos);
  if err=true then exit;
  posit:=posit + curpos;
  if not firsttime then posit:=posit + length(par) - 1;
  firsttime:=false;
until ((posit-1) mod 80)=0;

for n:=1 to (10 - length(par)) do read(t,a);

for n:=1 to 59 do begin
  read(t,a);
  value:= value + a;
end;

n:=2;
temp:='';
while (value[n]<>#39) and (n<=length(value)) do begin  {leaves only the part between ' chars in temp}
  temp:= temp + value[n];
  inc(n);
end;

value:= temp;

end;

end.
