 {~ Printing (not in PCL), saving and restoring a graphic screen ~}

Unit G_Scree; {from his unit GraphScr written in 1992
     Jan Hollan, Obs. and Planetarium Brno, 1993-11, last changed 1994-11}
(*  Copyright (C) 1999 Jan Hollan;
  by "program" this unit is further meant.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*)

Interface
uses Dos, Crt, graph, printer, str_num;

Procedure PriGScrC;        {Prints a Graphic Screen to
                           the very special CS212-25 printer on Com1}
Procedure PriGScrE(FileName:PathStr;Num,mode:byte); {Prints a Graphic Screen
                     in an Epson 8-needle mode either to file
                     (default extension is .e9 or .e24, when none is given)
                     or to PRN when the FileName is an empty string;
                     mode=9 is for 9-needle printers (72 DpI),
                     mode=24  for 24-  -  "   -      (60 DpI).}

Procedure PriGScrF (FileName:PathStr;Num:byte); {Prints a Graphic Screen
                     in a special CS212-25 format to
                     a file named <FileName>
                     or           <FileName>.prn, if no extension was given.
                     If the file exists within
                     the current directory, or directory given by TEMP or
                     PATH, it writes  the output as a figure
                     number Num (or appends it as a last figure).
                     Otherwise it creates such a file in the directory
                     given by the environment variable TEMP.}

Procedure PriGScr(FileName:string;Num,mode:byte); {either of the above,
                       mode =1 asks for the CS212-25 printer}
{Procedure SaveHercScr (Name:pathstr;Num:byte);
Procedure ReadHercScr (Name:pathstr;Num:byte);
}
Procedure ReadE9Scr(Name,Neg:pathstr);
                   {Puts a 8-needle Epson-type hardcopy back on the screen 
                    - the procedure has a lot of ballast in in, as it was 
                    taken from a program which prints E8 files by a special
                    CS212-15 printer using a lot of options.}
           
Procedure StoreGenScr (ULX,ULY,LRX,LRY:word;var CountScr:byte);
                    {writing a rectangle from the screen to memory}
Procedure WriteGenScr  (ULX,ULY,LRX,LRY:word;Name:pathstr);
                   {writing a rectangle from the screen to file "Name",
                    whose last suffix character is the number Num}
Procedure ReadGenScr  (ULX,ULY:word;Name:pathstr);
                   {putting an image from a file to screen}

Implementation
var n : byte;
{    scr: array [1..32496] of byte absolute $B000:$0000;
 }   Fi: file;
    Col, i8, MX, MY_8_1, MaxCol, EmptyCol: word;
    p: array [1..3] of pointer;
    SiFig: array [1..3] of word;
    OutRow: array [1..727] of byte;
Const
  BitSeq : array [0..7] of byte = (1,2,4,8,16,32,64,128);
type ORow= array [1..3992] of byte;

var d,e,c,u:char;
    nam:string[36];
    vst : file ;
    j,Shift,gd,gm,Lcol:integer;
    i: word;
    {b,b1,g,k,}l,Spaces:byte;
    count:word;
    posun: char; Bposun: byte absolute posun;
    Cond,
     {could be switch for condensing,
     but here inferred from the head of graphic data}
    Negative {Switch for making Negative image} ,
    Open {is the input file succesfully opened?} ,
    Decomp
      {takes place when the vertical shift to the next line is the least one,
       hence the next line is to be decomposed together with the present line
       to succesive lines } ,
     Full {is the output graphic line full?},
     no_shift {no amount of shift given before LF}
     : boolean;
    (*MS:  string[36]; {1st,2nd,3rd row}
    MB:  array [0..36] of byte absolute MS;*)
    UpRow, LoRow, IBRow : ORow;
    ICRow: array [1..3992] of char absolute IBRow;


const
{    posuny: array [1..8] of char =(#36,#54,#72,#12,#30,#48,#24,#24);
    ParamAr: array[1..4] of string[4] = ('NEG','LEFT', 'LOW','?');
}         BS: array [1..8] of byte = (1,2,4,8,16,32,64,128);

Procedure PlaceInFile(Name: pathstr; FigSize:Longint; FigNum:byte);
 {Sets position in the file of figures at figure number FigNum, or
  at the end of the file}
var
    FullNameOfFile: pathstr;
    Size, Pos: longint;
begin
  FullNameOfFile:= FSearch(Name,';'+GetEnv('TEMP')+';'+GetEnv('PATH'));
  if FullNameOfFile ='' then
    begin
      FullNameOfFile:=GetEnv('TEMP');
      if FullNameOfFile<>'' then
       if FullNameOfFile[length(FullNameOfFile)]<>'\' then
        FullNameOfFile:=FullNameOfFile+'\';
      assign(Fi,FullNameOfFile+Name); rewrite(Fi,1);
    end
   else
    begin
      assign(Fi,FullNameOfFile); reset(Fi,1); Size:=FileSize(Fi);
      if FigNum>0 then Pos:=FigSize*(FigNum-1) else Pos:=0;
      if Pos < Size then seek(Fi,Pos) else seek(Fi,Size)
    end;
end;

{Procedure SaveHercScr(Name:pathstr;Num:byte);
begin
  PlaceInFile (Name,32496,Num);
  blockwrite(Fi,Scr,32496);
  close(Fi);
end;

Procedure ReadHercScr(Name:pathstr;Num:byte);
begin
  PlaceInFile (Name,32496,Num);
  If FilePos(Fi)>=FileSize(Fi) then
    outtext('Such a Screen Number is not available')
   else
    blockread(Fi,Scr,32496);
  close(Fi);
end;
}

Procedure StoreGenScr(ULX,ULY,LRX,LRY:word;var CountScr:byte);
var pY:word; b:byte;
begin
CountScr:=(((abs(LRX-ULX)+1)*(abs(LRY-ULY))+1) div 2 ) div (1024*64 - 6) + 1;
if CountScr=1 then
 begin
  SiFig[1]:= ImageSize(ULX,ULY,LRX,LRY);
  if SiFig[1]<MaxAvail then
   begin
    GetMem(p[1],SiFig[1]);
    GetImage(ULX,ULY,LRX,LRY,p[1]^)
   end
  else
    CountScr:=0;
 end
else
 begin
  pY:=(1+LRY-ULY) div  CountScr;
  for b:=1 to CountScr-1 do
   begin
    SiFig[b]:= ImageSize(ULX,ULY+pY*(b-1),LRX,ULY+pY*b-1);
    if SiFig[b]<MaxAvail then
     begin
      GetMem(p[b],SiFig[b]);
      GetImage(ULX,ULY+pY*(b-1),LRX,ULY+pY*b-1,p[b]^)
     end
    else
     begin
      CountScr:=b-1;
      exit
     end;
   end;
  inc(b);
  SiFig[b]:= ImageSize(ULX,ULY+pY*(b-1),LRX,LRY);
  if SiFig[b]<MaxAvail then
   begin
    GetMem(p[b],SiFig[b]);
    GetImage(ULX,ULY+pY*(b-1),LRX,LRY,p[b]^)
   end
  else
    CountScr:=b-1;
 end
end;

Procedure WriteGenScr(ULX,ULY,LRX,LRY:word;Name:pathstr);
var CScr:byte; b:byte;
begin
  StoreGenScr(ULX,ULY,LRX,LRY,CScr);
  assign(Fi,Name); rewrite(Fi,1);
  if CScr>0 then
  for b:= 1 to CScr do
   blockwrite (Fi,p[b]^,SiFig[b]);
  close(Fi);
end;

Procedure ReadGenScr(ULX,ULY:word;Name:pathstr);
var B: array [1..4] of byte; j:byte; li:longint;
begin
 assign(Fi,Name);
 reset(Fi,1);
 j:=1;
 repeat
  BlockRead(Fi,B,4);
  SiFig[j]:= (1+B[1]+B[2]*256);       {pixels per line}
  SiFig[j]:= SiFig[j] div 8;
  if (1+B[1]+B[2]*256) mod 8 >0 then Inc(SiFig[j]);
  SiFig[j]:=SiFig[j] * 4;             {bytes per line}
  SiFig[j]:= SiFig[j]*(1+B[3]+B[4]*256)+6;
  GetMem(p[1],SiFig[j]);
  Li:=FilePos(fi);
  Seek(Fi,FilePos(fi)-4);
  BlockRead (Fi,p[1]^,SiFig[j]);
  PutImage(ULX,ULY,p[1]^,NormalPut);
  FreeMem(p[1],SiFig[j]);
  inc(ULY,(1+B[3]+B[4]*256));
 until FilePos(Fi)>=FileSize(Fi);
end;

Procedure FillRow;
var B: byte; Empty: boolean;
begin
 Col:=6; MaxCol:=64000; EmptyCol:=0; Empty:=True;
 for j:= 0 to MX do
  begin
   B:= 0;
   for n:=0 to 7 do if GetPixel(j,i8+n)>0 then inc(B, BitSeq[n]);
   OutRow[Col]:= B;
   if B>0 then
    begin
     MaxCol:=j;
     Empty:=False
    end
   else if Empty then inc(EmptyCol);
   inc(Col);
  end;
 if MaxCol=64000 then MaxCol:=0
 else inc(MaxCol);
end;

Procedure FillRowE;
var B: byte;
begin
 Col:=6+MX;
 for j:= 0 to MX do
  begin
   B:= 0;
{   for n:=0 to 7 do if GetPixel(j,i8+n)>0 then inc(B, 128 shr n);}
   for n:=0 to 7 do if GetPixel(i8+n,j)>0 then inc(B, 128 shr n);
   OutRow[Col]:= B;
   dec(Col);
  end
end;

Procedure InitCS;
begin
 OutRow[1]:= 128; OutRow[2]:= 0; OutRow[3]:= 0;
 MX:=GetMaxX+1;                  {number of pixels horizontally}
 MY_8_1:=(GetMaxY+1) div 8 - 1;  {number of rows vertically -1 }
 OutRow[4]:= MX - (MX div 256)*256; OutRow[5]:= MX div 256; OutRow[MX+6]:=130;
 dec(MX);                        {horizontally -1, i.e. max TP X coordinate}
end;

Procedure InitE8(mode:byte);
begin
 OutRow[2]:= 42; 
 if mode = 9 then 
  OutRow[3]:= 5     {72 dpi plotter graphics}
 else
  OutRow[3]:= 0;    {60 dpi horizontally (suitable for 24 needle printers)}
 MX:=GetMaxY+1;      {number of pixels horizontally on the paper - 
                                       vertically on the screen}
 MY_8_1:=(GetMaxX+1) div 8 - 1;      {number of rows vertically -1 }
 OutRow[4]:= MX - (MX div 256)*256; OutRow[5]:= MX div 256; OutRow[MX+6]:=13;
 OutRow[MX+7]:=10;
 dec(MX);                            {horizontally -1, i.e. max TP X coordinate}
end;


Procedure PriGScrC;
var W : word;
begin
 InitCS;
 for i:=0 to MY_8_1 do   {i is the number of an 8-dots row}
  begin
   if KeyPressed then exit;
   i8:=i*8;
   FillRow;
   if MaxCol>0 then
    begin
     OutRow[1]:=128;
     OutRow[2]:= EmptyCol - (EmptyCol div 256)*256;
     OutRow[3]:= EmptyCol div 256;
     dec(MaxCol,EmptyCol);
     OutRow[4]:= MaxCol - (MaxCol div 256)*256;
     OutRow[5]:= MaxCol div 256;
     move(OutRow[6+EmptyCol],IBRow[1],MaxCol);
     move(IBRow[1],OutRow[6],MaxCol);
     OutRow[MaxCol+6]:=130;
     for W:=1 to MaxCol+6 do Write(lst,chr(OutRow[W]));
    end
   else Write(lst,chr(130));
  end;
end;

Procedure PriGScrF(FileName:Pathstr;Num:byte);
const
  FootLines: array [1..8] of byte = (130,130,130,130,130,130,130,130);
var fDir:DirStr; fNam:NameStr; fExt:ExtStr;
begin
 InitCS;
 Fsplit(FileName,fDir,fNam,fExt);
 if fExt='' then fExt:='.prn';
 PlaceInFile(fDir+fNam+fExt,(MX+7)*(GetMaxY+1)+8,Num);
 for i:=0 to MY_8_1 do   {i is the number of an 8-dots row}
  begin
   i8:=i*8;
   FillRow;
   Blockwrite(Fi,OutRow,MX+7);
  end;
 BlockWrite(Fi,Footlines,8);
 close(Fi);
end;

Procedure PriGScrE(FileName:PathStr;Num,mode:byte);
const
  FootLines: array [1..8] of byte = (13,10,13,10,13,10,13,12);
var fDir:DirStr; fNam:NameStr; fExt:ExtStr;
begin
 if FileName<>'' then
  begin
   Fsplit(FileName,fDir,fNam,fExt);
   if fExt='' then fExt:='.e'+SI(1,mode);
   PlaceInFile(fDir+fNam+fExt,(MX+8)*(GetMaxX+1)+11,Num)
  end
 else
  begin
{$I-}
   assign(Fi,'prn'); rewrite(Fi,1); {this approach will fail on chr(26)!!!}
   if IOResult <> 0 then exit
{$I+}
  end;
 OutRow[1]:=27; OutRow[2]:=65; 
 OutRow[3]:=8;      { line spacing 8"/72 (mode 9) or 8"/60 (mode 24) }
 BlockWrite(Fi,OutRow,3);
 InitE8(mode);
 for i:=0 to MY_8_1 do   {i is the number of an 8-dots row}
  begin
   i8:=i*8;
   FillRowE;
   Blockwrite(Fi,OutRow,MX+8);
  end;
 BlockWrite(Fi,Footlines,8);
 close(Fi);
end;

Procedure PriGScr(FileName:string;Num,mode:byte);
begin
 if (mode = 1) then
  if FileName='' then PriGScrC
  else PriGScrF(FileName,Num)
 else
  PriGScrE(FileName,Num,mode)
end;

Procedure ReadE9Scr(Name,Neg:pathstr);
{            adapted 1993-05-03
     from TiskCSE9 program (printing Epson files on Consul CS 211-25 printer)
             J. Hollan, Obs. and Planetarium, 616 00  Brno.

     Restoring a VGA screen from a file for 9-needle Epson printer
     in graphic mode
     (from a hardcopy of the standard VGA screen, hence even empty space
     is assumed to be coded as a graphic sequence).
}

Procedure Help;
begin
  writeln('Program for restoring a graphic screen in VGA 640x480 mode ');
  writeln('       from a file for 9-needle Epson printer');
  writeln('       F:T2.gE9 is a standard name of this file, ');
  writeln('       another name may be given as the first parameter.');
  writeln;
  writeln('Option is: Neg  - convert to Negative');
  writeln('and  ?  or  invalid second or further parameter - this Help text');
  writeln;
  writeln('94-02-04 by Jan Hollan, Observatory and Planetarium, 616 00 Brno');
  halt
end;

Procedure Reverse (var Row: ORow; downlim,uplim,start,coef,decr: byte);
begin
 for i:= 1 to count do
   for l:= downlim to uplim do
    Row[i]:=Row[i]+((IBRow[i] and BS[l]) div BS[l]) * BS[start-coef*(l-decr)];
end;

Procedure WriGr (var Row: ORow); {puts graphic data on the screen,
                    increments the number of column and empties an array}
begin
{  if not Cond then
 }   begin
     If Negative then
                for i:= count downto 1 do
                 for l:=1 to 8 do
                  putpixel(Lcol+l,480-i,15*
                     ( (BS[l] xor  (Row[i] and BS[l]) ) div Bs[l] ))
         else
                for i:= count downto 1 do
                 for l:=1 to 8 do
                  putpixel(Lcol+l,480-i,15*((Row[i] and BS[l]) div BS[l] ))
     end
(*   else   {if the output is to be compressed : }
     begin
      i:= count div 2 ; j:= i div 256; e:= chr(j); d:= chr(i - 256*j);
      write(lst,#128,chr(Lo(Spaces*12)),chr(Hi(Spaces*12)),d,e);
      If Negative then
                 for i:=1 to count do
                  if odd(i) then b1:=Row[i] else
                        write (lst,chr(not(Row[i] or b1)))
         else
                 for i:=1 to count do
                  if odd(i) then b1:=Row[i] else
                        write (lst,chr(Row[i] or b1));
      end
*)       ;
   FillChar(Row,3992,0); Full:= False; inc(Lcol,8); no_shift:=true;
end;

procedure send_all;
 begin
  if Full then
     if Decomp then   {decomposition into lower halves
                                       of graphic lines}
        begin
         Reverse(LoRow,1,4,10,2,0);
         Reverse(UpRow,5,8,10,2,4);
         WriGr(UpRow); {Write(lst,t);} WriGr(LoRow);
        end
      else
        begin
         Reverse(UpRow,1,8,9,1,0);
         WriGr(UpRow)
        end;
  Decomp:= False;
{  if Shift>0 then
     for l:= 1 to Shift do write(lst,t)
                    else write(lst,#13)
}end;

begin
  {initialisation }
  Negative:= False;
  FillChar(UpRow,3992,0); FillChar(LoRow,3992,0);
  Decomp:= False; Full:= False; no_shift:=true;
  Shift:=1;Lcol:=-1;

  nam:='f:t2.gE9';

  if length(Neg)>0 then Negative:= True;
  nam:=Name;
  {$I-}
  repeat
   assign(vst,nam);
   reset(vst,1);
   if IOResult <> 0 then
     begin
      writeln('The input file ',nam);
      writeln('   was not found, try to give the correct full name,');
      write('   or just pres Enter to abort the program:');
      readln(nam);
      if length(nam)=0 then Help;
      Open:= False
     end
    else Open:= True;
  until Open;

  {$I+}

 { detectgraph(gd,gm);
  if (gd<>9) or (gm<>2) then
        begin writeln('Standard VGA 640x480 mode not detected!'); exit end;
 }gd:=0;  {AN ATTEMPT FOR FPK}
  initgraph(gd,gm,GetEnv('BGI'));
  while not eof(vst) do
    begin
      if KeyPressed then exit;
      BlockRead(vst,u,1);
      case u of
       #13 : Spaces:= 0 ;
       #10 : if Full and no_shift then
                {LF without a preceding sequence saying the
                           amount of vert. shift}
               send_all;
       #32 : Spaces:= Spaces+1;
       #12 : {for l:= 1 to 6 do write(lst,t)};
                   {instead of FF, just 6 lines, esp. to avoid the final FF}
       #27 :
         begin {of Esc branch }
          blockread (vst,c,1);
          case c of
           #64 {@},#79 {O} : ;
           #74 {J}:  {vertical shift is ignored}
                     repeat blockread(vst,c,1) until c=#10;
           #51 {3}:     {Amount of vertical shift in 1"/216 for one LF}
            begin
             blockread(vst,posun,1);
             no_shift:=false;
             if odd(Bposun) then
                Shift:= (Bposun+1) div 12 - 1
              else
                Shift:= (Bposun + 12) div 24 ;
             if Bposun <> 1 then send_all
              else      {minishift, perhaps 144 DpI data to be decomposed
                         into the upper halves of the two graphic lines}
                  Begin
                    Decomp:= True;
                    If Full then
                     begin Reverse(LoRow,1,4,9,2,0); Reverse(UpRow,5,8,9,2,4)
                     end
                   end
            end;  {of branch #51}

           #65 {A}:     {Amount of vertical shift in 1"/72 for one LF}
            begin
             blockread (vst,posun,1);
             Shift:= (Bposun) div 8;
            end;

           #76{L},#89{Y},#90{Z},#42{*} :
           begin                             {start graphic data}
            if c=#42 then blockread(vst,c,1);
            if (c=#90) or (c=#3) then Cond:= true  else Cond:= false ;
             {the data will be twice condensed if Cond}
            blockread(vst,d,1); blockread(vst,e,1); count:=ord(d)+256*ord(e);
            BlockRead(vst,ICRow,count);
            Full:= True;
           end;   {of branch of graphic data, i.e. #42 etc.}
          end;  {of case after Esc}
        end; {of Esc branch}

      end; {of whole case}

    end; {of while not eof}
    close(vst);
end;


end.
