/*   
     KONVE     Convert utility ST-xx  -> FITS   


$Id: iofts.c,v 1.4 2001/06/27 16:52:10 hroch Exp $

*/

/********  (I)/O procedures for writting FITS files **************/

#include "konve.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>

#define LEN 80
#define MAXKEY 37
#define MAXDEFNAM 80

static signed char FTSbuf[FITSSIZE];
static int nbuf;
static int cit;
static int paropen;

FILE *FITScreate( name, mode, stbuf, parname, tcor)
  long tcor; /* correction of time */
  char name[],mode[],stbuf[],parname[];
{
FILE *fs,*fp;
time_t tsec;
struct tm *actim;
int i,j,n,ppos,getpar();
long int li;
double f;
char buf1[LEN+1],buf[LEN+1];
char datestr[13],timestr[11];
int endpos(),pos(),copy(),ftswrite(),timdat(),strup();

static char stkey[MAXKEY] [20] = {
  " ",                              /* 0 */
  " ",
  " ",
  "Width =",
  "Height =",
  " ",                              /* 5 */
  " ",
  "Date =",
  "Time =",
  " ",
  " ",                              /* 10 */
  " ",
  " ",
  " ",
  " ",
  "Exposure =",                     /* 15 */
  "Number_exposures =",
  "Each_exposure =",
  "X_pixel_size =",
  "Y_pixel_size =",
  "Readout_mode =",                  /* 20 */
  "Exposure_state =",
  "Temperature =", 
  "Response_factor =",
  "E_gain =",
  "Focal_length =",                   /* 25 */
  "Aperture =",
  "Filter =",
  "Background =",
  "Range =", 
  "History =",                      /* 30 */
  "Pedestal =",
  "Track_time =",
  "Sat_level =",
  "Note =",                          
  "",                               /* 35 */
  ""  };        

	  
static char ftskey[MAXKEY][10] = {
  "SIMPLE  =",  /* 0 */
  "BITPIX  =",
  "NAXIS   =",
  "NAXIS1  =",
  "NAXIS2  =",
  "OBJECT  =",  /* 5 */
  "DATE    =",
  "DATE-OBS=",
  "UT      =",
  "ORIGIN  =",
  "INSTRUME=",  /* 10 */
  "TELESCOP=",
  "OBSERVER=",
  "BZERO   =",
  "BSCALE  =",
  "EXPTIME =",  /* 15 */
  "SNAPSHOT=",
  "EACHSNAP=",
  "PIXWIDTH=",
  "PIXHEIGH=",
  "RESMODE =",  /* 20 */
  "EXPSTATE=", 
  "TEMPERAT=",
  "RESPONSE=", 
  "EPERADU =",
  "FOCALLEN=",  /* 25 */
  "APERTURE=",
  "FILTER  =",
  "BACKGRND=",
  "RANGE   =",
  "HISTORY",    /* 30 */
  "PEDESTAL=",
  "TRAKTIME=",
  "SATURATE=",
  "COMMENT",   
  "COMMENT",    /* 35 */
  "END" }; 

 /* 'S'   string */
 /* 'I'   integer */
 /* 'F'   real */
 /* 'L'   logical */
 /* ' '   implicit value */
 /* 'X'   hexadecimal */
 /* 'C'   format for HISTORY and COMMENT */

static char form[MAXKEY] = {
  ' ',  /* 0 */
  ' ',
  ' ',
  'I',
  'I',
  'Q',  /* 5 */
  ' ',
  ' ',
  ' ',
  ' ',
  ' ',  /* 10 */
  'Q',
  'Q',
  ' ',
  ' ',
  'F',  /* 15 */
  'I',
  'F',
  'F',
  'F',
  'I',  /* 20 */
  'X', 
  'F',
  'F', 
  'F',
  'F',  /* 25 */
  'F',
  'S',
  'I',
  'I',
  'C',    /* 30 */
  'I',
  'F',
  'I',
  'C',   
  ' ',    /* 35 */
  ' ' }; 

static char defnam[MAXKEY][MAXDEFNAM] = {
  "                   T",    /* 0 */
  "                  16",
  "                   2",
  "",
  "",
  " ",                        /* 5 */
  "",
  "",
  "",
  "'KONVE   '",
  "'SBIG ST-xx'",             /* 10 */     /* obsolete */
  " ",
  " ",
  "     3.2768000000E04",
  "     1.0000000000E00",
  "",                         /* 15 */
  "",
  "",
  "",
  "",
  "",                         /* 20 */
  "",
  "",
  "",
  "",
  "",                          /* 25 */ 
  "",
  "",
  "",
  "",
  "",                          /* 30 */
  "",
  "",
  "",
  "",
  "File created by the KONVE software from Masaryk University in Brno",
  "" };


static char coment[MAXKEY][80] = {
  " ",    /* 0 */
  " ",
  " ",
  " ",
  " ",
  " ",    /* 5 */
  " ",
  "/ UT DATE OF START (ASSUMES PC CLOCK=UT)",
  "/ UT TIME OF START (ASSUMES PC CLOCK=UT)",
  " ",
  " ",    /* 10 */
  " ",
  " ",
  " ",
  " ",
  "/ EXPOSURE IN SECONDS",    /* 15 */
  "/ NUMBER OF SNAPSHOT",
  "/ SNAPSHOT IN SECONDS",
  "/ PIXEL WIDTH IN MM",
  "/ PIXEL HEIGHT IN MM",
  "/ RESOLUTION MODE",    /* 20 */
  "/ EXPOSURE STATE (HEX)",
  "/ TEMPERATURE IN DEGREES C",
  "/ CCD RESPONSE FACTOR",    
  "/ ELECTRONS PER ADU",
  "/ FOCAL LENGHT IN INCHES",    /* 25 */
  "/ APERTURE AREA IN SQ-INCHES",
  "/ OPTICAL FILTER NAME",
  "/ BACKGROUND FOR DISPLAY",    
  "/ RANGE FOR DISPLAY",
  "                    / IMAGE MODIFICATIONS",    /* 30 */
  "/ PEDESTAL OFFSET",
  "/ TRACK PERIOD IN SECONDS",
  "/ SATURATION LEVEL",    
  " ",
  "",    /* 35 */
  " " };

/* initialization */
nbuf = 0;
cit = 0;
paropen = 0;
for( i = 0; i < FITSSIZE; i++ )
  FTSbuf[i] = ' ';

/* instrument identification */
sscanf(stbuf,"%s",buf1);
sprintf(defnam[10],"'%s'",buf1);

/* create file */
if( (fs = fopen(name,mode)) == NULL )
  return(NULL);
/*fs = stdout;*/

/* working with date&time */
if( timdat(stbuf,tcor,datestr,timestr) != 1 )
  return(NULL);
strncpy(defnam[7],datestr,MAXDEFNAM);
strncpy(defnam[8],timestr,MAXDEFNAM);

/* write actual date to created FITS image */
tsec = time(&tsec);
actim = localtime(&tsec);
/*if( actim->tm_year < 100 )
  sprintf(defnam[6],"'%02d/%02d/%02d'",actim->tm_mday,actim->tm_mon+1,actim->tm_year);
  else*/
  sprintf(defnam[6],"'%04d-%02d-%02d'",actim->tm_year+1900,actim->tm_mon+1,actim->tm_mday);


/* copy & build header of FITS file, values from ST-xx file */
for( n = 0; n < MAXKEY-1; n++ ) {
  if( form[n] == 'S' ) {    /* any string */
    if( (j = endpos(stbuf,stkey[n])) != -1 ) {
      sscanf(stbuf+j,"%s",buf1);
      sprintf(buf,"'%-8s'",buf1);
      ftswrite(fs,FTSbuf,ftskey[n],"%-9s %-20s %s",buf,coment[n]);
    }
  }
  else if( form[n] == 'I' ){   /* integer */
    if( (j = endpos(stbuf,stkey[n])) != -1 ) {
      li = atol(stbuf+j);
      sprintf(buf1,"%20ld",li);
      ftswrite(fs,FTSbuf,ftskey[n],"%-9s %20s %s",buf1,coment[n]);
    }
    else {
      if( n == 3 || n == 4 ){   /* NROW & NCOL */
	printf("Fatal error: %s?.\n",stkey[n]);
	return(NULL);
      }
    }
  }
  else if( form[n] == 'F' ) {   /* real */
    if(  (j = endpos(stbuf,stkey[n])) != -1) {
      f = atof(stbuf+j);
      if( n == 15 || n == 17 )
	f = f/100.0;
      sprintf(buf1,"%20.10e",f);
      strup(buf1);
      ftswrite(fs,FTSbuf,ftskey[n],"%-9s %20s %s",buf1,coment[n]);
    }
  }
  else if( form[n] == ' ' )     /* implicit */
    ftswrite(fs,FTSbuf,ftskey[n],"%s %-20s %s",defnam[n],coment[n]);
  else if( form[n] == 'C' ) {   /* text */
    if( (j = endpos(stbuf,stkey[n])) != -1) {
      i = 0;
      while( 1 ) { 
	buf1[i] = stbuf[j+i];
	if( stbuf[j+i] == '\n' || stbuf[j+i] == '\r' ) { /* normal comment */
	  buf1[i] = '\0';
	  ftswrite(fs,FTSbuf,ftskey[n],"%s%s %s",buf1,coment[n]);
	  break;
	}
	if( i > 60 && buf[i] == ' ' || i == 70 ) { /* long comment */
	  buf1[i+1] = '\0';
	  ftswrite(fs,FTSbuf,ftskey[n],"%s%s %s",buf1,coment[n]);
	  j = j + i; 
	  i = 0; 
	}
	i++;  
      }
    }
  }
  else if( form[n] == 'X' ) {   /* hexadecimal */
    if( (j = endpos(stbuf,stkey[n])) != -1 ) {
      li = atol(stbuf+j);
      sprintf(buf1,"'%-8lx'",li);
      strup(buf1);
      ftswrite(fs,FTSbuf,ftskey[n],"%-9s %-20s %s",buf1,coment[n]);
    }
  }    
  else if( form[n] == 'Q' ) {  /* input from parameter file */
    i = getpar(parname,ftskey[n],buf1); 
    if( n == 6 && pos(buf1,"Unknown") >= 0 )
      sprintf(buf1,"%s",defnam[6]); 
    ftswrite(fs,FTSbuf,ftskey[n],"%-9s '%-8s' %s",buf1,coment[n]);
  }
}  

/* read optional FITS keywords from parameter file */
if( parname[0] != '\0' ) {
  if( (fp = fopen(parname,"r")) == NULL ) {
    if( paropen == 0 )
      printf("Can't open parameter file. \n");
    paropen = 1;
    return(NULL);
  }
  while( fgets(buf1,LEN,fp) != NULL ) {
    for( i = 0; buf1[i] != '\0'; i++)
      if( buf1[i] == '\n')
	 buf1[i] = ' ';
    j = 0;                /* length of line (without spaces) */
    for( i = 0; buf1[i] != '\0'; i++)
      if( buf1[i] != ' ' )
	j++; 
    if( j != 0 ) {    /* j == 0; => blank line */
      ppos = -1;
      for( i = 0; i<MAXKEY; i++ ) 
	if( (ppos = pos(buf1,ftskey[i])) != -1)
	  break;                       /* line identification before */
      if( ppos == -1 ) 
      ftswrite(fs,FTSbuf,buf1,"%-80s","","");
    }
  }
  fclose(fp);
}    

ftswrite(fs,FTSbuf,ftskey[MAXKEY-1],"%-80s","","");  /* END of header */

/* buffer to file, inicialization for data of image */
if( cit != 0 ) {
  if( fwrite(FTSbuf,1,FITSSIZE,fs) != FITSSIZE ) {
     printf("Can't write FITS header.\n");
     fclose(fs);
     return(NULL);
  }

  /* initialization */
  for( i = 0; i < FITSSIZE; i++ )
    FTSbuf[i] = ' ';
}

return(fs);

}

/************************************************************************/


int ftswrite( fs,FTSbuf, ftskey, format, value, coment )
FILE *fs;
char FTSbuf[],ftskey[],format[],value[],coment[];
{
int i,copy();
char buf1[LEN+1];

/* output format */
sprintf(buf1,format,ftskey,value,coment);
for( i = strlen(buf1); i<LEN+1; i++) 
  buf1[i] = ' ';
buf1[i] = '\0';

copy(buf1,LEN,FTSbuf+cit*LEN);
cit++;  

if( cit == 36 ) {
  if( fwrite(FTSbuf, 1, FITSSIZE, fs ) != FITSSIZE ) {
     printf("Can't write FITS file header.\n");
     fclose(fs);
     return(-1);
  }
  /* initialization */
  for( i = 0; i < FITSSIZE; i++ )
    FTSbuf[i] = ' ';
  cit = 0;
}
return(1);
}

/*************************************************************************/

int putFITSrow( fs, buf, n)
  FILE *fs;
  int n;
  signed char buf[];
{
int i,j;

for( i = 0; i < 2*n; i++) {
  FTSbuf[nbuf] = buf[i];    /* output to buffer */
  nbuf++;
  if( nbuf == FITSSIZE ){  /* buffer full */
    if( fwrite(FTSbuf,1,FITSSIZE,fs) != FITSSIZE )
      return(-1);
    nbuf = 0;
    for( j = 0; j < FITSSIZE; j++)
      FTSbuf[j] = 0;
  } 
} 

return(n);

}


/************************************************************************/

int FITSclose(fs)
FILE *fs;
{
 int i; 
 
 i = fwrite(FTSbuf,1,FITSSIZE,fs);
 fclose(fs);
 return(i);
}


/*************************************************************************/

/* format output date and time, time correction */

int timdat(stbuf,cor,datestr,timestr)  
char stbuf[];
long cor;
char datestr[], timestr[];
{
int i,endpos(),copy();
long tim;  /* time in seconds of the day */
int y,m,d;
int h,min,s,jdat();
double jd,yd,md,dd,datjd();

if( (i = endpos(stbuf,"Date =")) == -1 ) {
  printf("Warning: Date not found.\n");
  return(-1);
}
sscanf(stbuf+i,"%2d%*1s%2d%*1s%d",&m,&d,&y);
/* printf("%d %d %d \n",y,m,d); */

if( (i = endpos(stbuf,"Time =")) == -1 ) {
  printf("Warning: Time not found.\n");
  return(-1);
}
sscanf(stbuf+i,"%2d%*1s%2d%*1s%2d",&h,&min,&s);

/* find Y2KYear = string */
if( (i = endpos(stbuf,"Y2KYear =")) != -1 ) 
  sscanf(stbuf+i,"%4d",&y);

tim = s + 60L*(min + 60L*h) + cor;

/* end of 20's century and old data file format*/
if( 50 < y  && y <= 99 )
  yd = y + 1900.0;
else if( 0 <= y && y < 50 )
  yd = y + 2000.0;
else if( 1900 <= y && y < 1950 )
  yd = y + 100.0;
else if( 100 <= y  && y < 150 )
  yd = (y - 100.0) + 2000.0;
else
  yd = y;
/* I belive that ccdops, skypro and other shits won't live in 2050 */  

/* printf("%lf %d %d\n",yd,m,d); */

jd = datjd( yd,(double) m, (double) d);
jd = jd + tim/86400.0;  
jdat(jd,&yd,&md,&dd);

y = yd + 0.5;
m = md + 0.5;
d = dd;
tim = (dd - d)*86400.0 + 0.5;        /* "+ 0.5" for round */
h = tim / 3600L;
min = (tim - 3600L*h) / 60L;
s = tim - 60L*(min + 60L*h);

if( y < 2000.0 )
  sprintf(datestr,"'%02d/%02d/%02d'",d,m,y-1900);
else
  sprintf(datestr,"'%04d-%02d-%02d'",y,m,d);

sprintf(timestr,"'%02d:%02d:%02d'",h,min,s);

return(1);
}


/*************************************************************************/
/* read parameter file for optional FITS keywords */

int getpar(parname,ftskey,buf)
char parname[],ftskey[],buf[];
{
int i,j,ii,pos();
char buf1[LEN+1];
FILE *fp;

sprintf(buf,"Unknown");
if( parname[0] != '\0') {
  if( (fp = fopen(parname,"r")) == NULL ) {
    if( paropen == 0 )
      printf("Can't open parameter file. \n");
    paropen = 1;
    return(-1);
  }

  j = -1; 
  while( fgets(buf1,LEN,fp) != NULL) {
    for( i = 0; i < 9 && buf1[i] != '\0' && buf1[i] != '\n'; i++ )
      buf[i] = buf1[i]; 
    buf[i] = '\0';
    if( (j = pos(buf,ftskey)) == 0 )
      break;
  }

  if( j != -1 ) {
    for( i = 0,ii = 0; buf1[i] != '\0' && buf1[i] != '\n'; i++ )
      if( buf1[i] != '\'' && i > 9 ){
	buf[ii] = buf1[i]; 
	ii++;
      }
    buf[ii] = '\0';
    for( j = i-13; j > 0; j-- )
      if( buf[j] == ' ')
	buf[j] = '\0';
      else
	break;
  }
  else
    /*    sprintf(buf,"Unknown");*/
          sprintf(buf,"       ");
  fclose(fp);
}

return(j);
}

/**************************************************************************/

