/*   
       KONVE     Convert utility ST-xx  -> FITS   
*/

/************ transformation between the calendars ********************/

/* trajd.f -- translated by f2c (version 19950110).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

/*#include "f2c.h"*/
#define TRUE_   1
#define FALSE_  0

typedef double doublereal;
typedef int logical;

doublereal d_int(d)
doublereal d;
{
 long i;

 i = d;
 d = i;
 return(d);
}

/* CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC */
doublereal datjd(year, month, day)
doublereal year, month, day;
{
    /* System generated locals */
    doublereal ret_val, d__1, d__2;

    /* Builtin functions */
    double d_int();

    /* Local variables */
    static doublereal a, d, m, y;
    static logical before;
    static doublereal jd1;

/* Compute Julian date from input citizen year, month and day. */
/* Tested for YEAR>0 except 1582-10-07/15 */
    if (year > 1582.) {
	before = FALSE_;
    } else if (year < 1582.) {
	before = TRUE_;
    } else {
	if (month > 10.) {
	    before = FALSE_;
	} else if (month < 10.) {
	    before = TRUE_;
	} else {
	    if (day >= 15.) {
		before = FALSE_;
	    } else {
		before = TRUE_;
	    }
	}
    }
    if (month <= 2.) {
	y = year - 1.;
	m = month + 12.;
	d = day;
    } else {
	y = year;
	m = month;
	d = day;
    }
    d__1 = y * 365.25;
    d__2 = (m + 1.) * 30.6001;
    jd1 = d_int(d__1) + d_int(d__2) + d + 1720994.5;
    if (before) {
	ret_val = jd1;
	if (y < 0.) {
	    ret_val = jd1 - 1.;
	}
    } else {
	d__1 = y / 100.;
	a = d_int(d__1);
	d__1 = a / 4.;
	ret_val = jd1 + 2. - a + d_int(d__1);
    }
    return(ret_val);
} /* datjd_ */

/* CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC */
/* Subroutine */ int jdat(jd, year, month, day)
doublereal jd, *year, *month, *day;
{
    /* System generated locals */
    doublereal d__1;

    /* Builtin functions */
    double d_int();

    /* Local variables */
    static doublereal a, b, c, e, f, alpha, x, z, jd1;

/* Compute citizen date: year, month and day from input Julian date. */
/* Only for JD>0! Tested for YEAR>0 except 1582-10-07/15. */
    jd1 = jd + .5;
    z = d_int(jd1);
    f = jd1 - z;
    if (z >= 2299163.) {
	d__1 = (z - 1867216.25) / 36524.25;
	alpha = d_int(d__1);
	d__1 = alpha / 4.;
	a = z + 1. + alpha - d_int(d__1);
    } else {
	a = z;
    }
    b = a + 1524.;
    d__1 = (b - 122.1) / 365.25;
    c = d_int(d__1);
    d__1 = c * 365.25;
    x = d_int(d__1);
    d__1 = (b - x) / 30.6001;
    e = d_int(d__1);
    d__1 = e * 30.6001;
    *day = b - x - d_int(d__1) + f;
    if (e < 13.5) {
	*month = e - 1.;
    } else {
	*month = e - 13.;
    }
    if (*month > 2.5) {
	*year = c - 4716.;
    } else {
	*year = c - 4715.;
    }

return(0);
} /* jdat_ */


