@echo *********************
@echo Deleting old files...
@echo *********************
if exist fits\*.fts del fits\*.fts
if exist fits\*.coo del fits\*.coo
if exist fits\*.ap del fits\*.ap
if exist fits\*.srt del fits\*.srt
if exist fits\*.mat del fits\*.mat
if exist TEMP\*.dir del TEMP\*.dir
if exist TEMP\*.dat del TEMP\*.dat

REM Reseting number of old images to 0
bin\editpar bin\oldcount.bat oldcount 1

@echo ***************
@echo Listing data...
@echo ***************
dir /b /on /a-d %PATHD%\*.* >temp\dir.dir
bin\mklist temp\dir.dir %PATHD%
copy temp\dir.dir temp\old.dir

@echo **************************
@echo Converting ST-X to FITS...
@echo **************************
bin\konve -flip x @temp\LIST.DAT par=bin\par.dat mask=FITS\kou????.fts tcor=%1
if exist temp\dark.fts del temp\dark.fts
bin\konve -flip x %PATHDF% par=bin\par.dat mask=temp\dark.fts tcor=%1
if exist temp\flat.fts del temp\flat.fts
bin\konve -flip x %PATHFF% par=bin\par.dat mask=temp\flat.fts tcor=%1

dir /b /on /s fits\*.fts >temp\fits.dir
copy temp\fits.dir temp\oldf.dir

@echo ******************
@echo Dark correction...
@echo ******************
bin\darkbat @temp\fits.dir dark=temp\dark.fts mask=.

@echo ******************
@echo Flat correction...
@echo ******************
bin\flatbat @temp\fits.dir flat=temp\flat.fts mask=.

@echo *************
@echo Photometry...
@echo *************
copy bin\mp*.opt %MUNIDIR%
bin\muniphot @temp\fits.dir com=bin\com.dat
del %MUNIDIR%\mp*.opt

@echo ***********
@echo Matching...
@echo ***********
dir /b /on /s fits\*.srt > temp\srt.dir
copy temp\srt.dir temp\olds.dir

@if not exist fits\%REF% echo Error - selected reference file does not exist!
@if not exist fits\%REF% goto end
bin\wrref fits\%REF%
copy ref.dat fits\ref.dat
del ref.dat
bin\munimat.exe @temp\srt.dir ref=fits\ref.dat
dir /b /on /s fits\*.mat >temp\mat.dir
:end
