 {~ Polynomial regression (without weights) ~}

Unit regress; {Polynomial regression without weights}

  {as a simple unit tailored in 1993 by Jan Hollan 
   using the source programmes from the Numeric RECIPES Software
   package from Cambridge,
   and then rewritten to suit the GPL in 1999 }

Interface

const MaxNofCoef=6;

type
 coeffs_or_powers = array[1..MaxNofCoef] of real;
 matrix = array[1..MaxNofCoef,1..MaxNofCoef] of real;

var
 polynome_coeffs,x_powers: coeffs_or_powers;
 elements:matrix;
 degree_plus_1:byte;

Procedure RegInit(var m:byte); {Initialization; m is the degree of the polynome}
Procedure RegEnter(X, Y: real); {input of an [X,Y] pair}
Function  RegCompute:boolean;      {regression itself}
Function  RegValue(X:real; var YDvalue:real) : real; {function values }


Implementation

Function gauss_elim(a: matrix; n: integer; var b: coeffs_or_powers):boolean;

{ Gauss' elimination method of solution
  of a system of linear equations
  with a symmetric matrix
  using the search of a largest element}

var
 largest,aux_r: real;
 i,icol,irow,j,k: integer;
 columns:  Array[1..MaxNofCoef] of integer;
begin
 gauss_elim:=true;
 for i := 1 to n do columns[i]:= 0;
 for i := 1 to n do
  begin
   aux_r:= 0.0;
   for j := 1 to n do        {Find the largest element:}
    if (columns[j] <> 1) then
     begin
      for k := 1 to n do
       if (columns[k] = 0) then
        begin
          if (abs(a[j,k]) >= aux_r) then
           begin
            aux_r:= abs(a[j,k]);
            irow := j;
            icol := k
           end
        end
       else if (columns[k] > 1) then  {the column appeared second time}
        begin
         gauss_elim:=false; exit;
        end;
     end;
   inc(columns[icol]);
   if (irow <> icol) then
    begin
     for j := 1 to n do   {Change the rows, so that the largest element
                                comes to the diagonal:}
      begin
       aux_r := a[irow,j];
       a[irow,j] := a[icol,j];
       a[icol,j] := aux_r
      end;
     aux_r := b[irow];
     b[irow] := b[icol];
     b[icol] := aux_r
    end;
   if (a[icol,icol] = 0.0) then   {even the largest element is zero}
    begin
     gauss_elim:=false; exit;
    end;
   aux_r := 1.0/a[icol,icol];    {the normalizing factor}
             {normalizing the chosen line to 1 at diagonal:}
   a[icol,icol] := 1.0;  {to be exactly a[icol,icol]*aux_r}
   for j := 1 to n do a[icol,j] := a[icol,j]*aux_r;
   b[icol] := b[icol]*aux_r;
             {subtracting a multiple of a chosen line from the other ones,
              so that just zeroes remain in the chosen columnn:}
   for j := 1 to n do
    begin
     if (j <> icol) then
      begin
       aux_r := a[j,icol];
       a[j,icol] := 0.0;
       for k:= 1 to n do a[j,k] := a[j,k]-a[icol,k]*aux_r;
       b[j] := b[j]-b[icol]*aux_r;
      end
    end
  end;
end;

Procedure set_x_powers(X:real; var x_powers:coeffs_or_powers;
                       degree_pl_1:integer);
{x_powers: X**0=1,X**1=X,X**2,X**3,X**4,...}
var j:byte;
begin
 x_powers[1]:=1;
 for j:=2 to degree_pl_1 do x_powers[j]:=X*x_powers[j-1];
end;


Procedure RegInit(var m:byte);
var j,k:byte;
begin
 if m>MaxNofCoef-1 then m:=MaxNofCoef-1;
 degree_plus_1:=m+1;
 for j := 1 to degree_plus_1 do
  begin
   for k := 1 to degree_plus_1 do elements[j,k] := 0.0;
   polynome_coeffs[j] := 0.0;
  end;
end;


Procedure  RegEnter(X, Y: real);
var j,k:byte;
begin
 set_x_powers(x,x_powers,degree_plus_1);
 for j:= 1 to degree_plus_1 do
  begin
   for k := 1 to j do
    elements[j,k]:= elements[j,k]+x_powers[j]*x_powers[k];
    polynome_coeffs[j] := polynome_coeffs[j]+Y*x_powers[j];
  end;
end;

Function RegCompute:boolean;
var j,k:byte;
begin
 for j := 2 to degree_plus_1 do  {symmetrize matrix of coefficients:}
  for k := 1 to j-1 do
   elements[k,j] := elements[j,k];
 RegCompute:=gauss_elim(elements,degree_plus_1,polynome_coeffs);
end;

Function RegValue(X:real; var YDvalue:real) : real;
var j:byte; Yvalue:real;
begin
 set_x_powers(x,x_powers,degree_plus_1); Yvalue:=0.0; YDvalue:=0.0;
 for j:=1 to degree_plus_1 do
  Yvalue:=Yvalue+polynome_coeffs[j]*x_powers[j];
 for j:=2 to degree_plus_1 do
  YDvalue:=YDvalue+(j-1)*polynome_coeffs[j]*x_powers[j-1];
  {Yvalue is the value of the regression polynome, YDvalue is derivation}
 RegValue:= Yvalue
end;

end.