unit paramio;
{written by Lukas Kral <krall@troja.fjfi.cvut.cz> in Jan 2001}

interface

procedure paredit(infile,parname,newvalue:string; var error:boolean);

{Seeks for a string - parameter's name - (f.e."datapath") in a text file
and writes a new value of this parameter (f.e."c:\data"). If the parameter
is not found in the file, nothing is done.

After the name of the parameter in the text file must follow "=" and
then the value, all WITHOUT SPACES, and the rest of the line must
be empty!

F. ex. "datapath=c:/data"

When the new value is "d:\", then the result is "datapath=d:\"


Author: Lukas Kral <krall@troja.fjfi.cvut.cz>
Last change: Jan 2001
ver. 1.1
}

procedure parread(infile,parname:string; var value:string; var error:boolean);

{Searches for a paramater's value. The criteria are the same as in editpar
procedure above
ver. 1.1
}



implementation

uses MyUtils;


procedure paredit(infile,parname,newvalue:string; var error:boolean);

var t,temp:text;
    n,parpos:longint;
    err:boolean;
    ch:char;
    oldvalue:string;

begin
error:=false;

assign(t,infile);
{$I-}
reset(t);
{$I+}
if IOResult<>0 then begin
 error:=true;
 exit
end;

FindStr(t,(parname+'='),err,parpos);
close(t);

if err=true then begin
  error:=true;
  exit;
end;

assign(temp,'temp.txt');
rewrite(temp);
reset(t);

for n:=1 to (parpos-1+length(parname)) do begin {copying first part}
  read(t,ch);                                       {of the file}
  write(temp,ch);
end;

write(temp,'=');
writeln(temp,newvalue);   {writing new value}

read(t,ch);
readln(t,oldvalue);          {reading old value only for info}

while not eof(t) do begin    {copying the rest of the file}
  read(t,ch);
  write(temp,ch);
end;

close(t);
close(temp);

erase(t);
rename(temp,infile);

end;


procedure parread(infile,parname:string; var value:string; var error:boolean);

var t:text;
    n,parpos:longint;
    err:boolean;
    ch:char;

begin
error:=false;

assign(t,infile);
{$I-}
reset(t);
{$I+}
if IOResult<>0 then begin
 error:=true;
 exit
end;

FindStr(t,(parname+'='),err,parpos);
close(t);

if err=true then begin
  error:=true;
  exit;
end;

reset(t);

for n:=1 to (parpos-1+length(parname)) do begin {reading first part}
  read(t,ch);                                       {of the file}
end;

read(t,ch);
readln(t,value);          {reading the value}

close(t);

end;


end.