unit arrays;
{handling 1D dynamic arrays, ver. 1.0 by Lukas Kral}

interface

type elem = record
              pixel:word;
              next:pointer
            end;

     elempointer = ^elem;


procedure createArray(var head:elempointer);

procedure addElem(var nextel:elempointer; pixel:word; err:boolean);

procedure readElem(var curel:elempointer; var pixel:word);

procedure destroyArray(head:elempointer);



implementation

procedure createArray(var head:elempointer);
begin
new(head);
head^.next:= nil;
end;

procedure addElem(var nextel:elempointer; pixel:word; err:boolean);
var tp:elempointer;

begin
err:=false;
nextel^.pixel:= pixel;

if MemAvail<10 then begin
   err:=true;
   exit;
end;

new(tp);

nextel^.next:= tp;
nextel:= tp;
nextel^.next:= nil;
end;


procedure readElem(var curel:elempointer; var pixel:word);
begin
pixel:= curel^.pixel;
curel:= curel^.next;
end;

procedure destroyArray(head:elempointer);
var tp1,tp2:elempointer;

begin
tp1:= head;

while tp1<>nil do begin
  tp2:= tp1^.next;
  dispose(tp1);
  tp1:= tp2;
end;
end;


end.