 {~ String justification and conversion, date and time de- and en-coding ~}
 {~ (a substitute for parts of Unit_Str from Power Tools by Blaise Computing)~}

Unit Un_Str_M;
interface
uses dos, Str_Num;

{This unit - defining things beginning with underscore - is nothing more
 than a replacement of some of the facilities offered by a marvelous package
         Power Tools    by Blaise Computing, Inc.,
 explicitly by its Unit_Str part. To be able to release my programs to
 public domaine, I have written the needed facilities in the necessary
 extent independently, maintaining just the vital functions of the original
 Power Tools functions and procedures. Numeric values of predefined constants
 have nothing to do with the Power Tools values - no conflict arises, as long
 as the identificators are used and not numbers when calling the functions.}

const
_rem_lead_white_str=1;
_rem_trail_white_str=2;
_rem_white_str=3;
_to_upcase_str=4;
_to_lowcase_str=5;
_Euro_Dt_Str=2;
_ANSI_Dt_Str=1;
_inc_sec_str=2;
_right_just_str=1;

function __DateStr(var YYYY,MM,DD:word):string;
function __TimeStr(var HH,MI,SS,HS:word):string;
function __CvtStr(s:string;how:byte):string;
function __JustStr(s:string;fill:char;len,how:byte):string;
procedure __St2DtStr(Par:string; var yyyy_l:integer;var mm_l,dd_l:word;kind:byte);
procedure __St2RDtStr
 (Par:string; var yyyy_l:integer;var mm_l,dd_l:word;var dr:real;kind:byte);
{procedure __St2RDtStr
 (Par:string; var yyyy,mm,dd:word; var dr:real;kind:byte);}
{function __Dt2StStr(YYYY,mm,dd:word;kind:byte):string;  }
function __Dt2StStr(YYYY:integer;mm,dd:word;kind:byte):string;
function __2TimeStr(Par:string;var hh,mi,ss,hs:word):boolean;
function __Time2str(hh,mi,ss,hs:word;kind:byte):string;


implementation

function __DateStr(var YYYY,MM,DD:word):string;
 var DoW:word;
begin
 GetDate(YYYY,MM,DD,DoW);
 __DateStr:=SI(4,YYYY)+'-'+SI(2,MM)+'-'+SI(2,DD)
end;

function __TimeStr(var HH,MI,SS,HS:word):string;
begin
 GetTime(HH,MI,SS,HS);
 __TimeStr:=SI(2,HH)+':'+SI(2,MI)+':'+SI(2,SS)+'.'+SI(2,HS)
end;

function __CvtStr(s:string;how:byte):string;
 var j:byte;
begin
 case how of
 _rem_lead_white_str: begin j:=1; while s[j]=' ' do inc(j);
                            s:=copy(s,j,length(s)-j+1) end;
 _rem_trail_white_str: begin
                        j:=length(s); while s[j]=' ' do dec(j);
                            s:=copy(s,1,j) end;
 _rem_white_str: begin j:=1; while s[j]=' ' do inc(j);
                            s:=copy(s,j,length(s)-j+1);
                       j:=length(s); while s[j]=' ' do dec(j);
                            s:=copy(s,1,j) end;
 _to_upcase_str: for j:=1 to length(s) do s[j]:=UpCase(s[j]);
 _to_lowcase_str:for j:=1 to length(s) do if (ord(s[j])<91)
                                         and (ord(s[j])>64) then
                                          s[j]:=chr(ord(s[j])+32);
 end;
 __CvtStr:=s;
end;

function __JustStr(s:string;fill:char;len,how:byte):string;
 var i,j:byte;
begin
 if length(s)<len then
  begin
   i:=len-length(s);
   case how of
   _Right_Just_Str: for j:=1 to i do s:=fill+s;
   end
  end;
 __JustStr:=s
end;

procedure __St2RDtStr
 (Par:string; var yyyy_l:integer;var mm_l,dd_l:word;var dr:real;kind:byte);
var j1,j2,j3,j4:integer;M:word;Y,D:integer;
begin
dr:=1;
val(Par,Y,j1);
if j1>0 then
 begin
  val(copy(Par,1,j1-1),Y,j2);
  val(copy(Par,j1+1,length(Par)-j1),M,j2);
  if j2>0 then
   begin
    val(copy(Par,j1+1,j2-1),M,j3);
    val(copy(Par,j1+1+j2,length(Par)-j1-j2),D,j3);
    if j3>0 then
     val(copy(Par,j1+1+j2,length(Par)-j1-j2),DR,j4)
   end
 end;
case kind of
_Euro_Dt_Str:
 begin
  DD_l:=Y;
  dr:=dd_l;
  if j1>0 then
   begin
    MM_l:=M;
    if (j2>0) and (j3=0) then
     YYYY_l:=D
    else YYYY_l:=-32000
   end
 end;
_ANSI_Dt_Str:
 begin
  YYYY_l:=Y;
  MM_l:=1;
  DD_l:=1;
  if j1>0 then
   begin
    MM_l:=M;
    if (j2>0) then
     if (j3=0) then
      begin
       DD_l:=D;
       dr:=d
      end
     else
      DD_l:=round(DR)
   end
 end;
end;

if not (   ((kind=_Euro_Dt_Str) and (length(Par)-j1-j2>2))
        or ((kind=_ANSI_Dt_Str) and (    (j1>3)
                                      or (     (j1=0)
                                           and (length(Par)>2)
                                         )
                                     )
           )
        )      then   {no three digits with leading zero in Year:}
 if (YYYY_l<100) and (YYYY_l>0) then inc(YYYY_l,1900);
end;

procedure __St2DtStr(Par:string; var yyyy_l:integer;var mm_l,dd_l:word;kind:byte);
{procedure __St2DtStr(Par:string; var yyyy,mm,dd:word;kind:byte);}
var aux_r:real;
begin
 __St2RDtStr(Par,yyyy_l,mm_l,dd_l,aux_r,kind);
end;


function __Dt2StStr(YYYY:integer;mm,dd:word;kind:byte):string;
begin
if kind=_Euro_Dt_Str then
__Dt2StStr:=SI(2,DD)+'.'+SI(2,MM)+'.'+SI(4,YYYY)
else
__Dt2StStr:=SI(4,YYYY)+'-'+SI(2,MM)+'-'+SI(2,DD)
end;


function __2TimeStr(Par:string;var hh,mi,ss,hs:word):boolean;
var j1,j2,j3,j4:integer;
begin
mi:=0;ss:=0;hs:=0;__2TimeStr:=true;
val(Par,HH,j1);
if j1>1 then
 begin
  val(copy(Par,1,j1-1),HH,j2);
  val(copy(Par,j1+1,length(Par)-j1),Mi,j2);
   if j2>0 then
   begin
    val(copy(Par,j1+1,j2-1),Mi,j3);
    val(copy(Par,j1+j2+1,length(Par)-j1-j2),SS,j3);
    if j3>0 then
     begin
      val(copy(Par,j1+j2+1,j3-1),SS,j4);
      val(copy(Par,j1+j2+j3+1,length(Par)-j1-j2-j3),HS,j4)
     end
   end
 end;
if (j1=1) or (HH>24) or (Mi>59) or (SS>59) or (HS>99) then __2TimeStr:=false;
end;


function __Time2str(hh,mi,ss,hs:word;kind:byte):string;
begin
if kind=_Inc_Sec_Str then
__Time2Str:=SI(2,HH)+':'+SI(2,MI)+':'+SI(2,SS)
else
__Time2Str:=SI(2,HH)+':'+SI(2,Mi)
end;
end.