/*   
     KONVE     Convert utility ST-xx  -> FITS   
     Copyright (C) 1997  Filip Hroch, Masaryk University, Brno, CZ
     
     A certain part of this source originate from Pascal code
     by P. Pravec, M. Velen.
*/

/**********  I/(O) procedures for the SBIG image format files **********/
 
#include <stdio.h>
/*#include "konve.h"*/
#define STSIZE     3060     /* size of the ST-xx data bufer = 2*1530 */

FILE *STopen( name, mode )
  char name[];
  char mode[];
{

return( fopen(name,mode) );

}


int getSTrow( fp, buf, ftype, nrow )
  FILE *fp;
  int ftype,nrow;
  unsigned char buf[];
{
int i,xx,deltai;
unsigned int delka,hodnota,temp;
/*unsigned char buf1[STSIZE];*/
unsigned char buf1[2*nrow];

if( ftype == 0 ) {          /* uncompressed image */

  /* author madness */
  /*  if( sizeof(buf) < 2*nrow ) {
    printf("Wrong data format? sizeof(buf)=%d < 2*%d\n",sizeof(buf),nrow);
    return(0);
    }*/
  return( fread(buf,1,2*nrow,fp)/2 );
}
else {                     /* compressed image */

/* courtesy by P. Pravec */

/* length of line in bytes */
  if( (i = fread(buf1,1,2,fp)) != 2 )
    return(i);
  delka = buf1[0] + 256*buf1[1];

/* actual image data */
  if( delka > 2*nrow ) {
    printf("Wrong data format? delka=%d > STSIZE=%d\n",delka,STSIZE);
    return(0);
  }
  if( (i = fread(buf1,1,delka,fp))!= delka )
    return(-1);

  if( delka == 2*nrow ) { /* no compressed  line in compressed image */
    for( i = 0; i < 2*nrow; i++)
      buf[i] = buf1[i];
    return(i/2);
  }

  hodnota = buf1[0] + 256*buf1[1];
  for( i = 0; i < 2; i++) {
    buf[i] = buf1[i];
    /*    if( buf[i] < 0 ) buf[i] = 256+buf[i];*/
  }
  i = 2;
  xx = 2;
  do {
    deltai = buf1[i];
    i += 1;
    if( deltai > 127 ) 
      deltai -= 256;
    if( deltai == -128 ) {
      hodnota = buf1[i] + 256*buf1[i+1];
      i += 2; }
    else
      hodnota += deltai;
    temp = hodnota / 256;
    buf[xx] = hodnota - 256*temp;
    buf[xx+1] = temp;
    xx +=2;
  } while ( i < delka);

  return(xx-2);
}
}  
