(*   Author: Rudolf Novak
             Nicholas Copernicus Observatory & Planetarium in Brno
             Kravi hora 2
             616 00 Brno
             Czech Republic
     e-mail: codel@ian.cz



Rewritten by Lukas Kral, last update Mar. 2002

contact: krall@troja.fjfi.cvut.cz

It requires 5 parameters to run this program:

1. path to list of FITS files (text file)
2. path to resulting data file
3. path to MUNIPACK home directory
4. allow user to select the stars or load the numbers of previously used
   stars? Possible values: s...select, l...load
5. write instrumental (i) or differential (d) magnitudes as the output?

*)


Program Analyzing_Star_Field_From_Matching_Routines;

uses crt,dos,graph,mouse,str_num,ftsread,paramio,MyUtils,scrcopy;


type star = record
        n : integer;
        x : integer;
        y : integer;
        m : integer;
        mag : real;
        bad : boolean;
end;

type starph = record
        mag   : real;   {magnitude}
        sigma : real;   {std. deviation of mag}
        xc    : real;   {x coordinate}
        yc    : real;   {y coordinate}
        bad   : boolean;{indicates mag=99.999 - bad measurement}
end;


const starmax     =  2000  ; {maximum allowed star amount in mat file}
      starmax_str = '2000' ;
      maxchosen   =  200   ; {maximum allowed number of chosen stars}

var
    numstars,numchos,k,x_c,y_c,gd,gm,i,mx,my,io : integer;
    ok,again,back,auto,problem, difmags : boolean;
    hvezda : array [1..starmax] of star; {stars on reference image}
    chosen : array [1..maxchosen] of star; {stars chosen by mouse}
    chos_ph : array [1..maxchosen] of starph; {photom. data on chosen stars}
    variable,comp_1,comp_2,comp_3 : star;
    julDate : double;
    apen,ec,errc:integer;
    tmps:string;
    te:text;
    max, min: real;


(* Functions *)

function press(x,y,x1,y1,x2,y2:integer):boolean;
{Evaluates if x,y is in rectangle given by x1,y1 and x2,y2}

begin
  press:=(x>x1)and(y>y1)and(x<x2)and(y<y2);
end;

{-------------------------------------------------------}

function comp_rad(mag,max,min:real):integer;
{computes radius for star plotting}

begin
  comp_rad:= round(-6*((mag-max)/(min-max))+7);
end;

{-------------------------------------------------------}

function JD (y,M,D : double) : double; {Computes JD}
var a,B,jd1 : real;

begin
 if (M=1.0)or(M=2.0) then begin
   y:=y-1.0;
   M:=M+12.0;
 end;
 a:=int(0.01*y);
 B:=2-a+int(0.25*a);
 jd1:=int(365.25*y)+int(30.6001*(M+1.0))+D+1.7209945E6;
 if (y<=1582.0)and(M<=10.0)and(D<15) then
   JD:=a
 else
   JD:=jd1+B;
end; (* JD *)

{-------------------------------------------------------}

(*Procedures *)

Procedure Morse; {beeps}
begin;
 for i:=1 to 10 do
  begin
   sound(i*100);delay(3);nosound;
   sound((10-i)*100);delay(6);nosound;
  end;
end;

{-------------------------------------------------------}

{LK} {new procedures}
Procedure ErrEscape(problem:string);
{closes graphics and writes error message}
begin
  closegraph;
  writeln(problem);
  readkey;
  halt;
end;
{/LK}

{-------------------------------------------------------}

procedure gmessage(x,y:integer; message:string; bcolor:byte; var P:pointer);
{draws graphical message to screen, original background saved to P}

var w:integer;
    size:word;

const h = 18; {height of mess. window}

begin
w:= length(message)*8 + 10; {width of message window}

if x+w>getmaxx then w:= getmaxx-x; {cuts too large message}
if y+h>getmaxy then y:=getmaxy - h;

size := ImageSize(x,y,x+w,y+h);
GetMem(P, Size);   { Allocate memory on heap }
GetImage(x,y,x+w,y+h, P^);

setfillstyle(1,white);
bar(x,y,x+w,y+h);
setfillstyle(1,bcolor);
bar(x+1,y+1,x+w-1,y+h-1);
outtextxy(x+5,y+5,message);
end;

{-------------------------------------------------------}

procedure cross(x,y,hsize:integer);
{draws a cross to screen; hsize...half size of cross (~ radius)}
begin
line(x-hsize,y,x+hsize,y);
line(x,y-hsize,x,y+hsize);
end;

{-------------------------------------------------------}

procedure drawstar(x,y:integer; var rad:integer; red:boolean);
{draws a star to screen; rad... radius}

begin
if rad<1 then begin {do not plot any star}
  rad:= 0;
  exit;
end;

if rad>12 then rad:=12; {upper limit on star radius}

if not red then begin {normal star}
  if rad=1 then begin
    setcolor(darkgray);
    cross(x,y,1);
  end;
  if rad=2 then begin
    setcolor(lightgray);
    cross(x,y,1);
  end;
  if rad>2 then begin
    setcolor(darkgray);
    circle(x,y,rad);
    setfillstyle(1,darkgray);
    floodfill(x,y,darkgray);

    setcolor(lightgray);
    circle(x,y,rad-1);
    setfillstyle(1,lightgray);
    floodfill(x,y,lightgray);

    setcolor(white);
    circle(x,y,rad-2);
    setfillstyle(1,white);
    floodfill(x,y,white);
  end;
end
else begin            {star with mag 99.999 - bad}
    setcolor(4);
    cross(x,y,rad);
end;

if rad=1 then rad:=2; {rad=1 is too small area for mouse-click}

setcolor(white);

end;

{-------------------------------------------------------}


procedure drawback(x,y:integer; P:pointer);
{recalls original graphical background from P}

begin
PutImage(x,y,P^,NormalPut);
end;

{/LK}

{-------------------------------------------------------}

{LK} {new procedure}
procedure ReadAperture(var apen:integer); {reading APErture Number}
var clonka:text; {"clonka" means "aperture" in Czech :-) }
    apernum:string;
    err:boolean;
    errcode:integer;

begin
 parread((paramstr(3)+'\muniset.bat'),'APN',apernum,err);
 {reads reference file name}
 if err=true then ErrEscape('Cannot read aperture number from muniset.bat!');

 val(apernum,apen,errcode);

 if (errcode<>0) or (apen<1) or (apen>12) then begin
   closegraph;
   writeln('Error reading aperture number from muniset.bat! MUNIAL will be halted.');
   writeln;
   writeln('The number of the aperture to use in the photometry can be 1 - 12');
   writeln('See also "mphoto.opt" file for the apertures and their numbers.');
   writeln('Now press Enter to continue...');
   sound(1200);
   delay(150);
   sound(800);
   delay(200);
   nosound;
   readln;
   halt;
 end;

 apen:=apen+3; {first aperture value is located in the fourth column etc.}
end;

{/LK}

{-------------------------------------------------------}

{LK}
Procedure file_chyba(jmeno:string);
begin
 setfillstyle(1,white);
 bar((getmaxx div 2)-151, (getmaxy div 2)-11,(getmaxx div 2) +251,(getmaxy div 2) +11);
 setfillstyle(1,black);
 bar((getmaxx div 2)-150, (getmaxy div 2)-10,(getmaxx div 2) +250,(getmaxy div 2) +10);
 setfillstyle(1,red);
 bar((getmaxx div 2)-149, (getmaxy div 2)-9,(getmaxx div 2) +249,(getmaxy div 2) +9);
 outtextxy((getmaxx div 2)-140,getmaxy div 2 - 3,'CANNOT OPEN FILE '+jmeno+'!');
 repeat until keypressed;
 closegraph;
 halt;
end;
{/LK}

{-------------------------------------------------------}

Procedure Screen; (* Initialize graphics *)
var
   EC  : integer;
   pat : string;

begin
 DetectGraph(gd,gm);
 pat:=paramstr(3);
 initgraph(gd,gm,pat);
 EC := GraphResult;
 if EC <> GrOK Then
 begin
  clrscr;
  writeln('Error while init graphics...');
  write('Err. code: ');writeln(EC);
  writeln('Possible problems:');
  writeln('Code  Error Message String');
  writeln('  0  No error');
  writeln(' -1  BGI graphics not installed');
  writeln(' -2  Graphics hardware not detected');
  writeln(' -3  Device driver file not found  ');
  writeln(' -4  Invalid device driver file');
  writeln(' -5  Not enough memory to load driver');
  writeln(' -6  Out of memory in scan fill');
  writeln(' -7  Out of memory in flood fill');
  writeln(' -8  Font file not found');
  writeln(' -9  Not enough memory to load font');
  writeln('-10  Invalid graphics mode for selected driver');
  writeln('-11  Graphics error            (generic error)');
  writeln('-12  Graphics I/O error');
  writeln('-13  Invalid font file ');
  writeln('-14  Invalid font number');
  halt;
 end;
 cleardevice;
 setfillstyle(1,white);
 bar(1,1,getmaxx,getmaxy);
 setfillstyle(blue,blue);
 bar(2,2,getmaxx-1,getmaxy-1);
end; (* End of Procedure "Screen" *)

{-------------------------------------------------------}

Procedure Legend; {Draws the legend to screen}
begin
 line(1,getmaxy-40,getmaxx,getmaxy-40);
 setfillstyle(1,white);

 outtextxy(6,getmaxy-30,'File:');

 i:= 5;

 line((i+10)*i+20,getmaxy-40,(i+10)*i+20,getmaxy);
 if difmags then begin
   outtextxy((i+10)*i+30,getmaxy-35,'Use mouse to select stars, first must be');
   outtextxy((i+10)*i+30,getmaxy-25,'variable, then select 3 comparisons.');
 end
 else begin
   outtextxy((i+10)*i+30,getmaxy-35,'Use mouse to select stars.');
   outtextxy((i+10)*i+30,getmaxy-25,'Press Enter when finished.');
 end;

 outtextxy((i+10)*i+45,getmaxy-13,'means bad value of magnitude (99.999)');
 setcolor(red);
 cross((i+10)*i+35,getmaxy-10,1);

 setfillstyle(1,white);
 setcolor(white);

 line(getmaxx-210,getmaxy-40,getmaxx-210,getmaxy);

 outtextxy(getmaxx-200,getmaxy-35,'Row number of star in');
 outtextxy(getmaxx-200,getmaxy-25,'.mat file: ');

 line(getmaxx-50,getmaxy-20,getmaxx,getmaxy-20);line(getmaxx-50,getmaxy-20,getmaxx-50,getmaxy);
 setfillstyle(1,lightblue);
 floodfill(getmaxx-20,getmaxy-10,white);
 outtextxy(getmaxx-40,getmaxy-14,'Quit');
end; (* Of Legend *)

{-------------------------------------------------------}

Procedure Help;
begin
 writeln('This program needs to run only under MUNIDOS!');
 halt;
end;

{-------------------------------------------------------}
Procedure beep;
begin
 sound(1000);
 delay(100);
 nosound;
end; (* of Beep *)

{-------------------------------------------------------}
Procedure beep_err;
begin
 sound(1000);
 delay(100);
 nosound;
 sound(1000);
 delay(100);
 nosound;
 sound(1000);
 delay(100);
 nosound;
end; (* of beep_err *)

{-------------------------------------------------------}
Procedure mys; (* Mouse init *)
begin
 mouseinit;
end; (* of Mys *)

{-------------------------------------------------------}
{LK} {new procedure}
Procedure SaveStars; {Saves numbers of last chosen stars to file}
var err:boolean;
    sss:string;
    te:text;
    j:integer;

begin
assign(te,'bin\oldstars.dat');
{$I-}
rewrite(te);
{$I+}
if IOresult<>0 then crash('Error writing numbers of chosen stars to oldstars.dat!');

for j:=1 to numchos do writeln(te,chosen[j].n);

close(te);
end;
{/LK}

{-------------------------------------------------------}
{LK}
Procedure Read_Mat_File;
{Reading .mat file and plotting the star field}
var
       m1 : text;
       k_s,rec,vecko,srt_name,mat_name,empty,a_s,x_s,y_s : string;
       rad,s_x,s_y,a,radek,point : integer;
       aa,x,y,mag : real;
       err : boolean;

begin
 {reading muniset.bat for reference image's name}
 parread((paramstr(3)+'\muniset.bat'),'REF',srt_name,err);
 {reads reference file name}
 if err=true then ErrEscape('Cannot read reference file name from muniset.bat!');

 point:=pos('.',srt_name);
 mat_name:= copy(srt_name,1,point)+'mat'; {f.e. KOU0001.SRT -> KOU0001.MAT}
 outtextxy(6,getmaxy-18,mat_name);
 mat_name:= paramstr(3) + '\FITS\' + mat_name;

 assign(m1,mat_name);
 {$I-$}
 reset(m1);
 {$I+$}
 if ioresult<>0 then ErrEscape('Error - file '+mat_name+' not found!');

 radek:=1;
 for radek:=1 to 2 do readln(m1,empty); {skipping first two lines}
  min:=100;max:=-1;

repeat (* Find maximal and minimal value of brightness *)
 readln(m1,rec);
 radek:=radek+1;
 if itemcount(rec) <> 0 then
  begin
    a_s:=itemstr(1,rec);
    x_s:=itemstr(2,rec);y_s:=itemstr(3,rec);vecko:=itemstr(apen,rec);
    val(vecko,mag,io);
    if Io<>0 then
     begin
     end;
    if (mag < min) then if (vecko <> '99.999') then min:=mag;
    if (mag > max) and (vecko <>'99.999') then max:=mag;
    readln(m1,empty); readln(m1,empty);
    radek:=radek+2;
  end
until eof(m1);
close(m1);

(* Knowing magnitude scale - we can plot a field *)
 assign(m1,mat_name);
 {$I-}
 reset(m1);
 {$I+}
 if ioresult <> 0 then file_chyba(mat_name);

radek:=1;
readln(m1,empty);
readln(m1,a,x_c,y_c);
readln(m1,empty);

aa:=max; {changing max <-> min}
max:=min;min:=aa;

k:=1;
radek:=3;

setfillstyle(1,black);
bar(2,2,getmaxx-1,getmaxy-41);


 repeat (* Plot a field *)
    readln(m1,rec);radek:=radek+1;
  if itemcount(rec) <> 0 then
   begin
    a_s:=itemstr(1,rec);
    x_s:=itemstr(2,rec);y_s:=itemstr(3,rec);vecko:=itemstr(apen,rec);
    val(vecko,mag,io);val(x_s,x,io);val(y_s,y,io);
    s_x:=round((x/x_c)*getmaxx);s_y:=round((y/y_c)*(getmaxy-50));

    if mag<=min then begin
      rad:= comp_rad(mag,max,min); {computing star radius to draw}
      drawstar(s_x,s_y,rad,false);
      hvezda[k].bad:= false;
    end
    else begin  {case 99.999 mag - error flag}
      rad:= 1;
      drawstar(s_x,s_y,rad,true);
      hvezda[k].bad:= true;
    end;

    str(k,k_s);
    hvezda[k].m:=rad;hvezda[k].n:=radek;hvezda[k].x:=s_x;hvezda[k].y:=s_y;
    hvezda[k].mag:= mag;

    readln(m1,empty);readln(m1,empty);
    radek:=radek+2;
    inc(k);
    if k>starmax then ErrEscape('Error - too many stars in field! (max = '+starmax_str +')');
  end
  else
  begin
   hvezda[k].m:=0;hvezda[k].x:=0;hvezda[k].y:=0;hvezda[k].n:=0;
   readln(m1,empty);readln(m1,empty);radek:=radek+2;
  end;
 until eof(m1);
close(m1);
numstars:=k;
end; (* Of Read_Mat_File *)

{-------------------------------------------------------}

Procedure Chose_stars; {choosing stars by mouse}

var ch : char;
    j, x1,x2,y1,y2, key, rad : integer;
    rown, ind : string;
    finished,found,comp_b,ch1_b,ch2_b,var_b,fail,continue : boolean;
    desig : array[1..4] of string;
    P : pointer;
    DirInfo:SearchRec;
    oldmax,oldmin : real;

label skipout,afterreplot;

procedure drawmessage(message:string); {draws message to graphical window}
begin
 setfillstyle(1,white);
 bar(getmaxx-111,getmaxy-24,getmaxx-70,getmaxy-6);
 setfillstyle(1,black);
 bar(getmaxx-110,getmaxy-23,getmaxx-71,getmaxy-7);
 outtextxy(getmaxx-107,getmaxy-18,message);
end;

Procedure mistake;
begin
closegraph;
writeln('You have chosen the same star twice. Run program again and be careful...');
writeln;
writeln('Press ENTER to continue...');
readln;
halt;
end;

{.................}

begin
 var_b:=false;comp_b:=false;ch1_b:=false;ch2_b:=false;
 found:=false; {indicates if the clicked star was found in the hvezda array}
 desig[1]:='Var.'; desig[2]:='Comp.'; desig[3]:='Check 1'; desig[4]:='Check 2';

 j:= 1;
 finished:= false;
 numchos:= 0;

 drawmessage(' ');

 repeat {choosing stars by mouse}

  found:= false;

  repeat {identifying the clicked star}
   afterreplot:
   ok:=mousepress(mx,my);


   if keypressed then key:=rdkey else key:= 0;
   if (key=27) or (key=13) then begin {Esc or Enter was pressed}
     if (key=27) and (j=1) then begin {end before choosing any star}
       closegraph;
       writeln('You interrupted the program before choosing the stars.');
       halt;
     end;

     {end of choosing stars to get instr. mags by pressing Enter}
     if (key=13) and (not difmags) and (j>1) then begin
       finished:= true;
       goto skipout;
     end;

   end;

   if ((key=-75) or (key=-77) or (key=-72) or (key=-80)) and (numchos=0)
   then begin
   {an arrow was pressed => replotting}
     oldmin:= min; oldmax:= max;
     case key of
       -72: max:= max + 0.5;
       -80: max:= max - 0.5;
       -75: min:= min - 0.5;
       -77: min:= min + 0.5;
     end;

     if max>=min then begin {restoring old values, nothing replots}
       max:= oldmax;
       min:= oldmin;
       goto afterreplot;
     end;

     {replotting the star field}
     mouseoff;
     setcolor(white);
     line(1,1,1,getmaxy-40);
     line(getmaxx,1,getmaxx,getmaxy-40);
     line(1,1,getmaxx,1);
     line(1,getmaxy-40,getmaxx,getmaxy-40);
     setfillstyle(1,black);
     bar(2,2,getmaxx-1,getmaxy-41);

     for k:=1 to numstars-1 do begin
       if not hvezda[k].bad then begin
         rad:= comp_rad(hvezda[k].mag,max,min); {computing star radius to draw}
         drawstar(hvezda[k].x,hvezda[k].y,rad,false);
         hvezda[k].m:= rad;
       end
       else begin  {case 99.999 mag - error flag}
         rad:= 1;
         drawstar(hvezda[k].x,hvezda[k].y,rad,true);
         hvezda[k].m:= rad;
       end;
     end;

     mouseon;
     goto afterreplot;

   end;


   if ok and press(mx,my,getmaxx-50,getmaxy-20,getmaxx,getmaxy) then
   {if Quit is clicked :}
    begin
     closegraph;
     writeln('You interrupted the program before it finished its task!');
     halt;
    end;

   if ok then begin
    for i:=1 to numstars do begin
      if (not found) then begin
        {testing if the i-th star was clicked}
        if ((mx > (hvezda[i].x-hvezda[i].m)) and  (mx < (hvezda[i].x+hvezda[i].m)))
           and
           ((my > (hvezda[i].y-hvezda[i].m)) and (my < (hvezda[i].y+hvezda[i].m)))
        then begin
           mouseoff;
           found:= true;
           chosen[j]:= hvezda[i];

           str(hvezda[i].n,rown);
           str(j,ind);
           if difmags then ind:= desig[j];
           drawmessage(rown);

           inc(numchos);

           {drawing the selected star with yellow}
           setcolor(yellow);
           circle(hvezda[i].x,hvezda[i].y,hvezda[i].m);
           outtextxy(hvezda[i].x+hvezda[i].m+1,hvezda[i].y+hvezda[i].m+1,ind);
           setfillstyle(1,yellow);
           floodfill(hvezda[i].x,hvezda[i].y,yellow);
           setcolor(white);

           mouseon;
        end;
      end;
    end;
   end;

  until found;
  skipout:

  {was any star clicked twice?}
  for i:=1 to j-1 do begin
    if chosen[j].n = chosen[i].n then mistake;
  end;

  if difmags and (j>=4) then finished:= true;

  inc(j);
 until finished=true;

 mouseoff;

 gmessage(100, getmaxy div 2 - 9,'Save copy of screen to RESULTS\STARS.BMP? (Enter/Esc)',brown,P);
 ch:=readkey;

 drawback(100, getmaxy div 2 - 9,P);

 if ch=#13 then begin
   continue:= true;
   FindFirst(paramstr(3)+'\results\stars.bmp',AnyFile,DirInfo);
   if DosError=0 then begin {existing BMP file found}
     gmessage(100,getmaxy div 2 - 9,'Rewrite existing file RESULTS/STARS.BMP? (Enter/Esc)',red,P);
     repeat
       ch:= readkey;
     until (ch=#13) or (ch=#27);
     drawback(100,getmaxy div 2 - 9,P);
     if ch=#27 then continue:= false;
   end;

   if continue then begin {save BMP}
     gmessage(100, getmaxy-35,'Saving bitmap...',darkgray,P);
     saveBMP(0,0,getmaxx-1,getmaxy-41,paramstr(3)+'\results\stars.bmp',fail);
     drawback(100, getmaxy-35,P);
     if fail then begin
       gmessage(100, getmaxy div 2 - 9,'Error - cannot save copy of screen to BMP file!',red,P);
       readkey;
       drawback(100, getmaxy div 2 - 9,P);
     end;
   end;
 end;

 gmessage(100, getmaxy div 2 - 9,'Reading data from MAT files...',darkgray,P);


end; (* Of Chose_Stars *)


{LK} {following procedure completely rewritten, my unit ftsread used}

Procedure Load_Fts(infile:string);

var
     ho_s,mi_s,se_s,mo_s,ye_s,day_s,date,time,exposure : string;
     single_fts : text;
     expo,ho,mi,se,day,mo,ye : real;
     err:boolean;
     errcode,reserror:integer;

begin
 {$I-}
 assign(single_fts,infile);
 reset(single_fts);
 if ioresult <> 0 then file_chyba(infile);
 {$I+}

 readstrpar(single_fts,'DATE-OBS',date,err);
 close(single_fts);
 if err=true then ErrEscape('DATE-OBS parameter not found in '+infile+'!');

 reset(single_fts);
 readstrpar(single_fts,'UT',time,err);
 if err=true then begin
   close(single_fts);
   reset(single_fts);
   readstrpar(single_fts,'TIME-OBS',time,err);
 end;
 if err=true then begin
   close(single_fts);
   reset(single_fts);
   readstrpar(single_fts,'UT-START',time,err);
 end;

 close(single_fts);
 if err=true then begin
   {new format YYYY-MM-DDThh:mm:ss}
   if (length(date)=19) and (date[11]='T') then time:= copy(date,12,8)
   else ErrEscape('Cannot read observation time from file '+infile+'!');
 end;

 reset(single_fts);
 readpar(single_fts,'EXPTIME',exposure,err);
 close(single_fts);
 if err=true then ErrEscape('EXPTIME parameter not found in '+infile+'!');

 val(exposure,expo,errcode);
 if errcode<>0 then ErrEscape('Error - cannot read EXPTIME from file ' + infile + ' !');

 reserror:=0;
 val(copy(time,1,2),ho,errcode);
 reserror:=reserror + errcode;
 val(copy(time,4,2),mi,errcode);
 reserror:=reserror + errcode;
 val(copy(time,7,2),se,errcode);
 reserror:=reserror + errcode;

 if reserror<>0 then ErrEscape('Error - cannot read DATE from file ' + infile + ' !');

 reserror:=0;

 if date[5]='-' then begin
 {case of date in new YYYY-MM-DD format}
   val(copy(date,1,4),ye,errcode);
   reserror:=reserror + errcode;
   val(copy(date,6,2),mo,errcode);
   reserror:=reserror + errcode;
   val(copy(date,9,2),day,errcode);
   reserror:=reserror + errcode;
 end
 else begin
 {case of date in old format dd/mm/yy}
   val(copy(date,1,2),day,errcode);
   reserror:=reserror + errcode;
   val(copy(date,4,2),mo,errcode);
   reserror:=reserror + errcode;
   val(copy(date,7,2),ye,errcode);
   reserror:=reserror + errcode;

   (* y2k problem solution :) *)
   if ye > 80 Then
    ye:=ye+1900
   else
   ye:=ye+2000;
 end;

 if reserror<>0 then ErrEscape('Error - cannot read UT from file ' + infile + ' !');

 {mid-exposure time calculation}
 se:=se+expo/2;
 mi:=(mi+se/60)/60;
 ho:=(ho+mi)/24;
 day:=day+ho; {day is a real number here!}

 JulDate:=JD(ye,mo,day);

end; (* Of Load_Fts *)


{------------------------------------------------------------------}

Procedure Analyzing_all_files;
var
  f,m1,g,h,coord                                                  : text;
  mag_ds,mag_cs3,mag_cs2,mag_cs,mag_s,mag_sn,rec,rec1,rec2,
  rec3,rec4,rec5,mat_name,first_name                              : string;
  point, j                                                        : integer;
  mag_dv,mag_dc,mag_dc1,mag_dc2,mc1,mc2,mc3,mc4,mc5,mc,mag_c,
  mag_c2,mag_c3,mag,dvc,dvc1,dvc2,dcc1,dcc2,dcc3,dc1c2,xc,yc      : real;
  error                                                           : boolean;
begin

 assign(f,paramstr(1));
 {$I-}
 reset(f);
 {$I+}
 if ioresult <> 0 then file_chyba(paramstr(1));

 assign(g,paramstr(2));
 {$I-}
 rewrite(g);
 {$I+}
 if ioresult <> 0 then file_chyba(paramstr(2));

 if difmags then begin
   writeln(g,'JD V-C s1 V-C1 s2 V-C2 s3 C-C1 s4 C-C2 s5 C1-C2 s6');
   writeln(g,'Used aperture #',apen-3);
 end
 else begin
   writeln(g,'# JD, instrumental mags and standard deviations of ',numchos,' selected stars');
   writeln(g,'# Used aperture #',apen-3);
 end;

 mag_s:='';
 mag_cs:='';

 {write diff. magnitudes (older part of program, not very transparent)}
 if (difmags=true) then begin

  assign(coord, paramstr(3)+'\results\coordin.dat'); {file with coordinates}
  {$I-}
  rewrite(coord);
  {$I+}
  if ioresult <> 0 then file_chyba(paramstr(3)+'\results\coordin.dat');

  writeln(coord,'# JD and X,Y coordinates of V, C, C1 and C2 stars selected during photometry');
  writeln(coord,'# (in pixels; -1.000 means that star was not found)');


  variable:= chosen[1];
  comp_1:= chosen[2];
  comp_2:= chosen[3];
  comp_3:= chosen[4];

  repeat
   error:=false;
   readln(f,first_name);
   point:=pos('.',first_name);
   mat_name:=copy(first_name,1,point)+'mat';

   assign(m1,mat_name);
   {$I-}
   reset(m1);
   {$I+}
   if ioresult<>0 then begin
     error:=true;
     writeln(g,'         ');
   end;

   if not error then begin
     mag_sn:='';mag_cs:='';mag_cs2:='';mag_cs3:='';
     load_fts(first_name);

     write(coord,juldate:10:6);

     for i:=1 to variable.n do readln(m1,rec);
     if itemcount(rec) <> 0 then
        begin
         mag_s:=itemstr(apen,rec);val(mag_s,mag,io);

         write(coord,'  ',itemstr(2,rec),' ',itemstr(3,rec));

         if mag_s='99.999' then mag_sn:='99.999';
         mag_sn:=mag_s;
         readln(m1,rec);
         mag_ds:=itemstr(apen,rec);val(mag_ds,mag_dv,io);
        End
     else begin mag_sn:='99.999';mag_dv:=0; {star not found}
         write(coord,'   -1.000  -1.000');
     end;
     close(m1);

     assign(m1,mat_name);
     reset(m1);
     for i:=1 to comp_1.n do readln(m1,rec1);
     if itemcount(rec1) <> 0 then
        begin
         mag_s:=itemstr(apen,rec1);val(mag_s,mag_c,io);

         write(coord,'  ',itemstr(2,rec1),' ',itemstr(3,rec1));

         if mag_s='99.999' then mag_cs:='99.999';
         readln(m1,rec1);
         mag_ds:=itemstr(apen,rec1);val(mag_ds,mag_dc,io);
        End
     else begin mag_cs:='99.999';mag_dc:=0;
        write(coord,'   -1.000  -1.000');
     end;
     close(m1);

     assign(m1,mat_name);
     reset(m1);
     for i:=1 to comp_2.n do readln(m1,rec2);
     if itemcount(rec2) <> 0 then
        begin
         mag_s:=itemstr(apen,rec2);val(mag_s,mag_c2,io);

         write(coord,'  ',itemstr(2,rec2),' ',itemstr(3,rec2));

         if mag_s='99.999' then mag_cs2:='99.999';
         readln(m1,rec2);
         mag_ds:=itemstr(apen,rec2);val(mag_ds,mag_dc1,io);
        End
     else begin mag_cs2:='99.999';mag_dc1:=0;
        write(coord,'   -1.000  -1.000');
     end;
     close(m1);

     assign(m1,mat_name);
     reset(m1);
     for i:=1 to comp_3.n do readln(m1,rec3);
     if itemcount(rec3) <> 0 then
        begin
         mag_s:=itemstr(apen,rec3);val(mag_s,mag_c3,io);

         write(coord,'  ',itemstr(2,rec3),' ',itemstr(3,rec3));

         if mag_s='99.999' then mag_cs3:='99.999';
         readln(m1,rec3);
         mag_ds:=itemstr(apen,rec3);val(mag_ds,mag_dc2,io);
        End
     else begin mag_cs3:='99.999'; mag_dc2:=0;
        write(coord,'   -1.000  -1.000');
     end;
     close(m1);

     writeln(coord);

     if (mag_sn <> '99.999') and (mag_cs <> '99.999') then
      begin
       mc:=mag-mag_c;
       dvc:=sqrt(mag_dv*mag_dv+mag_dc*mag_dc);
      end

      else mc:=99.999;

     if (mag_sn <> '99.999') and (mag_cs2 <> '99.999') then
      begin
       mc1:=mag-mag_c2;
       dvc1:=sqrt(mag_dv*mag_dv+mag_dc1*mag_dc1);
      end
      else mc1:=99.999;

     if (mag_sn <> '99.999') and (mag_cs3 <> '99.999') then
      begin
       mc2:=mag-mag_c3;
       dvc2:=sqrt(mag_dv*mag_dv+mag_dc2*mag_dc2);
      end
      else mc2:=99.999;

     if (mag_cs <> '99.999') and (mag_cs2 <> '99.999') then
      begin
       mc3:=mag_c-mag_c2;
       dcc1:=sqrt(mag_dc*mag_dc+mag_dc1*mag_dc1);
       end
      else mc3:=99.999;

     if (mag_cs <> '99.999') and (mag_cs3 <> '99.999') then
      begin
       mc4:=mag_c-mag_c3;
       dcc2:=sqrt(mag_dc*mag_dc+mag_dc2*mag_dc2);
      end
      else mc4:=99.999;

     if (mag_cs2 <> '99.999') and (mag_cs3 <> '99.999') then
      begin
       mc5:=mag_c2-mag_c3;
       dc1c2:=sqrt(mag_dc1*mag_dc1+mag_dc2*mag_dc2);
      end
      else mc5:=99.999;

     writeln(g,juldate:10:6,' ',mc:4:3,' ',dvc:4:3,' ',mc1:4:3,' ',
     dvc1:4:3,' ',mc2:4:3,' ',dvc2:4:3,' ',mc3:4:3,' ',dcc1:4:3,' ',mc4:4:3,' ',dcc2:4:3,' ',
     mc5:4:3,' ',dc1c2:4:3);

     mag_s:=''; mag_cs:=''; mag_cs2:=''; mag_cs3:='';
     error:=false;

    end;

  until eof(f);

  close(coord);

 end


 {writing instrumental magnitudes (newer part, more transparent I hope :)}
 else begin

  assign(coord, paramstr(3)+'\results\coordin.dat'); {file with coordinates}
  {$I-}
  rewrite(coord);
  {$I+}
  if ioresult <> 0 then file_chyba(paramstr(3)+'\results\coordin.dat');

  writeln(coord,'# JD and X,Y coordinates of ',numchos,' stars selected during photometry');
  writeln(coord,'# (in pixels; -1.000 means that star was not found)');

  repeat
   error:=false;
   readln(f,first_name);
   point:=pos('.',first_name);
   mat_name:=copy(first_name,1,point)+'mat';

   assign(m1,mat_name);
   {$I-}
   reset(m1);
   {$I+}
   if ioresult<>0 then begin
     writeln(g,'         ');
   end

   else begin {.mat file opened successfully}
     close(m1);
     load_fts(first_name);

     for j:=1 to numchos do begin {reading all chosen stars from .mat file}
       mag_s:='';
       reset(m1);

       for i:=1 to chosen[j].n do readln(m1,rec); {skipping to star's row in MAT}

       if itemcount(rec) <> 0 then begin {parsing the row}
         mag_s:= itemstr(apen,rec);
         val(mag_s,chos_ph[j].mag,io);
         val(itemstr(2,rec),chos_ph[j].xc,io);
         val(itemstr(3,rec),chos_ph[j].yc,io);

         readln(m1,rec); {skipping to next row to read sigma}
         val(itemstr(apen,rec),chos_ph[j].sigma,io);

         if mag_s='99.999' then begin
           chos_ph[j].mag:= 99.999;
           chos_ph[j].sigma:= 0.0;
           chos_ph[j].bad:= true;
         end
         else chos_ph[j].bad:= false;
       end

       else begin  {star not found at this image}
         chos_ph[j].mag:= 99.999;
         chos_ph[j].sigma:= 0.0;
         chos_ph[j].xc:= -1.000;
         chos_ph[j].yc:= -1.000;
         chos_ph[j].bad:= true;
       end;

       close(m1);
     end; {of reading this .mat file}

     write(g,juldate:10:6);
     write(coord,juldate:10:6);
     for j:=1 to numchos do begin
       write(g,' ',chos_ph[j].mag:4:3,' ',chos_ph[j].sigma:4:3);
       write(coord,'  ',chos_ph[j].xc:7:3,' ',chos_ph[j].yc:7:3);
     end;
     writeln(g);
     writeln(coord);
   end;

  until eof(f);

  close(coord);

 end;

 close(g);close(f);
end; (* OF Analyzing_all_files *)


{============================================================================}


Begin   (* Begin of main program *)
clrscr;

nosound;
if paramcount<5 then help;

if (paramstr(4)='l') then auto:= true
else auto:=false; {select stars manually or load from file?}

if (paramstr(5)='d') then difmags:=true
else difmags:=false; {write differential or instrumental magnitudes as the output?}

again:=true;
mx:=0;my:=0;
ReadAperture(apen);

{LK}
if auto=false then begin
  mys;
  screen;
  Legend;
  read_mat_file;
  mouseon;
  Chose_Stars;
  mouseoff;
end
else begin {reading old numbers of chosen stars from file oldstars.dat}
  errc:=0;

  assign(te,'bin\oldstars.dat');
  {$I-}
  reset(te);
  {$I+}
  if IOresult<>0 then crash('Error reading numbers of chosen stars from oldstars.dat!');

  numchos:=0;
  while not eof(te) do begin
    inc(numchos);
    readln(te,tmps);
    val(tmps,chosen[numchos].n,ec);
    errc:= errc + ec;
  end;

  close(te);

  if errc<>0 then crash ('Error reading old numbers of chosen stars!');
end;

Analyzing_all_files;

if auto=false then closegraph;

SaveStars;

{/LK}

textcolor(white);
textbackground(black);
clrscr;
end.  (* end of main program *)