 {~ Displays a CCD image from ST7 SBIG camera or a FITS 16-bit image, ~}
 {~  using standard(!) VESA 800x600~}

program FITSSTVw;
      {edited by David Farinic from some his programme,
      just to show us how VESA extended screen modes can be used.
      Then edited by J.Hollan to reject non-VESA cards
      and to show ST7 CCD images.
      FITS format reading added June 1997 by Jan Hollan.
      An alternative

       BGI SVGA mode added from s7svga draft by Jan Hollan, January 1998 }

{a draft version giving linear or logarithmic gray scaling}

uses  {standard TP unit:} dos, graph,
      {J.H.'s units:} angles_o, str_num,{g_scree,}ftbridge;

Type
  Condition = (UNK,Range,Background,Width,Height);
const LH=16383; li255:longint=255;
Var
  Symb : Condition; Name:string; Value:word;
  Bott_perc,Top_perc: longint;
  Mean: byte;
  Histogram: array[0..LH] of word;
  Linear:boolean;
  GraphDriver : integer;  { The Graphics device driver }
  GraphMode   : integer;  { The Graphics mode value }
  ErrorCode   : integer;  { Reports any graphics errors }
  MaxColor    : word;     { The maximum color value available }
  OldExitProc : Pointer;  { Saves exit procedure address }
const
 Distrib: longint=0;
 top: word=255;
 bottom: word=0;
 FitsKind:boolean=false;

 DirectVESA:boolean=false;  {false means using SVGA.bgi and Graph module}

 divide_by:byte=1;    {square of this side will be represented by one point}


  NofCon=5;
  SwitchArray : array[1..NofCon] of string[10] =
   ('UNK','Range','Background','Width','Height');
  CondArray : array[1..NofCon] of Condition =
    (UNK,Range,Background,Width,Height);
  Opened_file:boolean=false;
  compressed:boolean=false;


 {mode=$101;}
 mode=$103;

  offs: word=$A000;
  Rang: word = 255;
  Back: word = 0;
  col: word = 1;
  line : word = 1;

  ADD: BYTE=0;
var
 stri:string; inh:text;
 m:byte;
 inp: file;
 bufcw:FtImLine2Type;
 bufw: FtImLine2Type absolute FtImLine2;
 bufcb: FtImLine1Type absolute FtImLine2;
 bufcs: array[1..1600] of shortint absolute FtImLine2;
 bufb: array[1..800] of byte;
 NumRead: integer;
 aux_s:string;


 actupage,  c_line:word;
 granul,d255:byte;
 h,hdiv,w,wdiv,linediv,rest,ww:word;
 RangMul:longint;
 i:integer;
 reg:registers;

{Just DirectVESA stuff:}

  procedure  PutPixelMy(xs,ys:word;cc:byte); assembler;
  asm
   mov cx,xs
   mov dx,ys
   push ds
{   mov ax,640d} (*sirka v pixloch obrazovky*)
   mov ax,800d
   mul dx
   add ax,cx
   adc dx,0
   mov w,ax
   cmp actupage,dx
   je @speedup
   mov actupage,dx
          mov   ax, 4F05h
          xor   bx, bx
          mov   cl, granul
          mov   dx, actupage
          shl   dx, cl
          int   10h

   @speedup:
   mov al,cc
   mov bl,al
   mov ax,w
   mov cx,$a000
   mov ds,cx
   mov si,ax
   mov [si],bl
   pop ds
  end;

  procedure Ende (msg: String);
  begin
   asm
    mov ax,3
    int 10h
   end;
   writeln(msg);
   HALT
  end;

  procedure setpal(where:pointer;od,how:word);assembler;
  asm
     pusha
     pushf
     push ds
     mov cx,how
     mov dx,03dah
   @retrace1:
     in  al,dx
     and al,8
     jnz @retrace1
   @retrace2:
     in  al,dx
     and al,8
     jz  @retrace2
   @znova:
     mov dx,03c8h
     mov ax,od
     cli
     out dx,al
     inc dx
     lds si,[where]
     mov ax,cx
     add cx,ax
     add cx,ax
     cld
     rep outsb
     sti
     pop ds
     popf
     popa
  end;

  procedure paletta(bb:byte);
  var
   tempal:array[0..768]of byte; IntLn:real; cc:byte;
  begin
   if bb=0 then
    begin
     Linear:=true;
        for I := 0 to 255 do
         begin
          temPal[I*3] := I shr 2;
          temPal[I*3+1] :=I shr 2;
          temPal[I*3+2] :=I shr 2;
         end
    end
   else
      begin
        Linear:=false;
        IntLn:=ln(255)/62;
        for I := 0 to 255 do
         begin
          cc:=trunc(ln(I+1)/IntLn);
          temPal[I*3] :=cc;
          temPal[I*3+1] :=cc;
          temPal[I*3+2] :=cc;
         end;
      end;
   setpal(addr(tempal),0,256);
  end;

  procedure initvesa;
  begin
   reg.AX := $4F02;
   reg.BX := mode;
   intr($10,reg);
   (*112h-64048016m,101h-640480256,103h-800600256*)
   granul:=4;
   if reg.ax<>$004f then
    begin
     writeln('VESA video mode $',mode,' is not available.');
     halt
    end;
  end; {of InitVESA}

{end of DirectVESA stuff}

{Just BGI (instead of DirectVESA) stuff:}
  {$F+}
  procedure MyExitProc;
  begin
    ExitProc := OldExitProc; { Restore exit procedure address }
    CloseGraph;              { Shut down the graphics system }
  end; { MyExitProc }
  {$F-}

  {$F+}
  function DetectSVGA256 : integer;
  { Detects ?VGA or MCGA video cards }
  var
    DetectedDriver : integer;
    SuggestedMode  : integer;
  begin
    DetectGraph(DetectedDriver, SuggestedMode);
    if (DetectedDriver = VGA) or (DetectedDriver = MCGA) then
      DetectSVGA256 := 3        { Default video mode = 0 }
    else
      DetectSVGA256 := grError; { Couldn't detect hardware }
  end; { DetectVGA256 }
  {$F-}

  var
    AutoDetectPointer : pointer;

  function Int2Str(L : LongInt) : string;
  { Converts an integer to a string for use with OutText, OutTextXY }
  var
    S : string;
  begin
    Str(L, S);
    Int2Str := S;
  end; { Int2Str }


  procedure Initialize;
  { Initialize graphics and report any errors that may occur }
  var
    InGraphicsMode : boolean; { Flags initialization of graphics mode }
    PathToDriver   : string;  { Stores the DOS path to *.BGI & *.CHR }
  begin
    { when using Crt and graphics, turn off Crt's memory-mapped writes }
  {  DirectVideo := False;}
    OldExitProc := ExitProc;                { save previous exit proc }
    ExitProc := @MyExitProc;                { insert our exit proc in chain }
    PathToDriver :=paramstr(2);
    repeat

     AutoDetectPointer := @DetectSVGA256;   { Point to detection routine }
      GraphDriver := InstallUserDriver('SVGA256', AutoDetectPointer);
      GraphDriver := Detect;
      InitGraph(GraphDriver, GraphMode, PathToDriver);
      ErrorCode := GraphResult;             { preserve error return }
      if ErrorCode <> grOK then             { error? }
      begin
        Writeln('Graphics error: ', GraphErrorMsg(ErrorCode));
        if ErrorCode = grFileNotFound then  { Can't find driver file }
         begin
          Writeln('Enter full path to BGI driver or type <Enter> to quit:');
          Readln(PathToDriver);
          if PathToDriver='' then halt;
          Writeln;
         end
        else
         Halt(1);                          { Some other error: terminate }
      end;
    until ErrorCode = grOK;
    MaxColor := GetMaxColor;  { Get the maximum allowable drawing color }
  end; { Initialize }

  procedure Set256Palette(bb:byte);
  type
    RGBColor   = record
                   R, G, B : byte;
                 end;
    VGAPalette = array[0..255] of RGBColor;
  var
    VGAPal   : VGAPalette;
    IntLn:real; cc:byte;

  procedure SetDACBlock(Start, Count : integer; var Pal : VGAPalette);
  var
    Regs : Registers;
  begin
    with Regs do
    begin
      AH := $10;
      AL := $12;
      BX := Start;
      CX := Count;
      ES := Seg(Pal);
      DX := Ofs(Pal);
    end;
    Intr($10, Regs);
  end;

  begin
   if bb=0 then
    begin
     Linear:=true;
      for w:=0 to MaxColor do
        with VGAPal[w] do begin R:=w shr 2; G:=w shr 2; B:=w shr 2 end;
    end
   else
      begin
        Linear:=false;
        IntLn:=ln(255)/62;
        for w := 0 to MaxColor do
         begin
          cc:=trunc(ln(w+1)/IntLn);
          with VGAPal[w] do begin R:=cc; G:=cc; B:=cc end;
         end;
      end;
   SetDACBlock(0, 256, VGAPal);
  end; { Set256Palette }

{end of bgi (instead of DirectVESA) stuff}


Procedure ReadSline;
begin
 if FitsKind then
  begin
   if FtReadIm(h,bufcb) then
  end
 else
    if compressed then
     begin
      BlockRead(inp,c_line,2,NumRead);
      if c_line=line then
       BlockRead(inp,bufw,c_line,NumRead)
      else
       begin
        BlockRead(inp,bufcb,c_line,NumRead);
        ww:=1;
        bufw[ww]:=bufcw[ww];
        w:=2;
        while w<c_line do
         begin
          inc(w);inc(ww);
          if bufcb[w]<>128 then
           bufw[ww]:=bufw[ww-1]+bufcs[w]
          else
           begin
            inc(w);
            bufw[ww]:=bufcb[w];
            inc(w);
            bufw[ww]:=bufw[ww]+ bufcb[w] shl 8
           end
         end;
       end
     end
    else
     BlockRead(inp,bufw,line,NumRead);
end;

procedure WritePixel(hmin,wmin:word);
 begin
  if FitsKind then
   begin
    hmin:=(hmin * divide_by) - (divide_by-1);
    wmin:=(wmin * divide_by) - (divide_by-1);
    for h:=hmin to hmin+(divide_by -1) do
     begin
      ReadSline;
       for w:=wmin to wmin+(divide_by -1) do
        write(bufw[w]:6);
      writeln;
     end;
    end;
 end;

begin
FillChar(Histogram[0],(LH+1) shl 1,$0);
if ParamCount>0 then
 if FtInit(paramstr(1),0) then
  begin
   FitsKind:=true;
   line:=FtRecl div 2;
   col:=FtNuRec;
  end
 else
  if rt_reset('',inh,paramstr(1)) then
   begin
    Opened_file:=true;
    readln(inh,stri);
    if pos('Compressed',stri)>0 then compressed:=true;
    for i:=2 to 30 do
     begin
      readln(inh,stri);
      h:=pos(' ',stri);
      if h>0 then
       begin
        Name:=copy(stri,1,h-1);
        Symb:=UNK;
        for w:= 1 to NofCon do
         if Name=SwitchArray[w] then Symb:=CondArray[w];
        if Symb<>UNK then
         begin
           Value:=round(
             N_S(copy(stri,pos('=',stri)+2,length(stri)-pos('=',stri)-2)));
           case Symb of
            Range : Rang:=Value;
            Background: Back:=Value;
            Width : line:=Value;
            Height : col:=Value;
           end;
         end;
       end;
     end;
    close(inh);
   end;

if Back>50 then Back:=Back-50;

if Opened_file and (not FitsKind) then
 begin
  assign(inp,paramstr(1));
  if compressed then
   begin
    reset(inp,1);
    seek(inp,$800);
   end
  else
   begin
    reset(inp,2);
    seek(inp,$400);
   end;
 end;

if DirectVESA then
 begin
  initvesa;
  actupage:=0;
  paletta(0);
  for i:=0 to 599  do
   putpixelMy(i,i,i mod 256);
 end
else
 begin
  Initialize;
  Set256Palette(255);
  for w:=0 to 599  do
   putpixel(w,w,w mod 256);
  setcolor(60);
 end;

if Opened_file or FitsKind then
 begin
  if DirectVESA then putpixelMy(10,20,30) else putpixel(10,20,30);
  rest:=800 - (add+1)*64;

  if FitsKind or (ParamCount=1) then
   begin
    for h:=1 to col do
     begin
      readSline;
      for w:=1 to line do inc(Histogram[bufw[w] shr 2]);
     end;
    Bott_perc:=trunc(col*line*0.25);
    Top_perc:=trunc(0.9999*col*line);
    w:=0;
    while bottom=0 do
     begin
      inc(Distrib,Histogram[w]);
      if Distrib>Bott_perc then Bottom:=w shl 2;
      inc(w)
     end;
    while (top=255) and (w<LH+1) do
     begin
      inc(Distrib,Histogram[w]);
      if Distrib>=Top_perc then Top:=w shl 2;
      inc(w);
     end;
    rang:=top-bottom;

    if not FitsKind then
     if compressed then
      seek(inp,$800)
     else
      seek(inp,$400);

  end {of FindRange}
  else
   begin
    Bottom:=Back;
    Top:=bottom+rang;
   end;

  fillchar(bufb,800,$0);
  linediv:= 1 + (line-1) div divide_by;
  rangmul:=rang * sqr(divide_by);
  d255:=255 div sqr(divide_by);

  for h:=1 to col do
   begin
    readSline;

    for w:=1 to line do
     begin
      wdiv:= 1 + (w-1) div divide_by;
      if bufw[w]<bottom then {bufb[wdiv]:=0}
      else
       if bufw[w]>top then bufb[wdiv]:=bufb[wdiv] + d255
       else
        bufb[wdiv]:=bufb[wdiv]
          + ((bufw[w] - bottom) * li255) div rangmul;
     end;

    if h mod divide_by = 0  then
     begin
      hdiv:= 1 + (h-1) div divide_by;
      if hdiv mod 82 <> 0  then
       Move(bufb[1], Mem[offs:0], linediv)
      else
       if linediv > rest then
        begin
         Move(bufb[1], Mem[offs:0], rest);
         if DirectVESA then PUTPIXELmy(hdiv,hdiv,1) else PUTPIXEL(hdiv,hdiv,1);
         OFFS:=$A000;
         Move(bufb[rest+1], Mem[offs:0], linediv-rest);
        end
       else
        Move(bufb[1], Mem[offs:0], linediv);
      inc(offs,{20}50);
      if hdiv mod 82 = 0  then
       begin
        if DirectVESA then PUTPIXELmy(hdiv,hdiv,1) else PUTPIXEL(hdiv,hdiv,1);
        OFFS:=$A000;
        INC(ADD,4);
        rest:=800 - (add div 4 + 1)*64;
        INC(offs,ADD);
       end;
      fillchar(bufb,800,$0);
     end;
   end;

   {WritePixel(x,y);
    (* writes square of words corresponing to the x,y pixel *)
   }

  if FitsKind then FtClose else close(inp);
 end;


repeat
 Readln(aux_s);


 {if aux_s='p' then prigscrc;}
 if aux_s<>'' then
  if Linear then
   if DirectVESA then paletta(1) else Set256Palette(1)
  else
   if DirectVESA then paletta(0) else Set256Palette(0);
until aux_s='';

if DirectVESA then
 ende('Bottom:'+SI(5,Bottom)+'  Range:'+SI(5,Rang))
else
 begin
  Closegraph;
  writeln('Bottom:'+SI(5,Bottom)+'  Range:'+SI(5,Rang))
 end;

end.
