program Phase_of_Eclipsing_Binary;
uses dos,crt;

var                 data,output : Text;
    jdm,jd0,phase,mag,period,m0 : Real;
                     i,epoch,io : Integer;
                            rec : String;

Procedure help;
begin
writeln;
writeln('Some error...');
highvideo;
writeln('phase.exe <input.dat> <output.faze> P Base_Moom');
normvideo;
writeln;
writeln('where:');
writeln('        input.dat is an ASCII data file - JD vs. Mag');
writeln('        output.faze is ASCII output - Phase vs. Mag');
writeln('        P is a period of a binary');
writeln('        Base_Moom is a base minimum of a binary');
writeln;
lowvideo;
writeln('Example: phase.exe grtau.dat grtau.out 0.4298525 2444573.1071');
normvideo;
writeln;
writeln;
highvideo;
writeln('(c) Rudolf Novak, e-mail:rudolfn@physics.muni.cz');
writeln('Nicholas Copernicus Observatory');
writeln('Brno 616 00');
writeln('Czech Republic');
normvideo;
halt;
end;

Procedure chyba;
begin
writeln('Some error during reading parameters!');
delay(1000);
help;
end;

begin
 clrscr;
 if (paramcount<>4) or (paramstr(1)='/?')then help;
 clrscr;
 io:=0;
 assign(data,paramstr(1));
 reset(data);
 assign(output,paramstr(2));
 rewrite(output);
 val(paramstr(3),period,io);
 if io <> 0 then chyba;
 io:=0;
 val(paramstr(4),m0,io);
 if io <> 0 then chyba;
 writeln('Seems that`s all right. Here we go...');
 writeln('Counting phase of light curve. Wait a bit...');
 for i:=1 to 2 do begin readln(data,rec);writeln(output,rec); end;
repeat
 readln(data,jdm,rec);
 epoch:=trunc((jdm-m0)/period);
 phase:=(jdm-(m0+epoch*period))/period;
 writeln(output,phase:4:3,' ',rec);
until eof(data);
sound(100);
nosound;
writeln('Done.');
close(data);
close(output);
end.