unit scrcopy;

interface

procedure saveBMP(xstart,ystart,xend,yend:integer; filename:string; var error:boolean);
{Copies given part of screen in graph mode (must be 16 color VGA!)
 and saves it to uncompressed BMP file}


implementation

uses graph;

procedure saveBMP(xstart,ystart,xend,yend:integer; filename:string; var error:boolean);

type TBitmapFileHeader = record
       bfType: Word;
       bfSize: Longint;
       bfReserved1: Word;
       bfReserved2: Word;
       bfOffBits: Longint;
     end;

TBitmapInfoHeader = record
  biSize: Longint;
  biWidth: Longint;
  biHeight: Longint;
  biPlanes: Word;
  biBitCount: Word;
  biCompression: Longint;
  biSizeImage: Longint;
  biXPelsPerMeter: Longint;
  biYPelsPerMeter: Longint;
  biClrUsed: Longint;
  biClrImportant: Longint;
end;

TRGBQuad = record
  rgbBlue: Byte;
  rgbGreen: Byte;
  rgbRed: Byte;
  rgbReserved: Byte;
end;

BMPheader = record
    head  : TBitmapFileHeader;
    info  : TBitmapInfoHeader;
    table : array[0..15] of TRGBQuad;
end;


{:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}


var hd : file of BMPheader;
    f1,f2 : file of byte;
    b:byte;
    header : BMPheader;
    i,j,width,height,rowfullsize :longint;
    n : integer;
    pix1,pix2 : word;

{===========================================================}

begin

error:= false;

if (xend>getmaxx) or (yend>getmaxy) or (xstart<0) or (ystart<0) or
   (xstart>xend) or (ystart>yend) then begin
  error:= true;
  exit;
end;

width:= xend - xstart + 1;
height:= yend - ystart + 1;

if (width mod 8) = 0 then rowfullsize:= width div 2
else begin
  if (width mod 2 = 0) then rowfullsize:= (width div 2) + 4
     - (width div 2) mod 4
  else begin
    if (((width div 2) + 1) mod 4)<>0 then
      rowfullsize:= ((width div 2) + 1) + 4 - ((width div 2) + 1) mod 4
    else rowfullsize:= (width div 2) + 1;
  end;
end;
{size of 1 row in resulting BMP file in bytes}

with header do begin

  with head do begin
    bftype:= 19778; {'BM' chars encoded in 2 bytes of word}
    bfsize:= rowfullsize*height + 118;  {file size in bytes}
    bfReserved1:= 0;
    bfReserved2:= 0;
    bfOffBits:= 118; {byte offset of the image itself from the file beginning}
  end;

  with info do begin
    biSize:= 40; {bytes occupied by this structure "info"}
    biWidth:= width; {pixels}
    biHeight:= height; {pixels}
    biPlanes:= 1;
    biBitCount:= 4; {bits per pixel}
    biCompression:= 0; {no compression}
    biSizeImage:= rowfullsize*height; {bytes of the image without headers}
    biXPelsPerMeter:= 0;
    biYPelsPerMeter:= 0;
    biClrUsed:= 16;
    biClrImportant:= 16;
  end;

{color table definition - 16 color VGA palette}

  with table[0] do begin {black}
    rgbBlue:= 0;
    rgbGreen:= 0;
    rgbRed:= 0;
    rgbReserved:= 0;
  end;

  with table[1] do begin {blue}
    rgbBlue:= 163;
    rgbGreen:= 0;
    rgbRed:= 0;
    rgbReserved:= 0;
  end;

  with table[2] do begin {green}
    rgbBlue:= 0;
    rgbGreen:= 163;
    rgbRed:= 0;
    rgbReserved:= 0;
  end;

  with table[3] do begin {cyan}
    rgbBlue:= 163;
    rgbGreen:= 163;
    rgbRed:= 0;
    rgbReserved:= 0;
  end;

  with table[4] do begin {red}
    rgbBlue:= 31;
    rgbGreen:= 31;
    rgbRed:= 163;
    rgbReserved:= 0;
  end;

  with table[5] do begin {magenta}
    rgbBlue:= 163;
    rgbGreen:= 0;
    rgbRed:= 163;
    rgbReserved:= 0;
  end;

  with table[6] do begin {brown}
    rgbBlue:= 0;
    rgbGreen:= 123;
    rgbRed:= 163;
    rgbReserved:= 0;
  end;

  with table[7] do begin {lightgray}
    rgbBlue:= 199;
    rgbGreen:= 199;
    rgbRed:= 199;
    rgbReserved:= 0;
  end;

  with table[8] do begin {darkgray}
    rgbBlue:= 107;
    rgbGreen:= 107;
    rgbRed:= 107;
    rgbReserved:= 0;
  end;

  with table[9] do begin {lightblue}
    rgbBlue:= 255;
    rgbGreen:= 0;
    rgbRed:= 0;
    rgbReserved:= 0;
  end;

  with table[10] do begin  {lightgreen}
    rgbBlue:= 39;
    rgbGreen:= 255;
    rgbRed:= 39;
    rgbReserved:= 0;
  end;

  with table[11] do begin  {lightcyan}
    rgbBlue:= 255;
    rgbGreen:= 255;
    rgbRed:= 0;
    rgbReserved:= 0;
  end;

  with table[12] do begin {lightred}
    rgbBlue:= 43;
    rgbGreen:= 43;
    rgbRed:= 255;
    rgbReserved:= 0;
  end;

  with table[13] do begin {lightmagenta}
    rgbBlue:= 255;
    rgbGreen:= 0;
    rgbRed:= 179;
    rgbReserved:= 0;
  end;

  with table[14] do begin {yellow}
    rgbBlue:= 75;
    rgbGreen:= 255;
    rgbRed:= 255;
    rgbReserved:= 0;
  end;

  with table[15] do begin {white}
    rgbBlue:= 255;
    rgbGreen:= 255;
    rgbRed:= 255;
    rgbReserved:= 0;
  end;

end;

assign(hd,'head.tmp');
{$I-}
rewrite(hd);
{$I+}
if IOresult<>0 then begin
  error:= true;
  exit;
end;

write(hd,header);

close(hd);

assign(f1,'head.tmp');
assign(f2,filename);

{$I-}
reset(f1);
{$I+}
if IOresult<>0 then begin
  error:= true;
  exit;
end;

{$I-}
rewrite(f2);
{$I+}
if IOresult<>0 then begin
  error:= true;
  close(f1);
  exit;
end;

for i:= 1 to 118 do begin {copying header to new BMP file}
  read(f1,b);
  write(f2,b);
end;

close(f1);

b:= 0;
pix1:= 0;
pix2:= 0;


for j:=height downto 1 do begin

  if (width mod 2)=0 then begin

    i:= 0;

    repeat
      inc(i);
      pix1:= getpixel(i,j);
      inc(i);
      pix2:= getpixel(i,j);
      b:= pix2 + 16*pix1; {combining two 4-bit values to one byte}
      write(f2,b);
    until i=width;

    b:= 0;
    for n:=1 to (rowfullsize - width div 2) do write(f2,b); {zero-padding to 32-bit boundary}

  end

  else begin

    i:=0;

    repeat
      inc(i);
      pix1:= getpixel(i,j);
      inc(i);
      pix2:= getpixel(i,j);
      b:= pix2 + 16*pix1; {combining two 4-bit values to one byte}
      write(f2,b);
    until i=(width-1);

    inc(i);
    pix1:= getpixel(i,j);
    b:= 16*pix1;
    write(f2,b);

    b:= 0;
    for n:=1 to (rowfullsize - (width div 2 + 1)) do write(f2,b); {zero-padding to 32-bit boundary}

  end;

end;

close(f2);
erase(f1); {removing temporary header file}

end;

end.